/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;
import com.oracle.truffle.api.profiles.ValueProfile;
import java.util.Objects;

public abstract class PrimitiveValueProfile
extends ValueProfile {
    PrimitiveValueProfile() {
    }

    @Override
    public abstract <T> T profile(T var1);

    public abstract byte profile(byte var1);

    public abstract short profile(short var1);

    public abstract int profile(int var1);

    public abstract long profile(long var1);

    public abstract float profile(float var1);

    public abstract double profile(double var1);

    public abstract boolean profile(boolean var1);

    public abstract char profile(char var1);

    public static PrimitiveValueProfile createEqualityProfile() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.create();
        }
        return Disabled.INSTANCE;
    }

    @Deprecated
    public static boolean exactCompare(float a, float b) {
        return Float.floatToRawIntBits(a) == Float.floatToRawIntBits(b);
    }

    @Deprecated
    public static boolean exactCompare(double a, double b) {
        return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b);
    }

    static final class Disabled
    extends PrimitiveValueProfile {
        static final PrimitiveValueProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        public <T> T profile(T value) {
            return value;
        }

        @Override
        public byte profile(byte value) {
            return value;
        }

        @Override
        public short profile(short value) {
            return value;
        }

        @Override
        public int profile(int value) {
            return value;
        }

        @Override
        public long profile(long value) {
            return value;
        }

        @Override
        public float profile(float value) {
            return value;
        }

        @Override
        public double profile(double value) {
            return value;
        }

        @Override
        public boolean profile(boolean value) {
            return value;
        }

        @Override
        public char profile(char value) {
            return value;
        }

        public String toString() {
            return this.toStringDisabled(PrimitiveValueProfile.class);
        }
    }

    static final class Enabled
    extends PrimitiveValueProfile {
        private static final Object UNINITIALIZED = new Object();
        private static final Object GENERIC = new Object();
        @CompilerDirectives.CompilationFinal
        private Object cachedValue = UNINITIALIZED;

        Enabled() {
        }

        @Override
        public <T> T profile(T v) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                T value = v;
                if (snapshot instanceof Byte ? value instanceof Byte && ((Byte)snapshot).byteValue() == ((Byte)value).byteValue() : (snapshot instanceof Short ? value instanceof Short && ((Short)snapshot).shortValue() == ((Short)value).shortValue() : (snapshot instanceof Integer ? value instanceof Integer && ((Integer)snapshot).intValue() == ((Integer)value).intValue() : (snapshot instanceof Long ? value instanceof Long && ((Long)snapshot).longValue() == ((Long)value).longValue() : (snapshot instanceof Float ? value instanceof Float && Enabled.exactCompare(((Float)snapshot).floatValue(), ((Float)value).floatValue()) : (snapshot instanceof Double ? value instanceof Double && Enabled.exactCompare((Double)snapshot, (Double)value) : (snapshot instanceof Boolean ? value instanceof Boolean && ((Boolean)snapshot).booleanValue() == ((Boolean)value).booleanValue() : (snapshot instanceof Character ? value instanceof Character && ((Character)snapshot).charValue() == ((Character)value).charValue() : snapshot == value)))))))) {
                    return (T)snapshot;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(value);
            }
            return v;
        }

        @Override
        public byte profile(byte value) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                if (snapshot instanceof Byte && (Byte)snapshot == value) {
                    return (Byte)snapshot;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(value);
            }
            return value;
        }

        @Override
        public short profile(short value) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                if (snapshot instanceof Short && (Short)snapshot == value) {
                    return (Short)snapshot;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(value);
            }
            return value;
        }

        @Override
        public int profile(int value) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                if (snapshot instanceof Integer && (Integer)snapshot == value) {
                    return (Integer)snapshot;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(value);
            }
            return value;
        }

        @Override
        public long profile(long value) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                if (snapshot instanceof Long && (Long)snapshot == value) {
                    return (Long)snapshot;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(value);
            }
            return value;
        }

        @Override
        public float profile(float value) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                if (snapshot instanceof Float && Enabled.exactCompare(((Float)snapshot).floatValue(), value)) {
                    return ((Float)snapshot).floatValue();
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(Float.valueOf(value));
            }
            return value;
        }

        @Override
        public double profile(double value) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                if (snapshot instanceof Double && Enabled.exactCompare((Double)snapshot, value)) {
                    return (Double)snapshot;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(value);
            }
            return value;
        }

        @Override
        public boolean profile(boolean value) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                if (snapshot instanceof Boolean && (Boolean)snapshot == value) {
                    return (Boolean)snapshot;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(value);
            }
            return value;
        }

        @Override
        public char profile(char value) {
            Object snapshot = this.cachedValue;
            if (snapshot != GENERIC) {
                if (snapshot instanceof Character && ((Character)snapshot).charValue() == value) {
                    return ((Character)snapshot).charValue();
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowPath(Character.valueOf(value));
            }
            return value;
        }

        private void slowPath(Object value) {
            this.cachedValue = this.cachedValue == UNINITIALIZED ? value : GENERIC;
        }

        boolean isGeneric() {
            return this.cachedValue == GENERIC;
        }

        boolean isUninitialized() {
            return this.cachedValue == UNINITIALIZED;
        }

        Object getCachedValue() {
            return this.cachedValue;
        }

        public String toString() {
            return this.toString(PrimitiveValueProfile.class, this.isUninitialized(), this.isGeneric(), this.formatSpecialization());
        }

        private String formatSpecialization() {
            if (!this.isUninitialized() && !this.isGeneric()) {
                Object snapshot = this.cachedValue;
                if (snapshot == null) {
                    return String.format("value == null", new Object[0]);
                }
                if (snapshot instanceof Byte || snapshot instanceof Short || snapshot instanceof Integer || snapshot instanceof Long || snapshot instanceof Float || snapshot instanceof Double || snapshot instanceof Boolean || snapshot instanceof Character) {
                    return String.format("value == (%s)%s", snapshot.getClass().getSimpleName(), snapshot);
                }
                String simpleName = snapshot.getClass().getSimpleName();
                return String.format("value == %s@%x", simpleName, Objects.hash(snapshot));
            }
            return null;
        }

        static PrimitiveValueProfile create() {
            return new Enabled();
        }
    }
}

