/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.convert.ToLongNodeGen;
import org.jruby.truffle.core.format.exceptions.CantConvertException;
import org.jruby.truffle.core.format.exceptions.NoImplicitConversionException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.MissingBehavior;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class ToLongNode
extends FormatNode {
    private final boolean errorIfNeedsConversion;
    @Node.Child
    private CallDispatchHeadNode toIntNode;
    @Node.Child
    private ToLongNode redoNode;

    public ToLongNode(boolean errorIfNeedsConversion) {
        this.errorIfNeedsConversion = errorIfNeedsConversion;
    }

    public abstract long executeToLong(VirtualFrame var1, Object var2);

    @Specialization
    public long toLong(boolean object) {
        throw new NoImplicitConversionException(object, "Integer");
    }

    @Specialization
    public long toLong(int object) {
        return object;
    }

    @Specialization
    public long toLong(long object) {
        return object;
    }

    @Specialization(guards={"isRubyBignum(object)"})
    public long toLong(DynamicObject object) {
        return Layouts.BIGNUM.getValue(object).longValue();
    }

    @Specialization(guards={"isNil(nil)"})
    public long toLongNil(Object nil) {
        throw new NoImplicitConversionException(nil, "Integer");
    }

    @Specialization(guards={"!isBoolean(object)", "!isInteger(object)", "!isLong(object)", "!isBigInteger(object)", "!isRubyBignum(object)", "!isNil(object)"})
    public long toLong(VirtualFrame frame, Object object) {
        if (this.errorIfNeedsConversion) {
            throw new CantConvertException("can't convert Object to Integer");
        }
        if (this.toIntNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toIntNode = this.insert(DispatchHeadNodeFactory.createMethodCall(true, MissingBehavior.RETURN_MISSING));
        }
        Object value = this.toIntNode.call(frame, object, "to_int", new Object[0]);
        if (this.redoNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.redoNode = this.insert(ToLongNodeGen.create(true, null));
        }
        return this.redoNode.executeToLong(frame, value);
    }
}

