/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.Arrays;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.MissingValue;
import org.jruby.truffle.core.format.read.SourceNode;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadBytesNode
extends FormatNode {
    private final int count;
    private final boolean consumePartial;
    private final ConditionProfile rangeProfile = ConditionProfile.createBinaryProfile();

    public ReadBytesNode(int count, boolean consumePartial) {
        this.count = count;
        this.consumePartial = consumePartial;
    }

    @Specialization(guards={"isNull(source)"})
    public void read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame, this.count);
        throw new IllegalStateException();
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int index = this.advanceSourcePositionNoThrow(frame, this.count, this.consumePartial);
        if (this.rangeProfile.profile(index == -1)) {
            if (this.consumePartial) {
                return MissingValue.INSTANCE;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return Arrays.copyOfRange(source, index, index + this.count);
    }
}

