/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.lang.ref.WeakReference;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;

public abstract class WeakRefPrimitiveNodes {

    @Primitive(name="weakref_object")
    public static abstract class WeakRefObjectPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object weakRefObject(DynamicObject weakRef) {
            return Layouts.WEAK_REF_LAYOUT.getReference(weakRef).get();
        }
    }

    @Primitive(name="weakref_set_object")
    public static abstract class WeakRefSetObjectPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object weakRefSetObject(DynamicObject weakRef, Object object) {
            Layouts.WEAK_REF_LAYOUT.setReference(weakRef, new WeakReference<Object>(object));
            return object;
        }
    }

    @Primitive(name="weakref_new", needsSelf=false)
    public static abstract class WeakRefNewPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject weakRefNew(Object object) {
            return Layouts.WEAK_REF_LAYOUT.createWeakRef(this.coreLibrary().getWeakRefFactory(), new WeakReference<Object>(object));
        }
    }
}

