/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

public abstract class UTF8Operations {
    public static boolean isUTF8ValidOneByte(byte b) {
        return b >= 0;
    }

    public static boolean isUTF8ValidTwoBytes(byte ... bytes) {
        assert (bytes.length == 2);
        if ((bytes[0] & 0xFF) >= 194 && (bytes[0] & 0xFF) <= 223) {
            return (bytes[1] & 0xFF) >= 128 && (bytes[1] & 0xFF) <= 191;
        }
        return false;
    }

    public static boolean isUTF8ValidThreeBytes(byte ... bytes) {
        assert (bytes.length == 3);
        if ((bytes[0] & 0xFF) < 224 || (bytes[0] & 0xFF) > 239) {
            return false;
        }
        if ((bytes[2] & 0xFF) < 128 || (bytes[2] & 0xFF) > 191) {
            return false;
        }
        if ((bytes[1] & 0xFF) >= 128 || (bytes[2] & 0xFF) <= 191) {
            if ((bytes[0] & 0xFF) == 224) {
                return (bytes[1] & 0xFF) >= 160;
            }
            if ((bytes[0] & 0xFF) == 237) {
                return (bytes[1] & 0xFF) <= 159;
            }
            return true;
        }
        return false;
    }

    public static boolean isUTF8ValidFourBytes(byte ... bytes) {
        assert (bytes.length == 4);
        if ((bytes[3] & 0xFF) < 128 || (bytes[3] & 0xFF) > 191) {
            return false;
        }
        if ((bytes[2] & 0xFF) < 128 || (bytes[2] & 0xFF) > 191) {
            return false;
        }
        if ((bytes[0] & 0xFF) < 240 || (bytes[0] & 0xFF) > 244) {
            return false;
        }
        if ((bytes[1] & 0xFF) >= 128 || (bytes[2] & 0xFF) <= 191) {
            if ((bytes[0] & 0xFF) == 240) {
                return (bytes[1] & 0xFF) >= 144;
            }
            if ((bytes[0] & 0xFF) == 244) {
                return (bytes[1] & 0xFF) <= 143;
            }
            return true;
        }
        return false;
    }

    public static boolean isUTF8ValidFiveBytes(byte ... bytes) {
        assert (bytes.length == 5);
        return false;
    }

    public static boolean isUTF8ValidSixBytes(byte ... bytes) {
        assert (bytes.length == 6);
        return false;
    }
}

