/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects.shared;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.language.objects.ShapeCachingGuards;
import org.jruby.truffle.language.objects.shared.ShareObjectNode;
import org.jruby.truffle.language.objects.shared.WriteBarrierNode;

@GeneratedBy(value=WriteBarrierNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class WriteBarrierNodeGen
extends WriteBarrierNode
implements SpecializedNode {
    @CompilerDirectives.CompilationFinal
    private boolean excludeWriteBarrierCached_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeUpdateShapeAndWriteBarrier_;
    @Node.Child
    private BaseNode_ specialization_ = UninitializedNode_.create(this);

    private WriteBarrierNodeGen(int depth) {
        super(depth);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public void executeWriteBarrier(Object arg0Value) {
        this.specialization_.executeVoid(arg0Value);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static WriteBarrierNode create(int depth) {
        return new WriteBarrierNodeGen(depth);
    }

    @GeneratedBy(methodName="noWriteBarrier(Object)", value=WriteBarrierNode.class)
    private static final class NoWriteBarrierNode_
    extends BaseNode_ {
        NoWriteBarrierNode_(WriteBarrierNodeGen root) {
            super(root, 4);
        }

        @Override
        public void executeVoid(Object arg0Value) {
            if (!WriteBarrierNode.isDynamicObject(arg0Value)) {
                this.root.noWriteBarrier(arg0Value);
                return;
            }
            this.getNext().executeVoid(arg0Value);
        }

        static BaseNode_ create(WriteBarrierNodeGen root) {
            return new NoWriteBarrierNode_(root);
        }
    }

    @GeneratedBy(methodName="writeBarrierUncached(DynamicObject)", value=WriteBarrierNode.class)
    private static final class WriteBarrierUncachedNode_
    extends BaseNode_ {
        WriteBarrierUncachedNode_(WriteBarrierNodeGen root) {
            super(root, 3);
        }

        @Override
        public void executeVoid(Object arg0Value) {
            if (arg0Value instanceof DynamicObject) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                this.root.writeBarrierUncached(arg0Value_);
                return;
            }
            this.getNext().executeVoid(arg0Value);
        }

        static BaseNode_ create(WriteBarrierNodeGen root) {
            return new WriteBarrierUncachedNode_(root);
        }
    }

    @GeneratedBy(methodName="updateShapeAndWriteBarrier(DynamicObject)", value=WriteBarrierNode.class)
    private static final class UpdateShapeAndWriteBarrierNode_
    extends BaseNode_ {
        UpdateShapeAndWriteBarrierNode_(WriteBarrierNodeGen root) {
            super(root, 2);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arg0Value) {
            if (newNode.getClass() == WriteBarrierUncachedNode_.class) {
                this.removeSame("Contained by writeBarrierUncached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, arg0Value);
        }

        @Override
        public void executeVoid(Object arg0Value) {
            DynamicObject arg0Value_;
            if (arg0Value instanceof DynamicObject && ShapeCachingGuards.updateShape(arg0Value_ = (DynamicObject)arg0Value)) {
                this.root.updateShapeAndWriteBarrier(arg0Value_);
                return;
            }
            this.getNext().executeVoid(arg0Value);
        }

        static BaseNode_ create(WriteBarrierNodeGen root) {
            return new UpdateShapeAndWriteBarrierNode_(root);
        }
    }

    @GeneratedBy(methodName="writeBarrierCached(DynamicObject, Shape, boolean, ShareObjectNode)", value=WriteBarrierNode.class)
    private static final class WriteBarrierCachedNode_
    extends BaseNode_ {
        private final Shape cachedShape;
        private final boolean alreadyShared;
        @Node.Child
        private ShareObjectNode shareObjectNode;
        @CompilerDirectives.CompilationFinal
        private final Assumption assumption0_;

        WriteBarrierCachedNode_(WriteBarrierNodeGen root, Shape cachedShape, boolean alreadyShared, ShareObjectNode shareObjectNode, Assumption assumption0_) {
            super(root, 1);
            this.cachedShape = cachedShape;
            this.alreadyShared = alreadyShared;
            this.shareObjectNode = shareObjectNode;
            this.assumption0_ = assumption0_;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arg0Value) {
            if (newNode.getClass() == WriteBarrierUncachedNode_.class) {
                this.removeSame("Contained by writeBarrierUncached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, arg0Value);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arg0Value) {
            DynamicObject arg0Value_;
            if (arg0Value instanceof DynamicObject && (arg0Value_ = (DynamicObject)arg0Value).getShape() == this.cachedShape) {
                assert (this.root.depth < 3);
                return true;
            }
            return false;
        }

        @Override
        public void executeVoid(Object arg0Value) {
            DynamicObject arg0Value_;
            try {
                WriteBarrierCachedNode_.check(this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                this.removeThis((CharSequence)"Assumption [assumption0] invalidated", (Frame)null, arg0Value);
                return;
            }
            if (arg0Value instanceof DynamicObject && (arg0Value_ = (DynamicObject)arg0Value).getShape() == this.cachedShape) {
                assert (this.root.depth < 3);
                this.root.writeBarrierCached(arg0Value_, this.cachedShape, this.alreadyShared, this.shareObjectNode);
                return;
            }
            this.getNext().executeVoid(arg0Value);
        }

        static BaseNode_ create(WriteBarrierNodeGen root, Shape cachedShape, boolean alreadyShared, ShareObjectNode shareObjectNode, Assumption assumption0_) {
            return new WriteBarrierCachedNode_(root, cachedShape, alreadyShared, shareObjectNode, assumption0_);
        }
    }

    @GeneratedBy(value=WriteBarrierNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(WriteBarrierNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public void executeVoid(Object arg0Value) {
            this.uninitialized((Frame)null, arg0Value);
        }

        static BaseNode_ create(WriteBarrierNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=WriteBarrierNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected WriteBarrierNodeGen root;

        BaseNode_(WriteBarrierNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (WriteBarrierNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{null};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arg0Value) {
            this.executeVoid(arg0Value);
            return null;
        }

        public abstract void executeVoid(Object var1);

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arg0Value) {
            if (arg0Value instanceof DynamicObject) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                Shape cachedShape1 = arg0Value_.getShape();
                if (arg0Value_.getShape() == cachedShape1 && this.root.depth < 3 && !this.root.excludeWriteBarrierCached_) {
                    BaseNode_ s;
                    boolean alreadyShared1 = WriteBarrierNode.isShared(cachedShape1);
                    ShareObjectNode shareObjectNode1 = this.root.createShareObjectNode(alreadyShared1);
                    Assumption assumption0_1 = cachedShape1.getValidAssumption();
                    if (BaseNode_.isValid(assumption0_1) && this.countSame(s = WriteBarrierCachedNode_.create(this.root, cachedShape1, alreadyShared1, shareObjectNode1, assumption0_1)) < 8) {
                        return s;
                    }
                }
                if (ShapeCachingGuards.updateShape(arg0Value_) && !this.root.excludeUpdateShapeAndWriteBarrier_) {
                    return UpdateShapeAndWriteBarrierNode_.create(this.root);
                }
                this.root.excludeWriteBarrierCached_ = true;
                this.root.excludeUpdateShapeAndWriteBarrier_ = true;
                return WriteBarrierUncachedNode_.create(this.root);
            }
            if (!WriteBarrierNode.isDynamicObject(arg0Value)) {
                return NoWriteBarrierNode_.create(this.root);
            }
            return null;
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

