/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class AliasParseNode
extends ParseNode {
    private ParseNode oldName;
    private ParseNode newName;

    public AliasParseNode(SourceIndexLength position, ParseNode newName, ParseNode oldName) {
        super(position, newName.containsVariableAssignment() || oldName.containsVariableAssignment());
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ALIASNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitAliasNode(this);
    }

    public ParseNode getNewName() {
        return this.newName;
    }

    public ParseNode getOldName() {
        return this.oldName;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.newName, this.oldName);
    }
}

