

/* this file was generated by volk template utils, do not edit! */

/*
 * Copyright 2011-2012 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#ifndef INCLUDED_VOLK_RUNTIME
#define INCLUDED_VOLK_RUNTIME

#include <volk/volk_typedefs.h>
#include <volk/volk_config_fixed.h>
#include <volk/volk_common.h>
#include <volk/volk_complex.h>
#include <volk/volk_malloc.h>

#include <stdlib.h>
#include <stdbool.h>

__VOLK_DECL_BEGIN

typedef struct volk_func_desc
{
    const char **impl_names;
    const int *impl_deps;
    const bool *impl_alignment;
    const size_t n_impls;
} volk_func_desc_t;

//! Prints a list of machines available
VOLK_API void volk_list_machines(void);

//! Returns the name of the machine this instance will use
VOLK_API const char* volk_get_machine(void);

//! Get the machine alignment in bytes
VOLK_API size_t volk_get_alignment(void);

/*!
 * The VOLK_OR_PTR macro is a convenience macro
 * for checking the alignment of a set of pointers.
 * Example usage:
 * volk_is_aligned(VOLK_OR_PTR((VOLK_OR_PTR(p0, p1), p2)))
 */
#define VOLK_OR_PTR(ptr0, ptr1) \
    (const void *)(((intptr_t)(ptr0)) | ((intptr_t)(ptr1)))

/*!
 * Is the pointer on a machine alignment boundary?
 *
 * Note: for performance reasons, this function
 * is not usable until another volk API call is made
 * which will perform certain initialization tasks.
 *
 * \param ptr the pointer to some memory buffer
 * \return 1 for alignment boundary, else 0
 */
VOLK_API bool volk_is_aligned(const void *ptr);


//! A function pointer to the dispatcher implementation
extern VOLK_API p_8i_convert_16i volk_8i_convert_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8i_convert_16i volk_8i_convert_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8i_convert_16i volk_8i_convert_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8i_convert_16i_manual(int16_t*  outputVector, const int8_t*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8i_convert_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8u_conv_k7_r2puppet_8u volk_8u_conv_k7_r2puppet_8u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8u_conv_k7_r2puppet_8u volk_8u_conv_k7_r2puppet_8u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8u_conv_k7_r2puppet_8u volk_8u_conv_k7_r2puppet_8u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8u_conv_k7_r2puppet_8u_manual(unsigned char*  syms, unsigned char*  dec, unsigned int  framebits, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8u_conv_k7_r2puppet_8u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8u_x2_encodeframepolar_8u volk_8u_x2_encodeframepolar_8u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8u_x2_encodeframepolar_8u volk_8u_x2_encodeframepolar_8u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8u_x2_encodeframepolar_8u volk_8u_x2_encodeframepolar_8u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8u_x2_encodeframepolar_8u_manual(unsigned char*  frame, unsigned char*  temp, unsigned int  frame_size, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8u_x2_encodeframepolar_8u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32f_deinterleave_real_16i volk_32fc_s32f_deinterleave_real_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32f_deinterleave_real_16i volk_32fc_s32f_deinterleave_real_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32f_deinterleave_real_16i volk_32fc_s32f_deinterleave_real_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32f_deinterleave_real_16i_manual(int16_t*  iBuffer, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32f_deinterleave_real_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_8u_polarbutterfly_32f volk_32f_8u_polarbutterfly_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_8u_polarbutterfly_32f volk_32f_8u_polarbutterfly_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_8u_polarbutterfly_32f volk_32f_8u_polarbutterfly_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_8u_polarbutterfly_32f_manual(float*  llrs, unsigned char*  u, const int  frame_size, const int  frame_exp, const int  stage, const int  u_num, const int  row, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_8u_polarbutterfly_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_index_max_32u volk_32f_index_max_32u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_index_max_32u volk_32f_index_max_32u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_index_max_32u volk_32f_index_max_32u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_index_max_32u_manual(uint32_t*  target, const float*  src0, uint32_t  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_index_max_32u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_subtract_32f volk_32f_x2_subtract_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_subtract_32f volk_32f_x2_subtract_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_subtract_32f volk_32f_x2_subtract_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_subtract_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_subtract_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_max_32f volk_32f_x2_max_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_max_32f volk_32f_x2_max_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_max_32f volk_32f_x2_max_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_max_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_max_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16u_byteswap volk_16u_byteswap;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16u_byteswap volk_16u_byteswap_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16u_byteswap volk_16u_byteswap_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16u_byteswap_manual(uint16_t*  intsToSwap, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16u_byteswap_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8u_x4_conv_k7_r2_8u volk_8u_x4_conv_k7_r2_8u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8u_x4_conv_k7_r2_8u volk_8u_x4_conv_k7_r2_8u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8u_x4_conv_k7_r2_8u volk_8u_x4_conv_k7_r2_8u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8u_x4_conv_k7_r2_8u_manual(unsigned char*  Y, unsigned char*  X, unsigned char*  syms, unsigned char*  dec, unsigned int  framebits, unsigned int  excess, unsigned char*  Branchtab, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8u_x4_conv_k7_r2_8u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_pow_32f volk_32f_x2_pow_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_pow_32f volk_32f_x2_pow_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_pow_32f volk_32f_x2_pow_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_pow_32f_manual(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_pow_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_stddev_and_mean_32f_x2 volk_32f_stddev_and_mean_32f_x2;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_stddev_and_mean_32f_x2 volk_32f_stddev_and_mean_32f_x2_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_stddev_and_mean_32f_x2 volk_32f_stddev_and_mean_32f_x2_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_stddev_and_mean_32f_x2_manual(float*  stddev, float*  mean, const float*  inputBuffer, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_stddev_and_mean_32f_x2_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_64u_popcntpuppet_64u volk_64u_popcntpuppet_64u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_64u_popcntpuppet_64u volk_64u_popcntpuppet_64u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_64u_popcntpuppet_64u volk_64u_popcntpuppet_64u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_64u_popcntpuppet_64u_manual(uint64_t*  outVector, const uint64_t*  inVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_64u_popcntpuppet_64u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_min_32f volk_32f_x2_min_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_min_32f volk_32f_x2_min_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_min_32f volk_32f_x2_min_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_min_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_min_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_acos_32f volk_32f_acos_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_acos_32f volk_32f_acos_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_acos_32f volk_32f_acos_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_acos_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_acos_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32f_power_spectrum_32f volk_32fc_s32f_power_spectrum_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32f_power_spectrum_32f volk_32fc_s32f_power_spectrum_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32f_power_spectrum_32f volk_32fc_s32f_power_spectrum_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32f_power_spectrum_32f_manual(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32f_power_spectrum_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_s32f_deinterleave_32f_x2 volk_16ic_s32f_deinterleave_32f_x2;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_s32f_deinterleave_32f_x2 volk_16ic_s32f_deinterleave_32f_x2_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_s32f_deinterleave_32f_x2 volk_16ic_s32f_deinterleave_32f_x2_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_s32f_deinterleave_32f_x2_manual(float*  iBuffer, float*  qBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_s32f_deinterleave_32f_x2_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_convert_64f volk_32f_convert_64f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_convert_64f volk_32f_convert_64f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_convert_64f volk_32f_convert_64f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_convert_64f_manual(double*  outputVector, const float*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_convert_64f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32i_x2_or_32i volk_32i_x2_or_32i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32i_x2_or_32i volk_32i_x2_or_32i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32i_x2_or_32i volk_32i_x2_or_32i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32i_x2_or_32i_manual(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32i_x2_or_32i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_deinterleave_real_8i volk_8ic_deinterleave_real_8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_deinterleave_real_8i volk_8ic_deinterleave_real_8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_deinterleave_real_8i volk_8ic_deinterleave_real_8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8ic_deinterleave_real_8i_manual(int8_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8ic_deinterleave_real_8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_32fc_dot_prod_32fc volk_16i_32fc_dot_prod_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_32fc_dot_prod_32fc volk_16i_32fc_dot_prod_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_32fc_dot_prod_32fc volk_16i_32fc_dot_prod_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_32fc_dot_prod_32fc_manual(lv_32fc_t*  result, const short*  input, const lv_32fc_t *  taps, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_32fc_dot_prod_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_dot_prod_32f volk_32f_x2_dot_prod_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_dot_prod_32f volk_32f_x2_dot_prod_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_dot_prod_32f volk_32f_x2_dot_prod_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_dot_prod_32f_manual(float *  result, const float *  input, const float *  taps, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_dot_prod_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_s32f_square_dist_scalar_mult_32f volk_32fc_x2_s32f_square_dist_scalar_mult_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_s32f_square_dist_scalar_mult_32f volk_32fc_x2_s32f_square_dist_scalar_mult_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_s32f_square_dist_scalar_mult_32f volk_32fc_x2_s32f_square_dist_scalar_mult_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_x2_s32f_square_dist_scalar_mult_32f_manual(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_x2_s32f_square_dist_scalar_mult_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_tan_32f volk_32f_tan_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_tan_32f volk_32f_tan_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_tan_32f volk_32f_tan_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_tan_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_tan_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_divide_32f volk_32f_x2_divide_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_divide_32f volk_32f_x2_divide_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_divide_32f volk_32f_x2_divide_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_divide_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_divide_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8u_x3_encodepolar_8u_x2 volk_8u_x3_encodepolar_8u_x2;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8u_x3_encodepolar_8u_x2 volk_8u_x3_encodepolar_8u_x2_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8u_x3_encodepolar_8u_x2 volk_8u_x3_encodepolar_8u_x2_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8u_x3_encodepolar_8u_x2_manual(unsigned char*  frame, unsigned char*  temp, const unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8u_x3_encodepolar_8u_x2_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_64u_popcnt volk_64u_popcnt;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_64u_popcnt volk_64u_popcnt_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_64u_popcnt volk_64u_popcnt_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_64u_popcnt_manual(uint64_t*  ret, const uint64_t  value, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_64u_popcnt_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_conjugate_32fc volk_32fc_conjugate_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_conjugate_32fc volk_32fc_conjugate_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_conjugate_32fc volk_32fc_conjugate_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_conjugate_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_conjugate_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic volk_16ic_x2_dot_prod_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic volk_16ic_x2_dot_prod_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic volk_16ic_x2_dot_prod_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_x2_dot_prod_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_x2_dot_prod_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_stddev_32f volk_32f_s32f_stddev_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_stddev_32f volk_32f_s32f_stddev_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_stddev_32f volk_32f_s32f_stddev_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_stddev_32f_manual(float*  stddev, const float*  inputBuffer, const float  mean, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_stddev_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_divide_32fc volk_32fc_x2_divide_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_divide_32fc volk_32fc_x2_divide_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_divide_32fc volk_32fc_x2_divide_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_x2_divide_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  numeratorVector, const lv_32fc_t*  denumeratorVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_x2_divide_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_deinterleave_16i_x2 volk_8ic_deinterleave_16i_x2;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_deinterleave_16i_x2 volk_8ic_deinterleave_16i_x2_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_deinterleave_16i_x2 volk_8ic_deinterleave_16i_x2_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8ic_deinterleave_16i_x2_manual(int16_t*  iBuffer, int16_t*  qBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8ic_deinterleave_16i_x2_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_magnitude_16i volk_16ic_magnitude_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_magnitude_16i volk_16ic_magnitude_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_magnitude_16i volk_16ic_magnitude_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_magnitude_16i_manual(int16_t*  magnitudeVector, const lv_16sc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_magnitude_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_index_max_16u volk_32fc_index_max_16u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_index_max_16u volk_32fc_index_max_16u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_index_max_16u volk_32fc_index_max_16u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_index_max_16u_manual(uint16_t*  target, lv_32fc_t*  src0, uint32_t  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_index_max_16u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32fc_rotatorpuppet_32fc volk_32fc_s32fc_rotatorpuppet_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32fc_rotatorpuppet_32fc volk_32fc_s32fc_rotatorpuppet_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32fc_rotatorpuppet_32fc volk_32fc_s32fc_rotatorpuppet_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32fc_rotatorpuppet_32fc_manual(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t  phase_inc, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32fc_rotatorpuppet_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_x2_multiply_conjugate_16ic volk_8ic_x2_multiply_conjugate_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_x2_multiply_conjugate_16ic volk_8ic_x2_multiply_conjugate_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_x2_multiply_conjugate_16ic volk_8ic_x2_multiply_conjugate_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8ic_x2_multiply_conjugate_16ic_manual(lv_16sc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8ic_x2_multiply_conjugate_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32u_popcnt volk_32u_popcnt;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32u_popcnt volk_32u_popcnt_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32u_popcnt volk_32u_popcnt_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32u_popcnt_manual(uint32_t*  ret, const uint32_t  value, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32u_popcnt_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_accumulator_s32f volk_32f_accumulator_s32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_accumulator_s32f volk_32f_accumulator_s32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_accumulator_s32f volk_32f_accumulator_s32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_accumulator_s32f_manual(float*  result, const float*  inputBuffer, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_accumulator_s32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_null_32f volk_32f_null_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_null_32f volk_32f_null_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_null_32f volk_32f_null_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_null_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_null_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_64u_byteswap volk_64u_byteswap;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_64u_byteswap volk_64u_byteswap_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_64u_byteswap volk_64u_byteswap_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_64u_byteswap_manual(uint64_t*  intsToSwap, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_64u_byteswap_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_multiply_32f volk_32f_x2_multiply_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_multiply_32f volk_32f_x2_multiply_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_multiply_32f volk_32f_x2_multiply_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_multiply_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_multiply_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32u_byteswappuppet_32u volk_32u_byteswappuppet_32u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32u_byteswappuppet_32u volk_32u_byteswappuppet_32u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32u_byteswappuppet_32u volk_32u_byteswappuppet_32u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32u_byteswappuppet_32u_manual(uint32_t* output, uint32_t*  intsToSwap, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32u_byteswappuppet_32u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_square_dist_32f volk_32fc_x2_square_dist_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_square_dist_32f volk_32fc_x2_square_dist_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_square_dist_32f volk_32fc_x2_square_dist_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_x2_square_dist_32f_manual(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_x2_square_dist_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_tanh_32f volk_32f_tanh_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_tanh_32f volk_32f_tanh_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_tanh_32f volk_32f_tanh_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_tanh_32f_manual(float*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_tanh_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_deinterleave_real_64f volk_32fc_deinterleave_real_64f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_deinterleave_real_64f volk_32fc_deinterleave_real_64f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_deinterleave_real_64f volk_32fc_deinterleave_real_64f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_deinterleave_real_64f_manual(double*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_deinterleave_real_64f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_x2_s32f_multiply_conjugate_32fc volk_8ic_x2_s32f_multiply_conjugate_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_x2_s32f_multiply_conjugate_32fc volk_8ic_x2_s32f_multiply_conjugate_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_x2_s32f_multiply_conjugate_32fc volk_8ic_x2_s32f_multiply_conjugate_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8ic_x2_s32f_multiply_conjugate_32fc_manual(lv_32fc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8ic_x2_s32f_multiply_conjugate_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_x4_quad_max_star_16i volk_16i_x4_quad_max_star_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_x4_quad_max_star_16i volk_16i_x4_quad_max_star_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_x4_quad_max_star_16i volk_16i_x4_quad_max_star_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_x4_quad_max_star_16i_manual(short*  target, short*  src0, short*  src1, short*  src2, short*  src3, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_x4_quad_max_star_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_64f_convert_32f volk_64f_convert_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_64f_convert_32f volk_64f_convert_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_64f_convert_32f volk_64f_convert_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_64f_convert_32f_manual(float*  outputVector, const double*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_64f_convert_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_index_max_16u volk_32f_index_max_16u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_index_max_16u volk_32f_index_max_16u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_index_max_16u volk_32f_index_max_16u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_index_max_16u_manual(uint16_t*  target, const float*  src0, uint32_t  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_index_max_16u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32i_x2_and_32i volk_32i_x2_and_32i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32i_x2_and_32i volk_32i_x2_and_32i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32i_x2_and_32i volk_32i_x2_and_32i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32i_x2_and_32i_manual(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32i_x2_and_32i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_normalize volk_32f_s32f_normalize;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_normalize volk_32f_s32f_normalize_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_normalize volk_32f_s32f_normalize_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_normalize_manual(float*  vecBuffer, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_normalize_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_deinterleave_real_8i volk_16ic_deinterleave_real_8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_deinterleave_real_8i volk_16ic_deinterleave_real_8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_deinterleave_real_8i volk_16ic_deinterleave_real_8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_deinterleave_real_8i_manual(int8_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_deinterleave_real_8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_atan_32f volk_32f_atan_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_atan_32f volk_32f_atan_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_atan_32f volk_32f_atan_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_atan_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_atan_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_multiply_32f volk_32f_s32f_multiply_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_multiply_32f volk_32f_s32f_multiply_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_multiply_32f volk_32f_s32f_multiply_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_multiply_32f_manual(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_multiply_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_convert_32i volk_32f_s32f_convert_32i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_convert_32i volk_32f_s32f_convert_32i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_convert_32i volk_32f_s32f_convert_32i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_convert_32i_manual(int32_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_convert_32i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_convert_16i volk_32f_s32f_convert_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_convert_16i volk_32f_s32f_convert_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_convert_16i volk_32f_s32f_convert_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_convert_16i_manual(int16_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_convert_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_64f_x2_max_64f volk_64f_x2_max_64f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_64f_x2_max_64f volk_64f_x2_max_64f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_64f_x2_max_64f volk_64f_x2_max_64f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_64f_x2_max_64f_manual(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_64f_x2_max_64f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_convert_8i volk_16i_convert_8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_convert_8i volk_16i_convert_8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_convert_8i volk_16i_convert_8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_convert_8i_manual(int8_t*  outputVector, const int16_t*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_convert_8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_index_max_32u volk_32fc_index_max_32u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_index_max_32u volk_32fc_index_max_32u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_index_max_32u volk_32fc_index_max_32u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_index_max_32u_manual(uint32_t*  target, lv_32fc_t*  src0, uint32_t  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_index_max_32u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_s32f_deinterleave_32f_x2 volk_8ic_s32f_deinterleave_32f_x2;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_s32f_deinterleave_32f_x2 volk_8ic_s32f_deinterleave_32f_x2_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_s32f_deinterleave_32f_x2 volk_8ic_s32f_deinterleave_32f_x2_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8ic_s32f_deinterleave_32f_x2_manual(float*  iBuffer, float*  qBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8ic_s32f_deinterleave_32f_x2_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_deinterleave_imag_32f volk_32fc_deinterleave_imag_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_deinterleave_imag_32f volk_32fc_deinterleave_imag_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_deinterleave_imag_32f volk_32fc_deinterleave_imag_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_deinterleave_imag_32f_manual(float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_deinterleave_imag_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_s32f_deinterleave_real_32f volk_8ic_s32f_deinterleave_real_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_s32f_deinterleave_real_32f volk_8ic_s32f_deinterleave_real_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_s32f_deinterleave_real_32f volk_8ic_s32f_deinterleave_real_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8ic_s32f_deinterleave_real_32f_manual(float*  iBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8ic_s32f_deinterleave_real_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8i_s32f_convert_32f volk_8i_s32f_convert_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8i_s32f_convert_32f volk_8i_s32f_convert_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8i_s32f_convert_32f volk_8i_s32f_convert_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8i_s32f_convert_32f_manual(float*  outputVector, const int8_t*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8i_s32f_convert_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_dot_prod_16i volk_32f_x2_dot_prod_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_dot_prod_16i volk_32f_x2_dot_prod_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_dot_prod_16i volk_32f_x2_dot_prod_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_dot_prod_16i_manual(int16_t*  result, const float*  input, const float*  taps, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_dot_prod_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_convert_8i volk_32f_s32f_convert_8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_convert_8i volk_32f_s32f_convert_8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_convert_8i volk_32f_s32f_convert_8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_convert_8i_manual(int8_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_convert_8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_deinterleave_real_16i volk_8ic_deinterleave_real_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_deinterleave_real_16i volk_8ic_deinterleave_real_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_deinterleave_real_16i volk_8ic_deinterleave_real_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8ic_deinterleave_real_16i_manual(int16_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8ic_deinterleave_real_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_multiply_32fc volk_32fc_x2_multiply_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_multiply_32fc volk_32fc_x2_multiply_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_multiply_32fc volk_32fc_x2_multiply_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_x2_multiply_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_x2_multiply_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_sqrt_32f volk_32f_sqrt_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_sqrt_32f volk_32f_sqrt_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_sqrt_32f volk_32f_sqrt_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_sqrt_32f_manual(float*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_sqrt_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_deinterleave_64f_x2 volk_32fc_deinterleave_64f_x2;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_deinterleave_64f_x2 volk_32fc_deinterleave_64f_x2_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_deinterleave_64f_x2 volk_32fc_deinterleave_64f_x2_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_deinterleave_64f_x2_manual(double*  iBuffer, double*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_deinterleave_64f_x2_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_magnitude_32f volk_32fc_magnitude_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_magnitude_32f volk_32fc_magnitude_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_magnitude_32f volk_32fc_magnitude_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_magnitude_32f_manual(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_magnitude_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_fm_detectpuppet_32f volk_32f_x2_fm_detectpuppet_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_fm_detectpuppet_32f volk_32f_x2_fm_detectpuppet_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_fm_detectpuppet_32f volk_32f_x2_fm_detectpuppet_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_fm_detectpuppet_32f_manual(float*  outputVector, const float*  inputVector, float*  saveValue, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_fm_detectpuppet_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_deinterleave_32f_x2 volk_32fc_deinterleave_32f_x2;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_deinterleave_32f_x2 volk_32fc_deinterleave_32f_x2_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_deinterleave_32f_x2 volk_32fc_deinterleave_32f_x2_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_deinterleave_32f_x2_manual(float*  iBuffer, float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_deinterleave_32f_x2_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_calc_spectral_noise_floor_32f volk_32f_s32f_calc_spectral_noise_floor_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_calc_spectral_noise_floor_32f volk_32f_s32f_calc_spectral_noise_floor_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_calc_spectral_noise_floor_32f volk_32f_s32f_calc_spectral_noise_floor_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_calc_spectral_noise_floor_32f_manual(float*  noiseFloorAmplitude, const float*  realDataPoints, const float  spectralExclusionValue, const unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_calc_spectral_noise_floor_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_x5_add_quad_16i_x4 volk_16i_x5_add_quad_16i_x4;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_x5_add_quad_16i_x4 volk_16i_x5_add_quad_16i_x4_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_x5_add_quad_16i_x4 volk_16i_x5_add_quad_16i_x4_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_x5_add_quad_16i_x4_manual(short*  target0, short*  target1, short*  target2, short*  target3, short*  src0, short*  src1, short*  src2, short*  src3, short*  src4, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_x5_add_quad_16i_x4_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_binary_slicer_32i volk_32f_binary_slicer_32i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_binary_slicer_32i volk_32f_binary_slicer_32i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_binary_slicer_32i volk_32f_binary_slicer_32i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_binary_slicer_32i_manual(int*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_binary_slicer_32i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8u_x3_encodepolarpuppet_8u volk_8u_x3_encodepolarpuppet_8u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8u_x3_encodepolarpuppet_8u volk_8u_x3_encodepolarpuppet_8u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8u_x3_encodepolarpuppet_8u volk_8u_x3_encodepolarpuppet_8u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_8u_x3_encodepolarpuppet_8u_manual(unsigned char*  frame, unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_8u_x3_encodepolarpuppet_8u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_32f_multiply_32fc volk_32fc_32f_multiply_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_32f_multiply_32fc volk_32fc_32f_multiply_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_32f_multiply_32fc volk_32fc_32f_multiply_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_32f_multiply_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_32f_multiply_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32fc_multiply_32fc volk_32fc_s32fc_multiply_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32fc_multiply_32fc volk_32fc_s32fc_multiply_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32fc_multiply_32fc volk_32fc_s32fc_multiply_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32fc_multiply_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32fc_multiply_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_add_32f volk_32f_x2_add_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_add_32f volk_32f_x2_add_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_add_32f volk_32f_x2_add_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_add_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_add_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_binary_slicer_8i volk_32f_binary_slicer_8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_binary_slicer_8i volk_32f_binary_slicer_8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_binary_slicer_8i volk_32f_binary_slicer_8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_binary_slicer_8i_manual(int8_t*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_binary_slicer_8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_s32f_deinterleave_real_32f volk_16ic_s32f_deinterleave_real_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_s32f_deinterleave_real_32f volk_16ic_s32f_deinterleave_real_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_s32f_deinterleave_real_32f volk_16ic_s32f_deinterleave_real_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_s32f_deinterleave_real_32f_manual(float*  iBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_s32f_deinterleave_real_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32f_x2_power_spectral_density_32f volk_32fc_s32f_x2_power_spectral_density_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32f_x2_power_spectral_density_32f volk_32fc_s32f_x2_power_spectral_density_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32f_x2_power_spectral_density_32f volk_32fc_s32f_x2_power_spectral_density_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32f_x2_power_spectral_density_32f_manual(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, const float  rbw, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32f_x2_power_spectral_density_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_cos_32f volk_32f_cos_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_cos_32f volk_32f_cos_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_cos_32f volk_32f_cos_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_cos_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_cos_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_64u_byteswappuppet_64u volk_64u_byteswappuppet_64u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_64u_byteswappuppet_64u volk_64u_byteswappuppet_64u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_64u_byteswappuppet_64u volk_64u_byteswappuppet_64u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_64u_byteswappuppet_64u_manual(uint64_t* output, uint64_t*  intsToSwap, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_64u_byteswappuppet_64u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32i_s32f_convert_32f volk_32i_s32f_convert_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32i_s32f_convert_32f volk_32i_s32f_convert_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32i_s32f_convert_32f volk_32i_s32f_convert_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32i_s32f_convert_32f_manual(float*  outputVector, const int32_t*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32i_s32f_convert_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_deinterleave_16i_x2 volk_16ic_deinterleave_16i_x2;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_deinterleave_16i_x2 volk_16ic_deinterleave_16i_x2_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_deinterleave_16i_x2 volk_16ic_deinterleave_16i_x2_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_deinterleave_16i_x2_manual(int16_t*  iBuffer, int16_t*  qBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_deinterleave_16i_x2_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_max_star_horizontal_16i volk_16i_max_star_horizontal_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_max_star_horizontal_16i volk_16i_max_star_horizontal_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_max_star_horizontal_16i volk_16i_max_star_horizontal_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_max_star_horizontal_16i_manual(int16_t*  target, int16_t*  src0, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_max_star_horizontal_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_log2_32f volk_32f_log2_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_log2_32f volk_32f_log2_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_log2_32f volk_32f_log2_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_log2_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_log2_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_branch_4_state_8 volk_16i_branch_4_state_8;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_branch_4_state_8 volk_16i_branch_4_state_8_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_branch_4_state_8 volk_16i_branch_4_state_8_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_branch_4_state_8_manual(short*  target, short*  src0, char**  permuters, short*  cntl2, short*  cntl3, short*  scalars, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_branch_4_state_8_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_permute_and_scalar_add volk_16i_permute_and_scalar_add;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_permute_and_scalar_add volk_16i_permute_and_scalar_add_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_permute_and_scalar_add volk_16i_permute_and_scalar_add_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_permute_and_scalar_add_manual(short*  target, short*  src0, short*  permute_indexes, short*  cntl0, short*  cntl1, short*  cntl2, short*  cntl3, short*  scalars, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_permute_and_scalar_add_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_max_star_16i volk_16i_max_star_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_max_star_16i volk_16i_max_star_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_max_star_16i volk_16i_max_star_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_max_star_16i_manual(short*  target, short*  src0, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_max_star_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_conjugate_dot_prod_32fc volk_32fc_x2_conjugate_dot_prod_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_conjugate_dot_prod_32fc volk_32fc_x2_conjugate_dot_prod_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_conjugate_dot_prod_32fc volk_32fc_x2_conjugate_dot_prod_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_x2_conjugate_dot_prod_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_x2_conjugate_dot_prod_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32f_power_32fc volk_32fc_s32f_power_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32f_power_32fc volk_32fc_s32f_power_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32f_power_32fc volk_32fc_s32f_power_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32f_power_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float  power, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32f_power_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_power_32f volk_32f_s32f_power_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_power_32f volk_32f_s32f_power_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_power_32f volk_32f_s32f_power_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_power_32f_manual(float*  cVector, const float*  aVector, const float  power, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_power_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_convert_32fc volk_16ic_convert_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_convert_32fc volk_16ic_convert_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_convert_32fc volk_16ic_convert_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_convert_32fc_manual(lv_32fc_t*  outputVector, const lv_16sc_t*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_convert_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32u_popcntpuppet_32u volk_32u_popcntpuppet_32u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32u_popcntpuppet_32u volk_32u_popcntpuppet_32u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32u_popcntpuppet_32u volk_32u_popcntpuppet_32u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32u_popcntpuppet_32u_manual(uint32_t*  outVector, const uint32_t*  inVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32u_popcntpuppet_32u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_asin_32f volk_32f_asin_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_asin_32f volk_32f_asin_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_asin_32f volk_32f_asin_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_asin_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_asin_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_s32f_interleave_16ic volk_32f_x2_s32f_interleave_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_s32f_interleave_16ic volk_32f_x2_s32f_interleave_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_s32f_interleave_16ic volk_32f_x2_s32f_interleave_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_s32f_interleave_16ic_manual(lv_16sc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_s32f_interleave_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16u_byteswappuppet_16u volk_16u_byteswappuppet_16u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16u_byteswappuppet_16u volk_16u_byteswappuppet_16u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16u_byteswappuppet_16u volk_16u_byteswappuppet_16u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16u_byteswappuppet_16u_manual(uint16_t* output, uint16_t*  intsToSwap, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16u_byteswappuppet_16u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_x2_multiply_16ic volk_16ic_x2_multiply_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_x2_multiply_16ic volk_16ic_x2_multiply_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_x2_multiply_16ic volk_16ic_x2_multiply_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_x2_multiply_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_x2_multiply_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_expfast_32f volk_32f_expfast_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_expfast_32f volk_32f_expfast_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_expfast_32f volk_32f_expfast_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_expfast_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_expfast_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_deinterleave_real_32f volk_32fc_deinterleave_real_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_deinterleave_real_32f volk_32fc_deinterleave_real_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_deinterleave_real_32f volk_32fc_deinterleave_real_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_deinterleave_real_32f_manual(float*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_deinterleave_real_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_sin_32f volk_32f_sin_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_sin_32f volk_32f_sin_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_sin_32f volk_32f_sin_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_sin_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_sin_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_multiply_conjugate_32fc volk_32fc_x2_multiply_conjugate_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_multiply_conjugate_32fc volk_32fc_x2_multiply_conjugate_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_multiply_conjugate_32fc volk_32fc_x2_multiply_conjugate_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_x2_multiply_conjugate_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_x2_multiply_conjugate_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x3_sum_of_poly_32f volk_32f_x3_sum_of_poly_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x3_sum_of_poly_32f volk_32f_x3_sum_of_poly_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x3_sum_of_poly_32f volk_32f_x3_sum_of_poly_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x3_sum_of_poly_32f_manual(float*  target, float*  src0, float*  center_point_array, float*  cutoff, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x3_sum_of_poly_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_dot_prod_32fc volk_32fc_x2_dot_prod_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_dot_prod_32fc volk_32fc_x2_dot_prod_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_dot_prod_32fc volk_32fc_x2_dot_prod_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_x2_dot_prod_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_x2_dot_prod_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_s32f_convert_32f volk_16i_s32f_convert_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_s32f_convert_32f volk_16i_s32f_convert_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_s32f_convert_32f volk_16i_s32f_convert_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16i_s32f_convert_32f_manual(float*  outputVector, const int16_t*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16i_s32f_convert_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32f_atan2_32f volk_32fc_s32f_atan2_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32f_atan2_32f volk_32fc_s32f_atan2_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32f_atan2_32f volk_32fc_s32f_atan2_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32f_atan2_32f_manual(float*  outputVector, const lv_32fc_t*  complexVector, const float  normalizeFactor, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32f_atan2_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_convert_16ic volk_32fc_convert_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_convert_16ic volk_32fc_convert_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_convert_16ic volk_32fc_convert_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_convert_16ic_manual(lv_16sc_t*  outputVector, const lv_32fc_t*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_convert_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32u_byteswap volk_32u_byteswap;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32u_byteswap volk_32u_byteswap_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32u_byteswap volk_32u_byteswap_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32u_byteswap_manual(uint32_t*  intsToSwap, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32u_byteswap_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_x2_interleave_32fc volk_32f_x2_interleave_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_x2_interleave_32fc volk_32f_x2_interleave_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_x2_interleave_32fc volk_32f_x2_interleave_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_x2_interleave_32fc_manual(lv_32fc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_x2_interleave_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_s32f_magnitude_32f volk_16ic_s32f_magnitude_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_s32f_magnitude_32f volk_16ic_s32f_magnitude_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_s32f_magnitude_32f volk_16ic_s32f_magnitude_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_s32f_magnitude_32f_manual(float*  magnitudeVector, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_s32f_magnitude_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_magnitude_squared_32f volk_32fc_magnitude_squared_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_magnitude_squared_32f volk_32fc_magnitude_squared_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_magnitude_squared_32f volk_32fc_magnitude_squared_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_magnitude_squared_32f_manual(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_magnitude_squared_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_8u_polarbutterflypuppet_32f volk_32f_8u_polarbutterflypuppet_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_8u_polarbutterflypuppet_32f volk_32f_8u_polarbutterflypuppet_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_8u_polarbutterflypuppet_32f volk_32f_8u_polarbutterflypuppet_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_8u_polarbutterflypuppet_32f_manual(float*  llrs, const float*  input, unsigned char*  u, const int  elements, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_8u_polarbutterflypuppet_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_32f_dot_prod_32fc volk_32fc_32f_dot_prod_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_32f_dot_prod_32fc volk_32fc_32f_dot_prod_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_32f_dot_prod_32fc volk_32fc_32f_dot_prod_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_32f_dot_prod_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  input, const float *  taps, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_32f_dot_prod_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32f_magnitude_16i volk_32fc_s32f_magnitude_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32f_magnitude_16i volk_32fc_s32f_magnitude_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32f_magnitude_16i volk_32fc_s32f_magnitude_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32f_magnitude_16i_manual(int16_t*  magnitudeVector, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32f_magnitude_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_deinterleave_real_16i volk_16ic_deinterleave_real_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_deinterleave_real_16i volk_16ic_deinterleave_real_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_deinterleave_real_16i volk_16ic_deinterleave_real_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_16ic_deinterleave_real_16i_manual(int16_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_16ic_deinterleave_real_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_s32f_32f_fm_detect_32f volk_32f_s32f_32f_fm_detect_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_s32f_32f_fm_detect_32f volk_32f_s32f_32f_fm_detect_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_s32f_32f_fm_detect_32f volk_32f_s32f_32f_fm_detect_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_s32f_32f_fm_detect_32f_manual(float*  outputVector, const float*  inputVector, const float  bound, float*  saveValue, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_s32f_32f_fm_detect_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_64f_x2_min_64f volk_64f_x2_min_64f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_64f_x2_min_64f volk_64f_x2_min_64f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_64f_x2_min_64f volk_64f_x2_min_64f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_64f_x2_min_64f_manual(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_64f_x2_min_64f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_invsqrt_32f volk_32f_invsqrt_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_invsqrt_32f volk_32f_invsqrt_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_invsqrt_32f volk_32f_invsqrt_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32f_invsqrt_32f_manual(float*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32f_invsqrt_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_s32fc_x2_rotator_32fc volk_32fc_s32fc_x2_rotator_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_s32fc_x2_rotator_32fc volk_32fc_s32fc_x2_rotator_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_s32fc_x2_rotator_32fc volk_32fc_s32fc_x2_rotator_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_32fc_s32fc_x2_rotator_32fc_manual(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, unsigned int  num_points, const char* impl_name);

//! Get description paramaters for this kernel
extern VOLK_API volk_func_desc_t volk_32fc_s32fc_x2_rotator_32fc_get_func_desc(void);

__VOLK_DECL_END

#endif /*INCLUDED_VOLK_RUNTIME*/