# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from openstack.bare_metal import bare_metal_service
from openstack import resource2


class Version(resource2.Resource):
    resource_key = 'version'
    resources_key = 'versions'
    base_path = '/'
    service = bare_metal_service.BareMetalService(
        version=bare_metal_service.BareMetalService.UNVERSIONED
    )

    # Capabilities
    allow_list = True

    # Attributes
    links = resource2.Body('links')
    status = resource2.Body('status')
    updated = resource2.Body('updated')
