/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.cache;

import java.util.HashMap;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class FirstLevelFontCache
implements FontCache {
    private HashMap backend;
    private FontCache secondLevelCache;

    public FirstLevelFontCache(FontCache secondLevelCache) {
        this.secondLevelCache = secondLevelCache;
        this.backend = new HashMap();
    }

    public FontMetrics getFontMetrics(FontKey fontKey) {
        FontMetrics metrics = (FontMetrics)this.backend.get(fontKey);
        if (metrics != null) {
            return metrics;
        }
        if (this.secondLevelCache == null) {
            return null;
        }
        FontMetrics fromSecondLevel = this.secondLevelCache.getFontMetrics(fontKey);
        if (fromSecondLevel != null) {
            this.backend.put(fontKey.clone(), fromSecondLevel);
            return fromSecondLevel;
        }
        return null;
    }

    public void putFontMetrics(FontKey key, FontMetrics fontMetrics) {
        this.backend.put(key, fontMetrics);
        if (this.secondLevelCache != null) {
            this.secondLevelCache.putFontMetrics(key, fontMetrics);
        }
    }

    public void commit() {
        this.backend.clear();
        this.secondLevelCache = null;
    }
}

