/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.stathissideris.ascii2image.text.GridPatternGroup;
import org.stathissideris.ascii2image.text.TextGrid;

public class GridPattern
extends TextGrid {
    private ArrayList<Pattern> regExps = new ArrayList();
    private boolean regExpsAreValid = false;
    private static final boolean DEBUG = false;
    private boolean usesStandardSyntax = false;

    public GridPattern() {
        super(3, 3);
    }

    public GridPattern(String string, String string2, String string3) {
        super(Math.max(Math.max(string.length(), string2.length()), string3.length()), 3);
        this.setTo(string, string2, string3);
        this.regExpsAreValid = false;
    }

    public boolean usesStandardSyntax() {
        return this.usesStandardSyntax;
    }

    public void setUsesStandardSyntax(boolean bl) {
        this.usesStandardSyntax = bl;
        this.regExpsAreValid = false;
    }

    public boolean isMatchedBy(TextGrid textGrid) {
        if (!this.regExpsAreValid) {
            this.prepareRegExps();
        }
        for (int i = 0; i < textGrid.getHeight(); ++i) {
            String string = textGrid.getRow(i).toString();
            Pattern pattern = this.regExps.get(i);
            if (pattern.matcher(string).matches()) continue;
            return false;
        }
        return true;
    }

    private void prepareRegExps() {
        this.regExpsAreValid = true;
        this.regExps.clear();
        if (!this.usesStandardSyntax) {
            Iterator<StringBuilder> iterator = this.getRows().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                this.regExps.add(Pattern.compile(this.makeRegExp(string)));
            }
        } else {
            Iterator<StringBuilder> iterator = this.getRows().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                this.regExps.add(Pattern.compile(string));
            }
        }
    }

    private String makeRegExp(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < string.length() && n < 3; ++n, ++i) {
            char c = string.charAt(i);
            if (c == '[') {
                stringBuilder.append("[^|:]");
                continue;
            }
            if (c == '|') {
                stringBuilder.append("[|:]");
                continue;
            }
            if (c == '-') {
                stringBuilder.append("[-=]");
                continue;
            }
            if (c == '!') {
                stringBuilder.append("[^-=\\/\\\\+|:]");
                continue;
            }
            if (c == 'b') {
                stringBuilder.append("[-=\\/\\\\+|:]");
                continue;
            }
            if (c == '^') {
                stringBuilder.append("[\\/\\\\+|:]");
                continue;
            }
            if (c == '(') {
                stringBuilder.append("[-=\\/\\\\+]");
                continue;
            }
            if (c == '~') {
                stringBuilder.append(".");
                continue;
            }
            if (c == '+') {
                stringBuilder.append("\\+");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c == 's') {
                stringBuilder.append("[-=+|:]");
                continue;
            }
            if (c == 'S') {
                stringBuilder.append("[\\/\\\\]");
                continue;
            }
            if (c == '*') {
                stringBuilder.append("\\*");
                continue;
            }
            if (c == '1') {
                stringBuilder.append("[\\\\]");
                continue;
            }
            if (c == '2') {
                stringBuilder.append("[|:+\\/\\\\]");
                continue;
            }
            if (c == '3') {
                stringBuilder.append("[\\/]");
                continue;
            }
            if (c == '4') {
                stringBuilder.append("[-=+\\/\\\\]");
                continue;
            }
            if (c == '5') {
                stringBuilder.append("[\\\\]");
                continue;
            }
            if (c == '6') {
                stringBuilder.append("[|:+\\/\\\\]");
                continue;
            }
            if (c == '7') {
                stringBuilder.append("[\\/]");
                continue;
            }
            if (c == '8') {
                stringBuilder.append("[-=+\\/\\\\]");
                continue;
            }
            if (c == '%') {
                if (i + 1 > string.length()) {
                    throw new RuntimeException("Invalid pattern, found % at the end");
                }
                if ((c = string.charAt(++i)) == '1') {
                    stringBuilder.append("[^\\\\]");
                    continue;
                }
                if (c == '2') {
                    stringBuilder.append("[^|:+\\/\\\\]");
                    continue;
                }
                if (c == '3') {
                    stringBuilder.append("[^\\/]");
                    continue;
                }
                if (c == '4') {
                    stringBuilder.append("[^-=+\\/\\\\]");
                    continue;
                }
                if (c == '5') {
                    stringBuilder.append("[^\\\\]");
                    continue;
                }
                if (c == '6') {
                    stringBuilder.append("[^|:+\\/\\\\]");
                    continue;
                }
                if (c == '7') {
                    stringBuilder.append("[^\\/]");
                    continue;
                }
                if (c != '8') continue;
                stringBuilder.append("[^-=+\\/\\\\]");
                continue;
            }
            stringBuilder.append(String.valueOf(c));
        }
        return stringBuilder.toString();
    }

    public void setTo(String string, String string2, String string3) {
        if (this.getHeight() != 3) {
            throw new RuntimeException("This method can only be called for GridPatternS with height 3");
        }
        this.regExpsAreValid = false;
        this.writeStringTo(0, 0, string);
        this.writeStringTo(0, 1, string2);
        this.writeStringTo(0, 2, string3);
    }

    public static void main(String[] stringArray) {
        TextGrid textGrid = new TextGrid(3, 3);
        textGrid.setRow(0, "---");
        textGrid.setRow(1, " / ");
        textGrid.setRow(2, "---");
        textGrid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(textGrid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
        textGrid.setRow(0, "--/");
        textGrid.setRow(1, " / ");
        textGrid.setRow(2, "---");
        textGrid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(textGrid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
        textGrid.setRow(0, "-- ");
        textGrid.setRow(1, " \\ ");
        textGrid.setRow(2, "---");
        textGrid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(textGrid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
        textGrid.setRow(0, "-- ");
        textGrid.setRow(1, " \\ ");
        textGrid.setRow(2, "--\\");
        textGrid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(textGrid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
        textGrid.setRow(0, "   ");
        textGrid.setRow(1, "-\\/");
        textGrid.setRow(2, " ||");
        textGrid.printDebug();
        if (GridPatternGroup.loneDiagonalCriteria.isAnyMatchedBy(textGrid)) {
            System.out.println("Grid is lone diagonal");
        } else {
            System.out.println("Grid is not lone diagonal");
        }
    }
}

