/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.tasks;

import java.io.File;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.AbstractExecTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.ConsoleRenderer;

@Incubating
@ParallelizableTask
public class RunTestExecutable
extends AbstractExecTask<RunTestExecutable> {
    private File outputDir;
    private boolean ignoreFailures;

    public RunTestExecutable() {
        super(RunTestExecutable.class);
    }

    @TaskAction
    protected void exec() {
        this.setExecutable(this.getExecutable());
        this.setWorkingDir(this.getOutputDir());
        try {
            super.exec();
        }
        catch (Exception e) {
            this.handleTestFailures(e);
        }
    }

    private void handleTestFailures(Exception e) {
        String message = "There were failing tests";
        String resultsUrl = new ConsoleRenderer().asClickableFileUrl(this.getOutputDir());
        message = message.concat(". See the results at: " + resultsUrl);
        if (!this.isIgnoreFailures()) {
            throw new GradleException(message, (Throwable)e);
        }
        this.getLogger().warn(message);
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }
}

