/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.util.SingleMessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildConfigurer
implements BuildConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildConfigurer.class);
    private final ProjectConfigurer projectConfigurer;

    public DefaultBuildConfigurer(ProjectConfigurer projectConfigurer) {
        this.projectConfigurer = projectConfigurer;
    }

    public void configure(GradleInternal gradle) {
        this.maybeInformAboutIncubatingMode(gradle);
        if (gradle.getStartParameter().isConfigureOnDemand()) {
            this.projectConfigurer.configure(gradle.getRootProject());
        } else {
            this.projectConfigurer.configureHierarchy(gradle.getRootProject());
        }
    }

    private void maybeInformAboutIncubatingMode(GradleInternal gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        if (startParameter.isParallelProjectExecutionEnabled() && startParameter.isConfigureOnDemand()) {
            SingleMessageLogger.incubatingFeatureUsed((String)"Parallel execution with configuration on demand");
            this.maybeInformAboutParallelLimitations(gradle);
        } else if (startParameter.isParallelProjectExecutionEnabled()) {
            SingleMessageLogger.incubatingFeatureUsed((String)"Parallel execution");
            this.maybeInformAboutParallelLimitations(gradle);
        } else if (startParameter.isConfigureOnDemand()) {
            SingleMessageLogger.incubatingFeatureUsed((String)"Configuration on demand");
        }
    }

    private void maybeInformAboutParallelLimitations(GradleInternal gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        int childProjectCount = gradle.getRootProject().getChildProjects().size();
        if (childProjectCount > 1 && startParameter.getTaskNames().size() > 1 && startParameter.getTaskNames().contains("clean")) {
            LOGGER.warn("Using the 'clean' task in combination with parallel execution may lead to unexpected runtime behavior.");
        }
    }
}

