/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.transform.ArtifactAttributeMatcher;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformRegistrations;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.internal.reflect.DirectInstantiator;

class InstantiatingArtifactTransforms
implements ArtifactTransforms {
    private final ResolutionStrategyInternal resolutionStrategy;
    private final ArtifactAttributeMatcher attributeMatcher;

    public InstantiatingArtifactTransforms(ResolutionStrategyInternal resolutionStrategy, ArtifactAttributeMatcher attributeMatcher) {
        this.resolutionStrategy = resolutionStrategy;
        this.attributeMatcher = attributeMatcher;
    }

    @Override
    public Transformer<List<File>, File> getTransform(AttributeContainer from, AttributeContainer to) {
        for (ArtifactTransformRegistrations.ArtifactTransformRegistration transformReg : this.resolutionStrategy.getTransforms()) {
            if (!this.attributeMatcher.attributesMatch((HasAttributes)from, transformReg.from, transformReg.from) || !this.attributeMatcher.attributesMatch((HasAttributes)to, transformReg.to, transformReg.to)) continue;
            return this.createArtifactTransformer(transformReg);
        }
        return null;
    }

    private Transformer<List<File>, File> createArtifactTransformer(ArtifactTransformRegistrations.ArtifactTransformRegistration registration) {
        ArtifactTransform artifactTransform = (ArtifactTransform)DirectInstantiator.INSTANCE.newInstance(registration.type, new Object[0]);
        registration.config.execute((Object)artifactTransform);
        return new ArtifactFileTransformer(artifactTransform, registration.to);
    }

    private static class ArtifactFileTransformer
    implements Transformer<List<File>, File> {
        private final ArtifactTransform artifactTransform;
        private final AttributeContainer outputAttributes;

        private ArtifactFileTransformer(ArtifactTransform artifactTransform, AttributeContainer outputAttributes) {
            this.artifactTransform = artifactTransform;
            this.outputAttributes = outputAttributes;
        }

        public List<File> transform(File input) {
            List<File> outputs;
            if (this.artifactTransform.getOutputDirectory() != null) {
                this.artifactTransform.getOutputDirectory().mkdirs();
            }
            if ((outputs = this.doTransform(input)) == null) {
                throw new ArtifactTransformException(input, this.outputAttributes, this.artifactTransform, (Throwable)new NullPointerException("Illegal null output from ArtifactTransform"));
            }
            for (File output : outputs) {
                if (output.exists()) continue;
                throw new ArtifactTransformException(input, this.outputAttributes, this.artifactTransform, (Throwable)new FileNotFoundException("ArtifactTransform output '" + output.getPath() + "' does not exist"));
            }
            return outputs;
        }

        private List<File> doTransform(File input) {
            try {
                return this.artifactTransform.transform(input, this.outputAttributes);
            }
            catch (Exception e) {
                throw new ArtifactTransformException(input, this.outputAttributes, this.artifactTransform, (Throwable)e);
            }
        }
    }
}

