/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3;
import org.jmol.render.CageRenderer;
import org.jmol.shape.Axes;

public class AxesRenderer
extends CageRenderer {
    private static final String[] axisLabels = new String[]{"+X", "+Y", "+Z", null, null, null, "a", "b", "c", "X", "Y", "Z", null, null, null, "X", null, "Z", null, "(Y)", null};
    private final P3 originScreen = new P3();
    private short[] colixes = new short[3];
    private P3 pt000;
    private static final String[] axesTypes = new String[]{"a", "b", "c"};

    @Override
    protected void initRenderer() {
        this.endcap = (byte)2;
        this.draw000 = false;
    }

    @Override
    protected boolean render() {
        boolean checkAxisType;
        boolean isUnitCell;
        boolean isXY;
        Axes axes = (Axes)this.shape;
        int mad10 = this.vwr.getObjectMad10(1);
        if (mad10 == 0 || !this.g3d.checkTranslucent(false)) {
            return false;
        }
        boolean bl = isXY = axes.axisXY.z != 0.0f;
        if (!isXY && this.tm.isNavigating() && this.vwr.getBoolean(603979890)) {
            return false;
        }
        this.imageFontScaling = this.vwr.imageFontScaling;
        if (this.vwr.areAxesTainted()) {
            axes.reinitShape();
        }
        this.font3d = this.vwr.gdata.getFont3DScaled(axes.font3d, this.imageFontScaling);
        int modelIndex = this.vwr.am.cmi;
        boolean isDataFrame = this.vwr.isJmolDataFrame();
        this.pt000 = isDataFrame ? this.pt0 : axes.originPoint;
        boolean bl2 = isUnitCell = this.vwr.g.axesMode == 0x24000020;
        if (this.vwr.ms.isJmolDataFrameForModel(modelIndex) && !this.vwr.ms.getJmolFrameType(modelIndex).equals("plot data")) {
            return false;
        }
        if (isUnitCell && modelIndex < 0 && this.vwr.getCurrentUnitCell() == null) {
            return false;
        }
        int nPoints = 6;
        int labelPtr = 0;
        if (isUnitCell && this.ms.unitCells != null) {
            nPoints = 3;
            labelPtr = 6;
        } else if (isXY) {
            nPoints = 3;
            labelPtr = 9;
        } else if (this.vwr.g.axesMode == 0x24000022) {
            nPoints = 6;
            int n = labelPtr = this.vwr.getBoolean(603979806) ? 15 : 9;
        }
        if (axes.labels != null) {
            if (nPoints != 3) {
                nPoints = axes.labels.length < 6 ? 3 : 6;
            }
            labelPtr = -1;
        }
        int slab = this.vwr.gdata.slab;
        int diameter = mad10;
        boolean drawTicks = false;
        P3 ptTemp = this.originScreen;
        boolean bl3 = checkAxisType = axes.axisType != null && (isXY || this.vwr.getFloat(0x22000001) != 0.0f || axes.fixedOrigin != null);
        if (isXY) {
            int i;
            if (this.exportType == 1) {
                return false;
            }
            if (mad10 >= 20) {
                int n = diameter = mad10 > 500 ? 5 : mad10 / 100;
                if (diameter == 0) {
                    diameter = 2;
                }
            } else if (this.g3d.isAntialiased()) {
                diameter += diameter;
            }
            this.g3d.setSlab(0);
            ptTemp = axes.axisXY;
            this.pt0i.setT(this.tm.transformPt2D(ptTemp));
            if (ptTemp.x < 0.0f) {
                int offx = (int)ptTemp.x;
                int offy = (int)ptTemp.x;
                this.pointT.setT(this.pt000);
                for (i = 0; i < 3; ++i) {
                    this.pointT.add(axes.getAxisPoint(i, false));
                }
                this.pt0i.setT(this.tm.transformPt(this.pt000));
                this.pt2i.scaleAdd(-1, this.pt0i, this.tm.transformPt(this.pointT));
                if (this.pt2i.x < 0) {
                    offx = -offx;
                }
                if (this.pt2i.y < 0) {
                    offy = -offy;
                }
                this.pt0i.x += offx;
                this.pt0i.y += offy;
            }
            ptTemp = this.originScreen;
            ptTemp.set(this.pt0i.x, this.pt0i.y, this.pt0i.z);
            float zoomDimension = this.vwr.getScreenDim();
            float scaleFactor = zoomDimension / 10.0f * axes.scale;
            if (this.g3d.isAntialiased()) {
                scaleFactor *= 2.0f;
            }
            for (i = 0; i < 3; ++i) {
                P3 pt = this.p3Screens[i];
                this.tm.rotatePoint(axes.getAxisPoint(i, false), pt);
                pt.z *= -1.0f;
                pt.scaleAdd2(scaleFactor, pt, ptTemp);
            }
        } else {
            boolean bl4 = drawTicks = axes.tickInfos != null;
            if (drawTicks) {
                this.checkTickTemps();
                this.tickA.setT(this.pt000);
            }
            this.tm.transformPtNoClip(this.pt000, ptTemp);
            diameter = this.getDiameter((int)ptTemp.z, mad10);
            int i = nPoints;
            while (--i >= 0) {
                this.tm.transformPtNoClip(axes.getAxisPoint(i, isDataFrame), this.p3Screens[i]);
            }
        }
        float xCenter = ptTemp.x;
        float yCenter = ptTemp.y;
        this.colixes[0] = this.vwr.getObjectColix(1);
        this.colixes[1] = this.vwr.getObjectColix(2);
        this.colixes[2] = this.vwr.getObjectColix(3);
        boolean showOrigin = !isXY && nPoints == 3 && axes.scale == 2.0f;
        int i = nPoints;
        while (--i >= 0) {
            String label;
            if (checkAxisType && !axes.axisType.contains(axesTypes[i])) continue;
            if (this.exportType != 1 && Math.abs(xCenter - this.p3Screens[i].x) + Math.abs(yCenter - this.p3Screens[i].y) <= 2.0f) {
                showOrigin = false;
                if (!false) continue;
            }
            this.colix = this.colixes[i % 3];
            this.g3d.setC(this.colix);
            String string = axes.labels == null ? axisLabels[i + labelPtr] : (label = i < axes.labels.length ? axes.labels[i] : null);
            if (label != null && label.length() > 0) {
                this.renderLabel(label, this.p3Screens[i].x, this.p3Screens[i].y, this.p3Screens[i].z, xCenter, yCenter);
            }
            if (drawTicks) {
                this.tickInfo = axes.tickInfos[i % 3 + 1];
                if (this.tickInfo == null) {
                    this.tickInfo = axes.tickInfos[0];
                }
                this.tickB.setT(axes.getAxisPoint(i, isDataFrame));
                if (this.tickInfo != null) {
                    this.tickInfo.first = 0.0f;
                    this.tickInfo.signFactor = i % 6 >= 3 ? -1 : 1;
                }
            }
            this.renderLine(ptTemp, this.p3Screens[i], diameter, drawTicks && this.tickInfo != null);
        }
        if (showOrigin) {
            String label0;
            String string = label0 = axes.labels == null || axes.labels.length == 3 || axes.labels[3] == null ? "0" : axes.labels[3];
            if (label0 != null && label0.length() != 0) {
                this.colix = this.vwr.cm.colixBackgroundContrast;
                this.g3d.setC(this.colix);
                this.renderLabel(label0, xCenter, yCenter, ptTemp.z, xCenter, yCenter);
            }
        }
        if (isXY) {
            this.g3d.setSlab(slab);
        }
        return false;
    }

    private void renderLabel(String str, float x, float y, float z, float xCenter, float yCenter) {
        int strAscent = this.font3d.getAscent();
        int strWidth = this.font3d.stringWidth(str);
        float dx = x - xCenter;
        float dy = y - yCenter;
        if (dx != 0.0f || dy != 0.0f) {
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            dx = (float)strWidth * 0.75f * dx / dist;
            dy = (float)strAscent * 0.75f * dy / dist;
            x += dx;
            y += dy;
        }
        double xStrBaseline = Math.floor(x - (float)strWidth / 2.0f);
        double yStrBaseline = Math.floor(y + (float)strAscent / 2.0f);
        this.g3d.drawString(str, this.font3d, (int)xStrBaseline, (int)yStrBaseline, (int)z, (int)z, (short)0);
    }
}

