/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class ValUtil {
    private ValUtil() {
    }

    public static List<List<Way>> getWaysInCell(Way way, Map<Point2D, List<Way>> map) {
        if (way.getNodesCount() == 0) {
            return Collections.emptyList();
        }
        Node node = way.getNode(0);
        Node node2 = way.getNode(way.getNodesCount() - 1);
        ArrayList<List<Way>> arrayList = new ArrayList<List<Way>>(2);
        HashSet<Point2D.Double> hashSet = new HashSet<Point2D.Double>();
        long l = Math.round(node.getEastNorth().east() * OsmValidator.griddetail);
        long l2 = Math.round(node.getEastNorth().north() * OsmValidator.griddetail);
        long l3 = Math.round(node2.getEastNorth().east() * OsmValidator.griddetail);
        long l4 = Math.round(node2.getEastNorth().north() * OsmValidator.griddetail);
        Point2D.Double double_ = new Point2D.Double(l, l2);
        hashSet.add(double_);
        List<Way> list = map.get(double_);
        if (list == null) {
            list = new ArrayList<Way>();
            map.put(double_, list);
        }
        arrayList.add(list);
        double_ = new Point2D.Double(l3, l4);
        if (!hashSet.contains(double_)) {
            hashSet.add(double_);
            list = map.get(double_);
            if (list == null) {
                list = new ArrayList<Way>();
                map.put(double_, list);
            }
            arrayList.add(list);
        }
        l = (long)Math.floor(node.getEastNorth().east() * OsmValidator.griddetail);
        l2 = (long)Math.floor(node.getEastNorth().north() * OsmValidator.griddetail);
        l3 = (long)Math.floor(node2.getEastNorth().east() * OsmValidator.griddetail);
        l4 = (long)Math.floor(node2.getEastNorth().north() * OsmValidator.griddetail);
        double_ = new Point2D.Double(l, l2);
        if (!hashSet.contains(double_)) {
            hashSet.add(double_);
            list = map.get(double_);
            if (list == null) {
                list = new ArrayList<Way>();
                map.put(double_, list);
            }
            arrayList.add(list);
        }
        if (!hashSet.contains(double_ = new Point2D.Double(l3, l4))) {
            hashSet.add(double_);
            list = map.get(double_);
            if (list == null) {
                list = new ArrayList<Way>();
                map.put(double_, list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static List<Point2D> getSegmentCells(Node node, Node node2, double d) {
        CheckParameterUtil.ensureParameterNotNull(node, "n1");
        CheckParameterUtil.ensureParameterNotNull(node, "n2");
        return ValUtil.getSegmentCells(node.getEastNorth(), node2.getEastNorth(), d);
    }

    public static List<Point2D> getSegmentCells(EastNorth eastNorth, EastNorth eastNorth2, double d) {
        double d2;
        CheckParameterUtil.ensureParameterNotNull(eastNorth, "en1");
        CheckParameterUtil.ensureParameterNotNull(eastNorth2, "en2");
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        double d3 = eastNorth.east() * d;
        double d4 = eastNorth2.east() * d;
        double d5 = eastNorth.north() * d + 1.0;
        double d6 = eastNorth2.north() * d + 1.0;
        if (d3 > d4) {
            d2 = d3;
            d3 = d4;
            d4 = d2;
            d2 = d5;
            d5 = d6;
            d6 = d2;
        }
        d2 = d4 - d3;
        double d7 = d6 - d5;
        long l = d5 <= d6 ? 1L : -1L;
        long l2 = (long)Math.floor(d3);
        long l3 = (long)Math.floor(d4);
        long l4 = (long)Math.floor(d5);
        long l5 = (long)Math.floor(d6);
        long l6 = l3 - l2 + Math.abs(l5 - l4) + 1L;
        while (l2 <= l3 && (l4 - l5) * l <= 0L && l6-- > 0L) {
            arrayList.add(new Point2D.Double(l2, l4));
            double d8 = d7 / d2 * ((double)(l2 + 1L) - d4) + d6 + (double)(d7 < 0.0 ? -1 : 0);
            double d9 = d2 / d7 * ((double)(l4 + (long)(d7 < 0.0 ? 0 : 1) * l) - d6) + d4;
            double d10 = Math.pow((double)(l2 + 1L) - d3, 2.0) + Math.pow(d8 - d5, 2.0);
            double d11 = Math.pow(d9 - d3, 2.0) + Math.pow((double)(l4 + l) - d5, 2.0);
            if (d10 < d11) {
                ++l2;
                continue;
            }
            l4 += l;
        }
        return arrayList;
    }
}

