/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.shortcut;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class PrefJPanel
extends JPanel {
    private final AbstractTableModel model;
    private static final String SHIFT = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 64).getModifiers());
    private static final String CTRL = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 128).getModifiers());
    private static final String ALT = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 512).getModifiers());
    private static final String META = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 256).getModifiers());
    private static Map<Integer, String> keyList = PrefJPanel.setKeyList();
    private final JCheckBox cbAlt = new JCheckBox();
    private final JCheckBox cbCtrl = new JCheckBox();
    private final JCheckBox cbMeta = new JCheckBox();
    private final JCheckBox cbShift = new JCheckBox();
    private final JCheckBox cbDefault = new JCheckBox();
    private final JCheckBox cbDisable = new JCheckBox();
    private final JosmComboBox<String> tfKey = new JosmComboBox();
    private final JTable shortcutTable = new JTable();
    private final JosmTextField filterField = new JosmTextField();

    public PrefJPanel() {
        this.model = new ScListModel();
        this.initComponents();
    }

    private static Map<Integer, String> setKeyList() {
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
        String string = Toolkit.getProperty("AWT.unknown", "Unknown");
        for (Field field : KeyEvent.class.getFields()) {
            if (!field.getName().startsWith("VK_")) continue;
            try {
                int n = field.getInt(null);
                String string2 = KeyEvent.getKeyText(n);
                if (string2 == null || string2.length() <= 0 || string2.contains(string)) continue;
                linkedHashMap.put(n, string2);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                Main.error(exception);
            }
        }
        linkedHashMap.put(-1, "");
        return linkedHashMap;
    }

    public void filter(String string) {
        this.filterField.setText(string);
    }

    private void initComponents() {
        CbAction cbAction = new CbAction(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildFilterPanel());
        this.shortcutTable.setModel(this.model);
        this.shortcutTable.getSelectionModel().addListSelectionListener(cbAction);
        this.shortcutTable.setFillsViewportHeight(true);
        this.shortcutTable.setSelectionMode(0);
        this.shortcutTable.setAutoCreateRowSorter(true);
        TableColumnModel tableColumnModel = this.shortcutTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new ShortcutTableCellRenderer(true));
        tableColumnModel.getColumn(1).setCellRenderer(new ShortcutTableCellRenderer(false));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.shortcutTable);
        JPanel jPanel = new JPanel(new GridLayout());
        jPanel.add(jScrollPane);
        this.add(jPanel);
        this.cbDefault.setAction(cbAction);
        this.cbDefault.setText(I18n.tr("Use default", new Object[0]));
        this.cbShift.setAction(cbAction);
        this.cbShift.setText(SHIFT);
        this.cbDisable.setAction(cbAction);
        this.cbDisable.setText(I18n.tr("Disable", new Object[0]));
        this.cbCtrl.setAction(cbAction);
        this.cbCtrl.setText(CTRL);
        this.cbAlt.setAction(cbAction);
        this.cbAlt.setText(ALT);
        this.tfKey.setAction(cbAction);
        this.tfKey.setModel(new DefaultComboBoxModel<String>(keyList.values().toArray(new String[keyList.size()])));
        this.cbMeta.setAction(cbAction);
        this.cbMeta.setText(META);
        JPanel jPanel2 = new JPanel(new GridLayout(5, 2));
        jPanel2.add(this.cbDefault);
        jPanel2.add(new JLabel());
        jPanel2.add(this.cbShift);
        jPanel2.add(this.cbDisable);
        jPanel2.add(this.cbCtrl);
        jPanel2.add(new JLabel(I18n.tr("Key:", new Object[0]), 2));
        jPanel2.add(this.cbAlt);
        jPanel2.add(this.tfKey);
        jPanel2.add(this.cbMeta);
        jPanel2.add(new JLabel(I18n.tr("Attention: Use real keyboard keys only!", new Object[0])));
        cbAction.actionPerformed(null);
        this.add(jPanel2);
    }

    private JPanel buildFilterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)new JLabel(I18n.tr("Search:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.filterField, gridBagConstraints);
        this.filterField.setToolTipText(I18n.tr("Enter a search expression", new Object[0]));
        SelectAllOnFocusGainedDecorator.decorate(this.filterField);
        this.filterField.getDocument().addDocumentListener(new FilterFieldAdapter());
        jPanel.setMaximumSize(new Dimension(300, 10));
        return jPanel;
    }

    class FilterFieldAdapter
    implements DocumentListener {
        FilterFieldAdapter() {
        }

        private void filter() {
            String string = PrefJPanel.this.filterField.getText().trim();
            if (string.isEmpty()) {
                string = null;
            }
            try {
                TableRowSorter tableRowSorter = (TableRowSorter)PrefJPanel.this.shortcutTable.getRowSorter();
                if (string == null) {
                    tableRowSorter.setRowFilter(null);
                } else {
                    string = string.replace("+", "\\+");
                    ArrayList arrayList = new ArrayList();
                    for (String string2 : string.split("\\s+")) {
                        arrayList.add(RowFilter.regexFilter("(?i)" + string2, new int[0]));
                    }
                    tableRowSorter.setRowFilter(RowFilter.andFilter(arrayList));
                }
                PrefJPanel.this.model.fireTableDataChanged();
            }
            catch (ClassCastException | PatternSyntaxException runtimeException) {
                Main.warn(runtimeException);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.filter();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.filter();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.filter();
        }
    }

    private static class CbAction
    extends AbstractAction
    implements ListSelectionListener {
        private final PrefJPanel panel;

        CbAction(PrefJPanel prefJPanel) {
            this.panel = prefJPanel;
        }

        private void disableAllModifierCheckboxes() {
            this.panel.cbDefault.setEnabled(false);
            this.panel.cbDisable.setEnabled(false);
            this.panel.cbShift.setEnabled(false);
            this.panel.cbCtrl.setEnabled(false);
            this.panel.cbAlt.setEnabled(false);
            this.panel.cbMeta.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = this.panel.shortcutTable.getSelectionModel();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = this.panel.shortcutTable.convertRowIndexToModel(listSelectionModel.getMinSelectionIndex());
                Shortcut shortcut = (Shortcut)this.panel.model.getValueAt(n, -1);
                this.panel.cbDefault.setSelected(!shortcut.isAssignedUser());
                this.panel.cbDisable.setSelected(shortcut.getKeyStroke() == null);
                this.panel.cbShift.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x40) != 0);
                this.panel.cbCtrl.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x80) != 0);
                this.panel.cbAlt.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x200) != 0);
                this.panel.cbMeta.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x100) != 0);
                if (shortcut.getKeyStroke() != null) {
                    this.panel.tfKey.setSelectedItem(keyList.get(shortcut.getKeyStroke().getKeyCode()));
                } else {
                    this.panel.tfKey.setSelectedItem(keyList.get(-1));
                }
                if (!shortcut.isChangeable()) {
                    this.disableAllModifierCheckboxes();
                    this.panel.tfKey.setEnabled(false);
                } else {
                    this.panel.cbDefault.setEnabled(true);
                    this.actionPerformed(null);
                }
                this.panel.model.fireTableRowsUpdated(n, n);
            } else {
                this.disableAllModifierCheckboxes();
                this.panel.tfKey.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListSelectionModel listSelectionModel = this.panel.shortcutTable.getSelectionModel();
            if (listSelectionModel != null && !listSelectionModel.isSelectionEmpty()) {
                if (actionEvent != null) {
                    int bl = this.panel.shortcutTable.convertRowIndexToModel(listSelectionModel.getMinSelectionIndex());
                    Shortcut shortcut = (Shortcut)this.panel.model.getValueAt(bl, -1);
                    if (this.panel.cbDisable.isSelected()) {
                        shortcut.setAssignedModifier(-1);
                    } else if (this.panel.tfKey.getSelectedItem() == null || "".equals(this.panel.tfKey.getSelectedItem())) {
                        shortcut.setAssignedModifier(3);
                    } else {
                        shortcut.setAssignedModifier((this.panel.cbShift.isSelected() ? 64 : 0) | (this.panel.cbCtrl.isSelected() ? 128 : 0) | (this.panel.cbAlt.isSelected() ? 512 : 0) | (this.panel.cbMeta.isSelected() ? 256 : 0));
                        for (Map.Entry entry : keyList.entrySet()) {
                            if (!((String)entry.getValue()).equals(this.panel.tfKey.getSelectedItem())) continue;
                            shortcut.setAssignedKey((Integer)entry.getKey());
                        }
                    }
                    shortcut.setAssignedUser(!this.panel.cbDefault.isSelected());
                    this.valueChanged(null);
                }
                boolean bl = !this.panel.cbDefault.isSelected();
                this.panel.cbDisable.setEnabled(bl);
                boolean bl2 = bl && !this.panel.cbDisable.isSelected();
                this.panel.cbShift.setEnabled(bl2);
                this.panel.cbCtrl.setEnabled(bl2);
                this.panel.cbAlt.setEnabled(bl2);
                this.panel.cbMeta.setEnabled(bl2);
                this.panel.tfKey.setEnabled(bl2);
            } else {
                this.disableAllModifierCheckboxes();
                this.panel.tfKey.setEnabled(false);
            }
        }
    }

    private class ShortcutTableCellRenderer
    extends DefaultTableCellRenderer {
        private final transient ColorProperty SHORTCUT_BACKGROUND_USER_COLOR = new ColorProperty(I18n.marktr("Shortcut Background: User"), new Color(200, 255, 200));
        private final transient ColorProperty SHORTCUT_BACKGROUND_MODIFIED_COLOR = new ColorProperty(I18n.marktr("Shortcut Background: Modified"), new Color(255, 255, 200));
        private final boolean name;

        ShortcutTableCellRenderer(boolean bl) {
            this.name = bl;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = PrefJPanel.this.shortcutTable.convertRowIndexToModel(n);
            Shortcut shortcut = (Shortcut)PrefJPanel.this.model.getValueAt(n3, -1);
            if (shortcut == null) {
                return null;
            }
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, this.name ? shortcut.getLongText() : shortcut.getKeyText(), bl, bl2, n, n2);
            GuiHelper.setBackgroundReadable(jLabel, UIManager.getColor("Table.background"));
            if (shortcut.isAssignedUser()) {
                GuiHelper.setBackgroundReadable(jLabel, this.SHORTCUT_BACKGROUND_USER_COLOR.get());
            } else if (!shortcut.isAssignedDefault()) {
                GuiHelper.setBackgroundReadable(jLabel, this.SHORTCUT_BACKGROUND_MODIFIED_COLOR.get());
            }
            return jLabel;
        }
    }

    private static class ScListModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{I18n.tr("Action", new Object[0]), I18n.tr("Shortcut", new Object[0])};
        private final transient List<Shortcut> data = Shortcut.listAll();

        ScListModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? this.data.get(n).getLongText() : this.data.get(n);
        }
    }
}

