/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.lang.ref.Reference;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiParameterImpl
extends JavaStubPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiParameterImpl");
    private volatile Reference<PsiType> myCachedType;

    public PsiParameterImpl(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        this(stub, (IStubElementType)JavaStubElementTypes.PARAMETER);
    }

    protected PsiParameterImpl(@NotNull PsiParameterStub stub, @NotNull IStubElementType type2) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        super(stub, type2);
    }

    public PsiParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/PsiParameterImpl", "<init>"));
        }
        super(node);
    }

    public static PsiType getLambdaParameterType(PsiParameter param) {
        PsiLambdaExpression lambdaExpression;
        int parameterIndex;
        PsiElement paramParent = param.getParent();
        if (paramParent instanceof PsiParameterList && (parameterIndex = ((PsiParameterList)paramParent).getParameterIndex(param)) > -1 && (lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)param, PsiLambdaExpression.class)) != null) {
            PsiType functionalInterfaceType = LambdaUtil.ourParameterGuard.doPreventingRecursion(param, false, new Computable<PsiType>(){

                @Override
                public PsiType compute() {
                    return LambdaUtil.getFunctionalInterfaceType(lambdaExpression, true);
                }
            });
            PsiType type2 = FunctionalInterfaceParameterizationUtil.getGroundTargetType(functionalInterfaceType, lambdaExpression);
            if (type2 instanceof PsiIntersectionType) {
                PsiType[] conjuncts;
                for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type2).getConjuncts()) {
                    PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType(conjunct, parameterIndex);
                    if (lambdaParameterFromType == null) continue;
                    return lambdaParameterFromType;
                }
            } else {
                PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType(type2, parameterIndex);
                if (lambdaParameterFromType != null) {
                    return lambdaParameterFromType;
                }
            }
        }
        return new PsiLambdaParameterType(param);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiParameterImpl clone = (PsiParameterImpl)super.clone();
        clone.myCachedType = null;
        return clone;
    }

    @Override
    @NotNull
    public final String getName() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getName"));
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getName"));
        }
        return string;
    }

    @Override
    public final PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiParameterImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = PsiTreeUtil.getRequiredChildOfType(this, PsiIdentifier.class);
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getNameIdentifier"));
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getNode"));
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            PsiType type2 = SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                type2 = JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createTypeFromText(typeText, this);
                type2 = JavaSharedImplUtil.applyAnnotations(type2, this.getModifierList());
                this.myCachedType = new SoftReference<PsiType>(type2);
            }
            PsiType psiType = type2;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
            }
            return psiType;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement == null) {
            assert (this.isLambdaParameter()) : this;
            PsiType psiType = PsiParameterImpl.getLambdaParameterType(this);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
            }
            return psiType;
        }
        PsiType psiType = JavaSharedImplUtil.getType(typeElement, this.getNameIdentifier());
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getType"));
        }
        return psiType;
    }

    private boolean isLambdaParameter() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof PsiParameterList && parent2.getParent() instanceof PsiLambdaExpression;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiTypeElement)) continue;
            return (PsiTypeElement)child;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList modifierList = this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        assert (modifierList != null) : this;
        PsiModifierList psiModifierList = modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiParameterImpl", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiParameterImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameter(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiParameter:" + this.getName();
    }

    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement parent2 = this.getParent();
        if (parent2 == null) {
            PsiParameterImpl psiParameterImpl = this;
            if (psiParameterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiParameterImpl;
        }
        if (parent2 instanceof PsiParameterList) {
            PsiElement psiElement = parent2.getParent();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        if (parent2 instanceof PsiForeachStatement) {
            PsiElement psiElement = parent2;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        if (parent2 instanceof PsiCatchSection) {
            PsiElement psiElement = parent2;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
            }
            return psiElement;
        }
        PsiElement[] children = parent2.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].equals(this)) continue;
                for (int j = i + 1; j < children.length; ++j) {
                    if (!(children[j] instanceof PsiCodeBlock)) continue;
                    PsiElement psiElement = children[j];
                    if (psiElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
                    }
                    return psiElement;
                }
                break;
            }
        }
        LOG.error("Code block not found among parameter' (" + this + ") parent' (" + parent2 + ") children: " + Arrays.asList(children));
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getDeclarationScope"));
        }
        return null;
    }

    @Override
    public boolean isVarArgs() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            return stub.isParameterTypeEllipsis();
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        return typeElement != null && SourceTreeToPsiMap.psiToTreeNotNull(typeElement).findChildByType(JavaTokenType.ELLIPSIS) != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = PsiParameterImpl.createLayeredIcon(this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope = this.getDeclarationScope();
        LocalSearchScope localSearchScope = new LocalSearchScope(declarationScope);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiParameterImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiParameter[] originalParameters;
        int index2;
        PsiElement originalMethod;
        PsiElement gParent;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiParameterList && (gParent = parent2.getParent()) instanceof PsiMethod && (originalMethod = gParent.getOriginalElement()) instanceof PsiMethod && (index2 = ((PsiParameterList)parent2).getParameterIndex(this)) < (originalParameters = ((PsiMethod)originalMethod).getParameterList().getParameters()).length) {
            return originalParameters[index2];
        }
        return this;
    }
}

