/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeParameterImpl;
import org.jetbrains.kotlin.name.FqName;

public abstract class JavaClassifierImpl<Psi extends PsiClass>
extends JavaElementImpl<Psi>
implements JavaClassifier,
JavaAnnotationOwnerImpl {
    protected JavaClassifierImpl(@NotNull Psi psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierImpl", "<init>"));
        }
        super(psiClass);
    }

    @NotNull
    static JavaClassifierImpl<?> create(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierImpl", "create"));
        }
        if (psiClass instanceof PsiTypeParameter) {
            JavaTypeParameterImpl javaTypeParameterImpl = new JavaTypeParameterImpl((PsiTypeParameter)psiClass);
            if (javaTypeParameterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierImpl", "create"));
            }
            return javaTypeParameterImpl;
        }
        JavaClassImpl javaClassImpl = new JavaClassImpl(psiClass);
        if (javaClassImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierImpl", "create"));
        }
        return javaClassImpl;
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        Collection<JavaAnnotation> collection = JavaElementUtil.getAnnotations(this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierImpl", "getAnnotations"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierImpl", "findAnnotation"));
        }
        return JavaElementUtil.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return ((PsiClass)this.getPsi()).isDeprecated();
    }
}

