/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.util;

import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0017\u0010\r\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0086\bJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/kapt3/util/KaptLogger;", "", "isVerbose", "", "(Z)V", "()Z", "error", "", "message", "", "exception", "e", "", "info", "Lkotlin/Function0;", "warn", "Companion", "annotation-processing"})
public final class KaptLogger {
    private final boolean isVerbose;
    @NotNull
    private static final String PREFIX = "[kapt] ";
    public static final Companion Companion = new Companion(null);

    public final void info(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.isVerbose) {
            String string = Companion.getPREFIX() + message;
            System.out.println((Object)string);
        }
    }

    public final void info(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.isVerbose()) {
            this.info((String)message.invoke());
        }
    }

    public final void warn(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        String string = Companion.getPREFIX() + message;
        System.out.println((Object)string);
    }

    public final void error(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        System.err.println(Companion.getPREFIX() + message);
    }

    public final void exception(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        System.err.println(Companion.getPREFIX() + "An exception occurred:");
        Throwable throwable = e;
        PrintStream printStream = System.err;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.err");
        PrintStream printStream2 = printStream;
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
        }
        throwable2.printStackTrace(printStream2);
    }

    public final boolean isVerbose() {
        return this.isVerbose;
    }

    public KaptLogger(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    static {
        PREFIX = PREFIX;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/kapt3/util/KaptLogger$Companion;", "", "()V", "PREFIX", "", "getPREFIX", "()Ljava/lang/String;", "annotation-processing"})
    private static final class Companion {
        @NotNull
        public final String getPREFIX() {
            return PREFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

