/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.chunking.Chunker;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.Unifier;
import org.languagetool.rules.patterns.UnifierConfiguration;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.xx.DemoDisambiguator;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SimpleSentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;

public abstract class Language {
    private static final Disambiguator DEMO_DISAMBIGUATOR = new DemoDisambiguator();
    private static final Tagger DEMO_TAGGER = new DemoTagger();
    private static final SentenceTokenizer SENTENCE_TOKENIZER = new SimpleSentenceTokenizer();
    private static final WordTokenizer WORD_TOKENIZER = new WordTokenizer();
    private final UnifierConfiguration unifierConfig = new UnifierConfiguration();
    private final UnifierConfiguration disambiguationUnifierConfig = new UnifierConfiguration();
    private final Pattern ignoredCharactersRegex = Pattern.compile("[\u00ad]");
    private List<AbstractPatternRule> patternRules;

    @Deprecated
    public abstract String getShortName();

    public abstract String getShortCode();

    public abstract String getName();

    public abstract String[] getCountries();

    @Nullable
    public abstract Contributor[] getMaintainers();

    public abstract List<Rule> getRelevantRules(ResourceBundle var1) throws IOException;

    @Nullable
    public String getVariant() {
        return null;
    }

    public List<String> getDefaultEnabledRulesForVariant() {
        return Collections.emptyList();
    }

    public List<String> getDefaultDisabledRulesForVariant() {
        return Collections.emptyList();
    }

    @Nullable
    public LanguageModel getLanguageModel(File indexDir) throws IOException {
        return null;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Collections.emptyList();
    }

    public Locale getLocale() {
        return new Locale(this.getShortCode());
    }

    public Locale getLocaleWithCountryAndVariant() {
        if (this.getCountries().length > 0) {
            if (this.getVariant() != null) {
                return new Locale(this.getShortCode(), this.getCountries()[0], this.getVariant());
            }
            return new Locale(this.getShortCode(), this.getCountries()[0]);
        }
        return this.getLocale();
    }

    public List<String> getRuleFileNames() {
        String fileName;
        ArrayList<String> ruleFiles = new ArrayList<String>();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        ruleFiles.add(dataBroker.getRulesDir() + "/" + this.getShortCode() + "/" + "grammar.xml");
        if (this.getShortCodeWithCountryAndVariant().length() > 2 && dataBroker.ruleFileExists(fileName = this.getShortCode() + "/" + this.getShortCodeWithCountryAndVariant() + "/" + "grammar.xml")) {
            ruleFiles.add(dataBroker.getRulesDir() + "/" + fileName);
        }
        return ruleFiles;
    }

    @Nullable
    public Language getDefaultLanguageVariant() {
        return null;
    }

    public Disambiguator getDisambiguator() {
        return DEMO_DISAMBIGUATOR;
    }

    public Tagger getTagger() {
        return DEMO_TAGGER;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        return SENTENCE_TOKENIZER;
    }

    public Tokenizer getWordTokenizer() {
        return WORD_TOKENIZER;
    }

    @Nullable
    public Chunker getChunker() {
        return null;
    }

    @Nullable
    public Chunker getPostDisambiguationChunker() {
        return null;
    }

    @Nullable
    public Synthesizer getSynthesizer() {
        return null;
    }

    public Unifier getUnifier() {
        return this.unifierConfig.createUnifier();
    }

    public Unifier getDisambiguationUnifier() {
        return this.disambiguationUnifierConfig.createUnifier();
    }

    public UnifierConfiguration getUnifierConfiguration() {
        return this.unifierConfig;
    }

    public UnifierConfiguration getDisambiguationUnifierConfiguration() {
        return this.disambiguationUnifierConfig;
    }

    public final String getTranslatedName(ResourceBundle messages) {
        try {
            return messages.getString(this.getShortCodeWithCountryAndVariant());
        }
        catch (MissingResourceException e) {
            try {
                return messages.getString(this.getShortCode());
            }
            catch (MissingResourceException e1) {
                return this.getName();
            }
        }
    }

    public final String getShortCodeWithCountryAndVariant() {
        String name = this.getShortCode();
        if (this.getCountries().length == 1 && !name.contains("-x-")) {
            name = name + "-" + this.getCountries()[0];
            if (this.getVariant() != null) {
                name = name + "-" + this.getVariant();
            }
        }
        return name;
    }

    @Deprecated
    public final String getShortNameWithCountryAndVariant() {
        return this.getShortCodeWithCountryAndVariant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<AbstractPatternRule> getPatternRules() throws IOException {
        if (this.patternRules == null) {
            ArrayList<AbstractPatternRule> rules = new ArrayList<AbstractPatternRule>();
            PatternRuleLoader ruleLoader = new PatternRuleLoader();
            for (String fileName : this.getRuleFileNames()) {
                try (InputStream is = null;){
                    is = this.getClass().getResourceAsStream(fileName);
                    if (is == null) {
                        is = new FileInputStream(fileName);
                    }
                    rules.addAll(ruleLoader.getRules(is, fileName));
                    this.patternRules = Collections.unmodifiableList(rules);
                }
            }
        }
        return this.patternRules;
    }

    public final String toString() {
        return this.getName();
    }

    public final boolean isVariant() {
        for (Language language : Languages.get()) {
            boolean skip = language.getShortCodeWithCountryAndVariant().equals(this.getShortCodeWithCountryAndVariant());
            if (skip || !language.getClass().isAssignableFrom(this.getClass())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasVariant() {
        for (Language language : Languages.get()) {
            boolean skip = language.getShortCodeWithCountryAndVariant().equals(this.getShortCodeWithCountryAndVariant());
            if (skip || !this.getClass().isAssignableFrom(language.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean equalsConsiderVariantsIfSpecified(Language otherLanguage) {
        if (this.getShortCode().equals(otherLanguage.getShortCode())) {
            boolean thisHasCountry = this.hasCountry();
            boolean otherHasCountry = otherLanguage.hasCountry();
            return !thisHasCountry || !otherHasCountry || this.getShortCodeWithCountryAndVariant().equals(otherLanguage.getShortCodeWithCountryAndVariant());
        }
        return false;
    }

    private boolean hasCountry() {
        return this.getCountries().length == 1;
    }

    public Pattern getIgnoredCharactersRegex() {
        return this.ignoredCharactersRegex;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.LookingForNewMaintainer;
    }

    public boolean isHiddenFromGui() {
        return this.hasVariant() && !this.isVariant() && !this.isTheDefaultVariant();
    }

    private boolean isTheDefaultVariant() {
        if (this.getDefaultLanguageVariant() != null) {
            return this.getClass().equals(this.getDefaultLanguageVariant().getClass());
        }
        return false;
    }

    public int getPriorityForId(String id) {
        return 0;
    }
}

