/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.net.HttpCookie;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsTableModel;
import org.zaproxy.zap.session.CookieBasedSessionManagementHelper;

public class HttpSessionsSite {
    private static final Logger log = Logger.getLogger(HttpSessionsSite.class);
    private static int lastGeneratedSessionID = 0;
    private ExtensionHttpSessions extension;
    private String site;
    private Set<HttpSession> sessions;
    private HttpSession activeSession;
    private HttpSessionsTableModel model;

    public HttpSessionsSite(ExtensionHttpSessions extensionHttpSessions, String string) {
        this.extension = extensionHttpSessions;
        this.site = string;
        this.sessions = new LinkedHashSet<HttpSession>();
        this.model = new HttpSessionsTableModel(this);
        this.activeSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSession(HttpSession httpSession) {
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            this.sessions.add(httpSession);
        }
        this.model.addHttpSession(httpSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHttpSession(HttpSession httpSession) {
        if (httpSession == this.activeSession) {
            this.activeSession = null;
        }
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(httpSession);
        }
        this.model.removeHttpSession(httpSession);
        httpSession.invalidate();
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String string) {
        this.site = string;
    }

    public HttpSession getActiveSession() {
        return this.activeSession;
    }

    public void setActiveSession(HttpSession httpSession) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting new active session for site '" + this.site + "': " + httpSession));
        }
        if (httpSession == null) {
            throw new IllegalArgumentException("When settting an active session, a non-null session has to be provided.");
        }
        if (this.activeSession == httpSession) {
            return;
        }
        if (this.activeSession != null) {
            this.activeSession.setActive(false);
            if (this.activeSession.getTokenValuesCount() == 0) {
                this.removeHttpSession(this.activeSession);
            } else {
                this.model.fireHttpSessionUpdated(this.activeSession);
            }
        }
        this.activeSession = httpSession;
        httpSession.setActive(true);
        this.model.fireHttpSessionUpdated(httpSession);
    }

    public void unsetActiveSession() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting no active session for site '" + this.site + "'."));
        }
        if (this.activeSession != null) {
            this.activeSession.setActive(false);
            if (this.activeSession.getTokenValuesCount() == 0) {
                this.removeHttpSession(this.activeSession);
            } else {
                this.model.fireHttpSessionUpdated(this.activeSession);
            }
            this.activeSession = null;
        }
    }

    private String generateUniqueSessionName() {
        String string;
        while (!this.isSessionNameUnique(string = MessageFormat.format(Constant.messages.getString("httpsessions.session.defaultName"), lastGeneratedSessionID++))) {
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSessionNameUnique(String string) {
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            for (HttpSession httpSession : this.sessions) {
                if (!string.equals(httpSession.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private static void validateSessionName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Session name must not be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Session name must not be empty.");
        }
    }

    private void createEmptySessionAndSetAsActive(String string) {
        HttpSessionsSite.validateSessionName(string);
        HttpSession httpSession = new HttpSession(string, this.extension.getHttpSessionTokensSet(this.getSite()));
        this.addHttpSession(httpSession);
        this.setActiveSession(httpSession);
    }

    public void createEmptySession(String string) {
        HttpSessionsSite.validateSessionName(string);
        if (!this.isSessionNameUnique(string)) {
            return;
        }
        this.createEmptySessionAndSetAsActive(string);
    }

    public void createEmptySession() {
        this.createEmptySessionAndSetAsActive(this.generateUniqueSessionName());
    }

    public HttpSessionsTableModel getModel() {
        return this.model;
    }

    public void processHttpRequestMessage(HttpMessage httpMessage) {
        HttpSessionTokensSet httpSessionTokensSet = this.extension.getHttpSessionTokensSet(this.getSite());
        if (httpSessionTokensSet == null) {
            log.debug((Object)("No session tokens for: " + this.getSite()));
            return;
        }
        List<HttpCookie> list = httpMessage.getRequestHeader().getHttpCookies();
        HttpSession httpSession = this.getMatchingHttpSession(list, httpSessionTokensSet);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matching session for request message (for site " + this.getSite() + "): " + httpSession));
        }
        if (this.activeSession != null && this.activeSession != httpSession) {
            CookieBasedSessionManagementHelper.processMessageToMatchSession(httpMessage, list, this.activeSession);
        } else {
            if (this.activeSession == httpSession) {
                log.debug((Object)"Session of request message is the same as the active session, so no request changes needed.");
            } else {
                log.debug((Object)"No active session is selected.");
            }
            httpMessage.setHttpSession(httpSession);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processHttpResponseMessage(HttpMessage httpMessage) {
        void var6_11;
        void var6_9;
        Object object;
        Object object2;
        HttpSessionTokensSet httpSessionTokensSet = this.extension.getHttpSessionTokensSet(this.getSite());
        if (httpSessionTokensSet == null) {
            log.debug((Object)("No session tokens for: " + this.getSite()));
            return;
        }
        HashMap<Object, Cookie> hashMap = new HashMap<Object, Cookie>();
        List<HttpCookie> list = httpMessage.getResponseHeader().getHttpCookies(httpMessage.getRequestHeader().getHostName());
        for (HttpCookie object32 : list) {
            object2 = object32.getName();
            if (!httpSessionTokensSet.isSessionToken((String)object2)) continue;
            try {
                long l = object32.getMaxAge() < -1L ? 0L : object32.getMaxAge();
                object = new Cookie(object32.getDomain(), (String)object2, object32.getValue(), object32.getPath(), (int)l, object32.getSecure());
                hashMap.put(object2, (Cookie)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn((Object)("Failed to create cookie [" + object32 + "] for site [" + this.getSite() + "]: " + illegalArgumentException.getMessage()));
            }
        }
        List<HttpCookie> list2 = httpMessage.getRequestHeader().getHttpCookies();
        HttpSession httpSession = httpMessage.getHttpSession();
        if (httpSession == null || !httpSession.isValid()) {
            HttpSession httpSession2 = this.getMatchingHttpSession(list2, httpSessionTokensSet);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matching session for response message (from site " + this.getSite() + "): " + httpSession2));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Matching cached session for response message (from site " + this.getSite() + "): " + httpSession));
        }
        if (var6_9 == null) {
            HttpSession httpSession3 = new HttpSession(this.generateUniqueSessionName(), this.extension.getHttpSessionTokensSet(this.getSite()));
            this.addHttpSession(httpSession3);
            object2 = list2.iterator();
            while (object2.hasNext()) {
                String string;
                HttpCookie httpCookie = (HttpCookie)object2.next();
                String string2 = httpCookie.getName();
                if (!httpSessionTokensSet.isSessionToken(string2) || hashMap.containsKey(string2)) continue;
                object = httpCookie.getDomain();
                if (object == null) {
                    object = httpMessage.getRequestHeader().getHostName();
                }
                if ((string = httpCookie.getPath()) == null) {
                    string = "/";
                }
                Cookie cookie = new Cookie((String)object, string2, httpCookie.getValue(), string, (int)httpCookie.getMaxAge(), httpCookie.getSecure());
                hashMap.put(string2, cookie);
            }
            log.info((Object)("Created a new session as no match was found: " + httpSession3));
        }
        if (!hashMap.isEmpty()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                var6_11.setTokenValue((String)entry.getKey(), (Cookie)entry.getValue());
            }
        }
        var6_11.setMessagesMatched(var6_11.getMessagesMatched() + 1);
        this.model.fireHttpSessionUpdated((HttpSession)var6_11);
        httpMessage.setHttpSession((HttpSession)var6_11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpSession getMatchingHttpSession(List<HttpCookie> list, HttpSessionTokensSet httpSessionTokensSet) {
        ArrayList<HttpSession> arrayList;
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            arrayList = new ArrayList<HttpSession>(this.sessions);
        }
        return CookieBasedSessionManagementHelper.getMatchingHttpSession(arrayList, list, httpSessionTokensSet);
    }

    public String toString() {
        return "HttpSessionsSite [site=" + this.site + ", activeSession=" + this.activeSession + ", sessions=" + this.sessions + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupSessionToken(String string) {
        if (this.sessions.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing duplicates and cleaning up sessions for site - token: " + this.site + " - " + string));
        }
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            HttpSessionTokensSet httpSessionTokensSet = this.extension.getHttpSessionTokensSet(this.site);
            if (httpSessionTokensSet == null) {
                log.info((Object)"No more session tokens. Removing all sessions...");
                for (HttpSession httpSession : this.sessions) {
                    httpSession.invalidate();
                }
                this.sessions.clear();
                this.activeSession = null;
                this.model.removeAllElements();
                return;
            }
            HashMap<String, HttpSession> hashMap = new HashMap<String, HttpSession>(this.sessions.size());
            LinkedList<HttpSession> linkedList = new LinkedList<HttpSession>();
            for (HttpSession httpSession : this.sessions) {
                httpSession.removeToken(string);
                if (httpSession.getTokenValuesCount() == 0 && !httpSession.isActive()) {
                    linkedList.add(httpSession);
                    continue;
                }
                this.model.fireHttpSessionUpdated(httpSession);
                if (hashMap.containsKey(httpSession.getTokenValuesString())) {
                    HttpSession httpSession2 = (HttpSession)hashMap.get(httpSession.getTokenValuesString());
                    if (httpSession.isActive()) {
                        linkedList.add(httpSession2);
                        httpSession.setMessagesMatched(httpSession.getMessagesMatched() + httpSession2.getMessagesMatched());
                        continue;
                    }
                    linkedList.add(httpSession);
                    httpSession2.setMessagesMatched(httpSession.getMessagesMatched() + httpSession2.getMessagesMatched());
                    continue;
                }
                hashMap.put(httpSession.getTokenValuesString(), httpSession);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing duplicate or empty sessions: " + linkedList));
            }
            for (HttpSession httpSession : linkedList) {
                httpSession.invalidate();
                this.sessions.remove(httpSession);
                this.model.removeHttpSession(httpSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<HttpSession> getHttpSessions() {
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            return Collections.unmodifiableSet(this.sessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession getHttpSession(String string) {
        Set<HttpSession> set = this.sessions;
        synchronized (set) {
            for (HttpSession httpSession : this.sessions) {
                if (!httpSession.getName().equals(string)) continue;
                return httpSession;
            }
        }
        return null;
    }

    public boolean renameHttpSession(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            log.warn((Object)("Trying to rename session from " + string + " illegal name: " + string2));
            return false;
        }
        HttpSession httpSession = this.getHttpSession(string);
        if (httpSession == null) {
            return false;
        }
        if (this.getHttpSession(string2) != null) {
            log.warn((Object)("Trying to rename session from " + string + " to already existing: " + string2));
            return false;
        }
        httpSession.setName(string2);
        this.model.fireHttpSessionUpdated(httpSession);
        return true;
    }

    static void resetLastGeneratedSessionId() {
        lastGeneratedSessionID = 0;
    }
}

