/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.extension.search.HttpSearcher;
import org.zaproxy.zap.extension.search.SearchListenner;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchResult;

public class SearchThread
extends Thread {
    private static final String THREAD_NAME = "ZAP-SearchThread";
    private String filter;
    private ExtensionSearch.Type reqType;
    private SearchListenner searchListenner;
    private boolean stopSearch = false;
    private boolean inverse = false;
    private boolean searchJustInScope = false;
    private String baseUrl;
    private PaginationConstraintsChecker pcc;
    private Map<String, HttpSearcher> searchers;
    private String customSearcherName;
    private boolean searchAllOccurrences;
    private static Logger log = Logger.getLogger(SearchThread.class);

    public SearchThread(String string, ExtensionSearch.Type type, SearchListenner searchListenner, boolean bl, boolean bl2, String string2, int n, int n2) {
        this(string, type, searchListenner, bl, bl2, string2, n, n2, true);
    }

    public SearchThread(String string, ExtensionSearch.Type type, SearchListenner searchListenner, boolean bl, boolean bl2, String string2, int n, int n2, boolean bl3) {
        this(string, type, searchListenner, bl, bl2, string2, n, n2, bl3, -1);
    }

    public SearchThread(String string, ExtensionSearch.Type type, SearchListenner searchListenner, boolean bl, boolean bl2, String string2, int n, int n2, boolean bl3, int n3) {
        this(string, type, null, searchListenner, bl, bl2, string2, n, n2, bl3, n3);
    }

    public SearchThread(String string, ExtensionSearch.Type type, String string2, SearchListenner searchListenner, boolean bl, boolean bl2, String string3, int n, int n2, boolean bl3, int n3) {
        super(THREAD_NAME);
        this.filter = string;
        this.reqType = type;
        this.customSearcherName = string2;
        this.searchListenner = searchListenner;
        this.inverse = bl;
        this.searchJustInScope = bl2;
        this.baseUrl = string3;
        this.pcc = new PaginationConstraintsChecker(n, n2, n3);
        this.searchAllOccurrences = bl3;
    }

    public void setCustomSearchers(Map<String, HttpSearcher> map) {
        this.searchers = map;
    }

    public void stopSearch() {
        this.stopSearch = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.search();
        }
        finally {
            this.searchListenner.searchComplete();
        }
    }

    private void search() {
        Session session = Model.getSingleton().getSession();
        Pattern pattern = Pattern.compile(this.filter, 10);
        Matcher matcher = null;
        try {
            if (ExtensionSearch.Type.Custom.equals((Object)this.reqType)) {
                HttpSearcher httpSearcher;
                if (this.searchers != null && this.customSearcherName != null && (httpSearcher = this.searchers.get(this.customSearcherName)) != null) {
                    List<SearchResult> list = this.pcc.hasMaximumMatches() ? httpSearcher.search(pattern, this.inverse, this.pcc.getMaximumMatches()) : httpSearcher.search(pattern, this.inverse);
                    for (SearchResult searchResult : list) {
                        this.searchListenner.addSearchResult(searchResult);
                    }
                }
                return;
            }
            List<Integer> list = Model.getSingleton().getDb().getTableHistory().getHistoryIdsOfHistType(session.getSessionId(), 1, 15, 2, 10);
            int n = list.size();
            int n2 = 0;
            for (int i = 0; i < n && !this.stopSearch; ++i) {
                block33: {
                    int n3 = list.get(i);
                    try {
                        n2 = i;
                        HistoryReference historyReference = new HistoryReference(n3);
                        HttpMessage httpMessage = historyReference.getHttpMessage();
                        if (this.searchJustInScope && !session.isInScope(httpMessage.getRequestHeader().getURI().toString()) || this.baseUrl != null && !httpMessage.getRequestHeader().getURI().toString().startsWith(this.baseUrl)) continue;
                        if (ExtensionSearch.Type.URL.equals((Object)this.reqType)) {
                            String string = httpMessage.getRequestHeader().getURI().toString();
                            matcher = pattern.matcher(string);
                            if (this.inverse && !this.pcc.allMatchesProcessed()) {
                                if (!matcher.find()) {
                                    this.notifyInverseMatchFound(n2, httpMessage, SearchMatch.Location.REQUEST_HEAD);
                                }
                            } else {
                                int n4 = httpMessage.getRequestHeader().getPrimeHeader().indexOf(string);
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(n2, matcher.group(), httpMessage, SearchMatch.Location.REQUEST_HEAD, n4 + matcher.start(), n4 + matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                            }
                        }
                        if (ExtensionSearch.Type.Header.equals((Object)this.reqType)) {
                            matcher = pattern.matcher(httpMessage.getRequestHeader().toString());
                            if (this.inverse && !this.pcc.allMatchesProcessed()) {
                                if (!matcher.find()) {
                                    this.notifyInverseMatchFound(n2, httpMessage, SearchMatch.Location.REQUEST_HEAD);
                                }
                            } else {
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(n2, matcher.group(), httpMessage, SearchMatch.Location.REQUEST_HEAD, matcher.start(), matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                            }
                            matcher = pattern.matcher(httpMessage.getResponseHeader().toString());
                            if (this.inverse && !this.pcc.allMatchesProcessed()) {
                                if (!matcher.find()) {
                                    this.notifyInverseMatchFound(n2, httpMessage, SearchMatch.Location.RESPONSE_HEAD);
                                }
                            } else {
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(n2, matcher.group(), httpMessage, SearchMatch.Location.RESPONSE_HEAD, matcher.start(), matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                            }
                        }
                        if (ExtensionSearch.Type.Request.equals((Object)this.reqType) || ExtensionSearch.Type.All.equals((Object)this.reqType)) {
                            if (this.inverse && !this.pcc.allMatchesProcessed()) {
                                if (!pattern.matcher(httpMessage.getRequestHeader().toString()).find() && !pattern.matcher(httpMessage.getRequestBody().toString()).find()) {
                                    this.notifyInverseMatchFound(n2, httpMessage, SearchMatch.Location.REQUEST_HEAD);
                                }
                            } else {
                                matcher = pattern.matcher(httpMessage.getRequestHeader().toString());
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(n2, matcher.group(), httpMessage, SearchMatch.Location.REQUEST_HEAD, matcher.start(), matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                                matcher = pattern.matcher(httpMessage.getRequestBody().toString());
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(n2, matcher.group(), httpMessage, SearchMatch.Location.REQUEST_BODY, matcher.start(), matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                            }
                        }
                        if (!ExtensionSearch.Type.Response.equals((Object)this.reqType) && !ExtensionSearch.Type.All.equals((Object)this.reqType)) break block33;
                        if (this.inverse && !this.pcc.allMatchesProcessed()) {
                            if (!pattern.matcher(httpMessage.getResponseHeader().toString()).find() && !pattern.matcher(httpMessage.getResponseBody().toString()).find()) {
                                this.notifyInverseMatchFound(n2, httpMessage, SearchMatch.Location.RESPONSE_HEAD);
                            }
                            break block33;
                        }
                        matcher = pattern.matcher(httpMessage.getResponseHeader().toString());
                        while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                            this.notifyMatchFound(n2, matcher.group(), httpMessage, SearchMatch.Location.RESPONSE_HEAD, matcher.start(), matcher.end());
                            if (this.searchAllOccurrences) continue;
                        }
                        matcher = pattern.matcher(httpMessage.getResponseBody().toString());
                        while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                            this.notifyMatchFound(n2, matcher.group(), httpMessage, SearchMatch.Location.RESPONSE_BODY, matcher.start(), matcher.end());
                            if (this.searchAllOccurrences) continue;
                            break;
                        }
                    }
                    catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                        log.error((Object)httpMalformedHeaderException.getMessage(), (Throwable)httpMalformedHeaderException);
                    }
                }
                if (!this.pcc.hasPageEnded()) {
                    continue;
                }
                break;
            }
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
    }

    private void notifyInverseMatchFound(int n, HttpMessage httpMessage, SearchMatch.Location location) {
        this.notifyMatchFound(n, "", httpMessage, location, 0, 0);
    }

    private void notifyMatchFound(int n, String string, HttpMessage httpMessage, SearchMatch.Location location, int n2, int n3) {
        this.pcc.recordProcessed(n);
        if (!this.pcc.hasPageStarted()) {
            return;
        }
        this.pcc.matchProcessed();
        this.searchListenner.addSearchResult(new SearchResult(this.reqType, this.filter, string, new SearchMatch(httpMessage, location, n2, n3)));
    }

    private static class PaginationConstraintsChecker {
        private boolean pageStarted;
        private boolean pageEnded;
        private final int startRecord;
        private final boolean hasEnd;
        private final int finalRecord;
        private int recordsProcessed = 0;
        private int currentRecordId = -1;
        private final int maximumMatches;
        private final boolean hasMaximumMatches;
        private boolean allMatchesProcessed;
        private int matchesProcessed = 0;

        public PaginationConstraintsChecker(int n, int n2, int n3) {
            if (n > 0) {
                this.pageStarted = false;
                this.startRecord = n;
            } else {
                this.pageStarted = true;
                this.startRecord = 0;
            }
            if (n2 > 0) {
                this.hasEnd = true;
                this.finalRecord = !this.pageStarted ? n + n2 - 1 : n2;
            } else {
                this.hasEnd = false;
                this.finalRecord = 0;
            }
            this.pageEnded = false;
            this.allMatchesProcessed = false;
            this.maximumMatches = n3;
            this.hasMaximumMatches = this.maximumMatches > 0;
        }

        public boolean hasMaximumMatches() {
            return this.hasMaximumMatches;
        }

        public int getMaximumMatches() {
            return this.maximumMatches;
        }

        public void recordProcessed(int n) {
            if (this.currentRecordId == n) {
                return;
            }
            this.currentRecordId = n;
            ++this.recordsProcessed;
            if (!this.pageStarted) {
                boolean bl = this.pageStarted = this.recordsProcessed >= this.startRecord;
            }
            if (this.hasEnd && !this.pageEnded) {
                this.pageEnded = this.recordsProcessed >= this.finalRecord;
            }
        }

        public void matchProcessed() {
            ++this.matchesProcessed;
            if (this.hasMaximumMatches && this.matchesProcessed >= this.maximumMatches) {
                this.allMatchesProcessed = true;
                this.pageEnded = true;
            }
        }

        public boolean hasPageStarted() {
            return this.pageStarted;
        }

        public boolean hasPageEnded() {
            return this.pageEnded;
        }

        public boolean allMatchesProcessed() {
            return this.allMatchesProcessed;
        }
    }
}

