/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.tk.Toolkit;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.InputEvent;

public class GestureEvent
extends InputEvent {
    public static final EventType<GestureEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "GESTURE");
    private double x;
    private double y;
    private double screenX;
    private double screenY;
    private double sceneX;
    private double sceneY;
    private boolean shiftDown;
    private boolean controlDown;
    private boolean altDown;
    private boolean metaDown;
    private boolean direct;
    private boolean inertia;

    protected GestureEvent(EventType<? extends GestureEvent> eventType) {
        super((EventType<? extends InputEvent>)eventType);
    }

    protected GestureEvent(Object object, EventTarget eventTarget, EventType<? extends GestureEvent> eventType) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
    }

    GestureEvent(EventType<? extends GestureEvent> eventType, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super((EventType<? extends InputEvent>)eventType);
        this.x = d;
        this.y = d2;
        this.screenX = d3;
        this.screenY = d4;
        this.sceneX = d;
        this.sceneY = d2;
        this.shiftDown = bl;
        this.controlDown = bl2;
        this.altDown = bl3;
        this.metaDown = bl4;
        this.direct = bl5;
        this.inertia = bl6;
    }

    private void recomputeCoordinatesToSource(GestureEvent gestureEvent, Object object) {
        Point2D point2D = InputEventUtils.recomputeCoordinates(new Point2D(this.sceneX, this.sceneY), null, object);
        gestureEvent.x = point2D.getX();
        gestureEvent.y = point2D.getY();
    }

    @Override
    public Event copyFor(Object object, EventTarget eventTarget) {
        GestureEvent gestureEvent = (GestureEvent)super.copyFor(object, eventTarget);
        this.recomputeCoordinatesToSource(gestureEvent, object);
        return gestureEvent;
    }

    static void copyFields(GestureEvent gestureEvent, GestureEvent gestureEvent2, Object object, EventTarget eventTarget) {
        gestureEvent2.x = gestureEvent.x;
        gestureEvent2.y = gestureEvent.y;
        gestureEvent2.screenX = gestureEvent.screenX;
        gestureEvent2.screenY = gestureEvent.screenY;
        gestureEvent2.sceneX = gestureEvent.sceneX;
        gestureEvent2.sceneY = gestureEvent.sceneY;
        gestureEvent2.shiftDown = gestureEvent.shiftDown;
        gestureEvent2.controlDown = gestureEvent.controlDown;
        gestureEvent2.altDown = gestureEvent.altDown;
        gestureEvent2.metaDown = gestureEvent.metaDown;
        gestureEvent2.source = object;
        gestureEvent2.target = eventTarget;
        gestureEvent.recomputeCoordinatesToSource(gestureEvent2, object);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public final boolean isDirect() {
        return this.direct;
    }

    public boolean isInertia() {
        return this.inertia;
    }

    public final boolean isShortcutDown() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shiftDown;
            }
            case CONTROL: {
                return this.controlDown;
            }
            case ALT: {
                return this.altDown;
            }
            case META: {
                return this.metaDown;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GestureEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY());
        stringBuilder.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isShiftDown()) {
            stringBuilder.append(", shiftDown");
        }
        if (this.isControlDown()) {
            stringBuilder.append(", controlDown");
        }
        if (this.isAltDown()) {
            stringBuilder.append(", altDown");
        }
        if (this.isMetaDown()) {
            stringBuilder.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            stringBuilder.append(", shortcutDown");
        }
        return stringBuilder.append("]").toString();
    }
}

