/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.Truffle;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class TruffleLocator {
    static Set<ClassLoader> loaders() {
        TruffleLocator locator = Truffle.getRuntime().getCapability(TruffleLocator.class);
        Collection<Object> allLocators = locator != null ? Collections.singleton(locator) : Collections.emptyList();
        LinkedHashSet<ClassLoader> found = new LinkedHashSet<ClassLoader>();
        Response response = new Response(found);
        for (TruffleLocator truffleLocator : allLocators) {
            truffleLocator.locate(response);
        }
        found.add(ClassLoader.getSystemClassLoader());
        found.add(TruffleLocator.class.getClassLoader());
        return found;
    }

    static Class<?> loadClass(String name) {
        for (ClassLoader loader : TruffleLocator.loaders()) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    protected abstract void locate(Response var1);

    public static final class Response {
        private final Set<ClassLoader> loaders;

        Response(Set<ClassLoader> loaders) {
            this.loaders = loaders;
        }

        public void registerClassLoader(ClassLoader languageLoader) {
            this.loaders.add(languageLoader);
        }
    }
}

