/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.BoxedCheckNodeSubNodeGen;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.JavaObjectMessageResolution;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

abstract class BoxedCheckNodeSub
extends JavaObjectMessageResolution.BoxedCheckNode {
    BoxedCheckNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

    @Specialization
    protected Object accessWithTarget(JavaObject object) {
        return this.access(object);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new IS_BOXEDRootNode(language);
    }

    private static final class IS_BOXEDRootNode
    extends RootNode {
        @Node.Child
        private BoxedCheckNodeSub node = BoxedCheckNodeSubNodeGen.create();

        protected IS_BOXEDRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver(frame);
            try {
                return this.node.executeWithTarget(frame, receiver);
            }
            catch (UnsupportedSpecializationException e) {
                if (e.getNode() instanceof BoxedCheckNodeSub) {
                    throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                }
                throw e;
            }
        }
    }
}

