/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNodeGen;
import com.oracle.truffle.api.interop.java.TruffleList;
import com.oracle.truffle.api.interop.java.TruffleMap;
import com.oracle.truffle.api.interop.java.TypeAndClass;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;
import java.util.Map;

abstract class ToJavaNode
extends Node {
    @Node.Child
    private Node isExecutable = Message.IS_EXECUTABLE.createNode();

    ToJavaNode() {
    }

    public abstract Object execute(VirtualFrame var1, Object var2, TypeAndClass<?> var3);

    @Specialization(guards={"operand == null"})
    protected Object doNull(Object operand, TypeAndClass<?> type) {
        return null;
    }

    @Specialization(guards={"operand != null", "operand.getClass() == cachedOperandType", "targetType == cachedTargetType"})
    protected Object doCached(VirtualFrame frame, Object operand, TypeAndClass<?> targetType, @Cached(value="operand.getClass()") Class<?> cachedOperandType, @Cached(value="targetType") TypeAndClass<?> cachedTargetType) {
        return this.convertImpl(frame, cachedOperandType.cast(operand), cachedTargetType, cachedOperandType);
    }

    private Object convertImpl(VirtualFrame frame, Object value, TypeAndClass<?> targetType, Class<?> cachedOperandType) {
        Object convertedValue;
        if (ToJavaNode.isPrimitiveType(cachedOperandType)) {
            convertedValue = ToJavaNode.toPrimitive(value, targetType.clazz);
            assert (convertedValue != null);
        } else if (value instanceof JavaObject && targetType.clazz.isInstance(((JavaObject)value).obj)) {
            convertedValue = ((JavaObject)value).obj;
        } else if (!TruffleOptions.AOT && value instanceof TruffleObject && JavaInterop.isJavaFunctionInterface(targetType.clazz) && this.isExecutable(frame, (TruffleObject)value)) {
            convertedValue = JavaInteropReflect.asJavaFunction(targetType.clazz, (TruffleObject)value);
        } else {
            if (value == JavaObject.NULL) {
                return null;
            }
            if (value instanceof TruffleObject) {
                convertedValue = ToJavaNode.asJavaObject(targetType.clazz, targetType, (TruffleObject)value);
            } else {
                assert (targetType.clazz.isAssignableFrom(value.getClass()));
                convertedValue = value;
            }
        }
        return convertedValue;
    }

    @Specialization(guards={"operand != null"}, contains={"doCached"})
    protected Object doGeneric(VirtualFrame frame, Object operand, TypeAndClass<?> type) {
        return this.convertImpl(frame, operand, type, operand.getClass());
    }

    private static boolean isPrimitiveType(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class || CharSequence.class.isAssignableFrom(clazz);
    }

    private boolean isExecutable(VirtualFrame frame, TruffleObject object) {
        return ForeignAccess.sendIsExecutable(this.isExecutable, frame, object);
    }

    @CompilerDirectives.TruffleBoundary
    private static <T> T asJavaObject(Class<T> clazz, TypeAndClass<?> type, TruffleObject foreignObject) {
        Object obj;
        if (clazz.isInstance(foreignObject)) {
            obj = foreignObject;
        } else {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException();
            }
            if (foreignObject == null) {
                return null;
            }
            if (clazz == List.class && Boolean.TRUE.equals(ToJavaNode.binaryMessage(Message.HAS_SIZE, foreignObject, new Object[0]))) {
                TypeAndClass<?> elementType = type.getParameterType(0);
                obj = TruffleList.create(elementType, foreignObject);
            } else if (clazz == Map.class) {
                TypeAndClass<?> keyType = type.getParameterType(0);
                TypeAndClass<?> valueType = type.getParameterType(1);
                obj = TruffleMap.create(keyType, valueType, foreignObject);
            } else {
                obj = !TruffleOptions.AOT ? JavaInteropReflect.newProxyInstance(clazz, foreignObject) : foreignObject;
            }
        }
        return clazz.cast(obj);
    }

    static Object toJava(Object ret, TypeAndClass<?> type) {
        CompilerAsserts.neverPartOfCompilation();
        Class retType = type.clazz;
        Object primitiveRet = ToJavaNode.toPrimitive(ret, retType);
        if (primitiveRet != null) {
            return primitiveRet;
        }
        if (ret instanceof TruffleObject && Boolean.TRUE.equals(ToJavaNode.binaryMessage(Message.IS_NULL, ret, new Object[0]))) {
            return null;
        }
        if (retType.isInstance(ret)) {
            return ret;
        }
        if (ret instanceof TruffleObject) {
            TruffleObject truffleObject = (TruffleObject)ret;
            if (retType.isInterface()) {
                return ToJavaNode.asJavaObject(retType, type, truffleObject);
            }
        }
        return ret;
    }

    static boolean isPrimitive(Object attr) {
        return ToJavaNode.toPrimitive(attr, null) != null;
    }

    @CompilerDirectives.TruffleBoundary
    static Object toPrimitive(Object value, Class<?> requestedType) {
        Object attr;
        if (value instanceof TruffleObject) {
            if (!Boolean.TRUE.equals(ToJavaNode.binaryMessage(Message.IS_BOXED, value, new Object[0]))) {
                return null;
            }
            try {
                attr = ToJavaNode.message(null, Message.UNBOX, value, new Object[0]);
            }
            catch (InteropException e) {
                throw new IllegalStateException();
            }
        } else {
            attr = value;
        }
        if (attr instanceof Number) {
            if (requestedType == null) {
                return attr;
            }
            Number n = (Number)attr;
            if (requestedType == Byte.TYPE || requestedType == Byte.class) {
                return n.byteValue();
            }
            if (requestedType == Short.TYPE || requestedType == Short.class) {
                return n.shortValue();
            }
            if (requestedType == Integer.TYPE || requestedType == Integer.class) {
                return n.intValue();
            }
            if (requestedType == Long.TYPE || requestedType == Long.class) {
                return n.longValue();
            }
            if (requestedType == Float.TYPE || requestedType == Float.class) {
                return Float.valueOf(n.floatValue());
            }
            if (requestedType == Double.TYPE || requestedType == Double.class) {
                return n.doubleValue();
            }
            if (requestedType == Character.TYPE || requestedType == Character.class) {
                return Character.valueOf((char)n.intValue());
            }
            return n;
        }
        if (attr instanceof CharSequence) {
            if ((requestedType == Character.TYPE || requestedType == Character.class) && ((String)attr).length() == 1) {
                return Character.valueOf(((String)attr).charAt(0));
            }
            return String.valueOf(attr);
        }
        if (attr instanceof Character) {
            return attr;
        }
        if (attr instanceof Boolean) {
            return attr;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    static Object message(TypeAndClass<?> convertTo, Message m, Object receiver, Object ... arr) throws InteropException {
        Node n = m.createNode();
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new TemporaryRoot(TruffleLanguage.class, n, (TruffleObject)receiver, convertTo));
        return callTarget.call(arr);
    }

    private static Object binaryMessage(Message m, Object receiver, Object ... arr) {
        try {
            return ToJavaNode.message(null, m, receiver, arr);
        }
        catch (InteropException e) {
            throw new AssertionError((Object)e);
        }
    }

    static final class TemporaryRoot
    extends RootNode {
        @Node.Child
        private Node foreignAccess;
        @Node.Child
        private ToJavaNode toJava;
        private final TruffleObject function;
        private final TypeAndClass<?> type;

        TemporaryRoot(Class<? extends TruffleLanguage> lang, Node foreignAccess, TruffleObject function, TypeAndClass<?> type) {
            super(lang, null, null);
            this.foreignAccess = foreignAccess;
            this.function = function;
            this.type = type;
            this.toJava = type == null ? null : ToJavaNodeGen.create();
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object raw = ForeignAccess.execute(this.foreignAccess, frame, this.function, frame.getArguments());
            if (this.toJava == null) {
                return raw;
            }
            return this.toJava.execute(frame, raw, this.type);
        }
    }
}

