/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import java.util.concurrent.Executor;

abstract class ComputeInExecutor<R>
implements Runnable {
    private final Info executor;
    private R result;
    private Throwable exception;
    private boolean started;
    private boolean done;

    protected ComputeInExecutor(Info executor) {
        this.executor = executor;
    }

    protected abstract R compute();

    public final R get() {
        this.perform();
        if (this.executor != null) {
            this.waitForDone();
        }
        this.exceptionCheck();
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDone() {
        ComputeInExecutor computeInExecutor = this;
        synchronized (computeInExecutor) {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void exceptionCheck() throws RuntimeException {
        if (this.exception instanceof RuntimeException) {
            if (this.exception instanceof IllegalStateException) {
                throw new IllegalStateException(this.exception);
            }
            throw (RuntimeException)this.exception;
        }
        if (this.exception != null) {
            throw new RuntimeException(this.exception);
        }
    }

    public final void perform() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.executor == null) {
            this.run();
            this.exceptionCheck();
        } else {
            this.executor.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            if (this.executor != null) {
                this.executor.checkThread();
            }
            this.result = this.compute();
        }
        catch (Exception ex) {
            this.exception = ex.getClass() == RuntimeException.class && ex.getCause() != null ? ex.getCause() : ex;
        }
        finally {
            if (this.executor != null) {
                ComputeInExecutor computeInExecutor = this;
                synchronized (computeInExecutor) {
                    this.done = true;
                    this.notifyAll();
                }
            } else {
                this.done = true;
            }
        }
    }

    public final String toString() {
        return "value=" + this.result + ",exception=" + this.exception + ",computed=" + this.done;
    }

    public static Info wrap(Executor executor) {
        return executor == null ? null : new Info(executor);
    }

    static final class Info {
        private final Executor executor;
        private Thread runThread;

        private Info(Executor executor) {
            this.executor = executor;
        }

        void execute(ComputeInExecutor<?> compute) {
            this.executor.execute(compute);
        }

        private synchronized void checkThread() {
            if (this.runThread == null) {
                this.runThread = Thread.currentThread();
            } else if (this.runThread != Thread.currentThread()) {
                throw new IllegalStateException("Currently executing in " + Thread.currentThread() + " while previously running in " + this.runThread + " that isn't allowed");
            }
        }
    }
}

