/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.vm.ModuleResourceLocator;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

final class LanguageCache {
    private static final boolean PRELOAD;
    private static final Map<String, LanguageCache> CACHE;
    private static Map<String, LanguageCache> cache;
    static final Collection<ClassLoader> AOT_LOADERS;
    private final TruffleLanguage<?> language;
    private final String className;
    private final Set<String> mimeTypes;
    private final String name;
    private final String version;
    private final ClassLoader loader;

    private static Map<String, LanguageCache> initializeLanguages(ClassLoader loader) {
        Map<String, LanguageCache> map = LanguageCache.createLanguages(loader);
        for (LanguageCache info : map.values()) {
            info.createLanguage();
        }
        return map;
    }

    private LanguageCache(String prefix, Properties info, TruffleLanguage<?> language, ClassLoader loader) {
        String mt;
        this.loader = loader;
        this.className = info.getProperty(prefix + "className");
        this.name = info.getProperty(prefix + "name");
        this.version = info.getProperty(prefix + "version");
        TreeSet<String> ts = new TreeSet<String>();
        int i = 0;
        while ((mt = info.getProperty(prefix + "mimeType." + i)) != null) {
            ts.add(mt);
            ++i;
        }
        this.mimeTypes = Collections.unmodifiableSet(ts);
        this.language = language;
    }

    private static ClassLoader loader() {
        ClassLoader l;
        if (PolyglotEngine.JDK8OrEarlier) {
            l = PolyglotEngine.class.getClassLoader();
            if (l == null) {
                l = ClassLoader.getSystemClassLoader();
            }
        } else {
            l = ModuleResourceLocator.createLoader();
        }
        return l;
    }

    static Map<String, LanguageCache> languages() {
        if (PRELOAD) {
            return CACHE;
        }
        if (cache != null) {
            return cache;
        }
        cache = LanguageCache.createLanguages(null);
        return cache;
    }

    private static Map<String, LanguageCache> createLanguages(ClassLoader additionalLoader) {
        LinkedHashMap<String, LanguageCache> map = new LinkedHashMap<String, LanguageCache>();
        for (ClassLoader loader : AOT_LOADERS == null ? PolyglotEngine.Access.loaders() : AOT_LOADERS) {
            LanguageCache.createLanguages(loader, map);
        }
        if (additionalLoader != null) {
            LanguageCache.createLanguages(additionalLoader, map);
        }
        return map;
    }

    private static void createLanguages(ClassLoader loader, Map<String, LanguageCache> map) {
        Enumeration<URL> en;
        if (loader == null) {
            return;
        }
        try {
            en = loader.getResources("META-INF/truffle/language");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read list of Truffle languages", ex);
        }
        while (en.hasMoreElements()) {
            String prefix;
            String name;
            Properties p;
            URL u = en.nextElement();
            try {
                p = new Properties();
                try (InputStream is = u.openStream();){
                    p.load(is);
                }
            }
            catch (IOException ex) {
                PolyglotEngine.LOG.log(Level.CONFIG, "Cannot process " + u + " as language definition", ex);
                continue;
            }
            int cnt = 1;
            while ((name = p.getProperty((prefix = "language" + cnt + ".") + "name")) != null) {
                TruffleLanguage<?> lang = null;
                if (PRELOAD) {
                    String className = p.getProperty(prefix + "className");
                    lang = LanguageCache.loadLanguage(name, className, loader);
                }
                LanguageCache l = new LanguageCache(prefix, p, lang, loader);
                for (String mimeType : l.getMimeTypes()) {
                    map.put(mimeType, l);
                }
                ++cnt;
            }
        }
    }

    Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    String getName() {
        return this.name;
    }

    String getVersion() {
        return this.version;
    }

    String getClassName() {
        return this.className;
    }

    TruffleLanguage<?> loadLanguage() {
        if (PRELOAD) {
            return this.language;
        }
        return LanguageCache.loadLanguage(this.name, this.className, this.loader);
    }

    private static TruffleLanguage<?> loadLanguage(String name, String className, ClassLoader loader) {
        try {
            Class<?> langClazz = Class.forName(className, true, loader);
            return (TruffleLanguage)langClazz.getField("INSTANCE").get(null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot initialize " + name + " language with implementation " + className, ex);
        }
    }

    private TruffleLanguage<?> createLanguage() {
        return LanguageCache.loadLanguage(this.name, this.className, this.loader);
    }

    static {
        AOT_LOADERS = TruffleOptions.AOT ? PolyglotEngine.Access.loaders() : null;
        CACHE = TruffleOptions.AOT ? LanguageCache.initializeLanguages(LanguageCache.loader()) : null;
        PRELOAD = CACHE != null;
    }
}

