/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Log {
    public static final Level PERFORMANCE = new RubyLevel("PERFORMANCE", Level.WARNING);
    public static final Logger LOGGER = Log.createLogger();
    private static final Set<String> displayedWarnings = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final String KWARGS_NOT_OPTIMIZED_YET = "keyword arguments are not yet optimized";

    private static Logger createLogger() {
        Logger logger = Logger.getLogger("org.jruby.truffle");
        if (LogManager.getLogManager().getProperty("org.jruby.truffle.handlers") == null) {
            logger.setUseParentHandlers(false);
            logger.addHandler(new RubyHandler());
        }
        return logger;
    }

    public static void notOptimizedOnce(String message) {
        if (CompilerDirectives.inCompiledCode()) {
            Log.performanceOnce(message);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void performanceOnce(String message) {
        if (displayedWarnings.add(message)) {
            LOGGER.log(PERFORMANCE, message);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void info(String format, Object ... args) {
        LOGGER.info(String.format(format, args));
    }

    public static class RubyHandler
    extends Handler {
        @Override
        public void publish(LogRecord record) {
            System.err.printf("[ruby] %s %s%n", record.getLevel().getName(), record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static class RubyLevel
    extends Level {
        private static final long serialVersionUID = 3759389129096588683L;

        public RubyLevel(String name, Level parent) {
            super(name, parent.intValue(), parent.getResourceBundleName());
        }
    }
}

