/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.cast.ToEncodingNode;
import org.jruby.truffle.core.encoding.EncodingNodesFactory;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;

@CoreClass(value="Encoding")
public abstract class EncodingNodes {

    @NodeChildren(value={@NodeChild(value="first"), @NodeChild(value="second")})
    public static abstract class CheckEncodingNode
    extends RubyNode {
        @Node.Child
        private NegotiateCompatibleEncodingNode negotiateCompatibleEncodingNode = EncodingNodesFactory.NegotiateCompatibleEncodingNodeGen.create(null, null);
        @Node.Child
        private ToEncodingNode toEncodingNode;

        public static CheckEncodingNode create() {
            return EncodingNodesFactory.CheckEncodingNodeGen.create(null, null);
        }

        public abstract Encoding executeCheckEncoding(Object var1, Object var2);

        @Specialization
        public Encoding checkEncoding(Object first, Object second, @Cached(value="create()") BranchProfile errorProfile) {
            Encoding negotiatedEncoding = this.negotiateCompatibleEncodingNode.executeNegotiate(first, second);
            if (negotiatedEncoding == null) {
                errorProfile.enter();
                if (this.toEncodingNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.toEncodingNode = this.insert(ToEncodingNode.create());
                }
                throw new RaiseException(this.getContext().getCoreExceptions().encodingCompatibilityErrorIncompatible(this.toEncodingNode.executeToEncoding(first), this.toEncodingNode.executeToEncoding(second), this));
            }
            return negotiatedEncoding;
        }
    }

    @Primitive(name="encoding_get_encoding_by_index", needsSelf=false)
    public static abstract class GetEncodingObjectByIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject getEncoding(int index) {
            return this.getContext().getEncodingManager().getRubyEncoding(index);
        }
    }

    @Primitive(name="encoding_replicate")
    public static abstract class EncodingReplicateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(nameObject)"})
        public DynamicObject encodingReplicate(VirtualFrame frame, DynamicObject self, DynamicObject nameObject, @Cached(value="new()") SnippetNode snippetNode) {
            String name = StringOperations.getString(nameObject);
            Encoding encoding = EncodingOperations.getEncoding(self);
            DynamicObject newEncoding = this.getContext().getEncodingManager().replicateEncoding(encoding, name);
            if (newEncoding == null) {
                throw new RaiseException(this.coreExceptions().argumentErrorEncodingAlreadyRegistered(name, this));
            }
            EncodingDB.Entry entry = EncodingDB.getEncodings().get(name.getBytes());
            snippetNode.execute(frame, "Encoding::EncodingMap[enc.name.upcase.to_sym] = [nil, index]", "enc", newEncoding, "index", entry.getIndex());
            return newEncoding;
        }
    }

    @Primitive(name="encoding_get_object_encoding", needsSelf=false)
    public static abstract class EncodingGetObjectEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private GetRubyEncodingNode getRubyEncodingNode = EncodingNodesFactory.GetRubyEncodingNodeGen.create();

        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject encodingGetObjectEncodingString(DynamicObject string) {
            return this.getRubyEncodingNode.executeGetRubyEncoding(Layouts.STRING.getRope(string).getEncoding());
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public DynamicObject encodingGetObjectEncodingSymbol(DynamicObject symbol) {
            return this.getRubyEncodingNode.executeGetRubyEncoding(Layouts.SYMBOL.getRope(symbol).getEncoding());
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject encodingGetObjectEncoding(DynamicObject encoding) {
            return encoding;
        }

        @Specialization(guards={"isRubyRegexp(regexp)"})
        public DynamicObject encodingGetObjectEncodingRegexp(DynamicObject regexp) {
            return this.getRubyEncodingNode.executeGetRubyEncoding(Layouts.REGEXP.getSource(regexp).getEncoding());
        }

        @Specialization(guards={"!isRubyString(object)", "!isRubySymbol(object)", "!isRubyEncoding(object)", "!isRubyRegexp(object)"})
        public DynamicObject encodingGetObjectEncodingNil(DynamicObject object) {
            return this.nil();
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"name", "to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toS(DynamicObject encoding) {
            return Layouts.ENCODING.getName(encoding);
        }
    }

    @CoreMethod(names={"dummy?"})
    public static abstract class DummyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"encoding == cachedEncoding"}, limit="getCacheLimit()")
        public boolean isDummyCached(DynamicObject encoding, @Cached(value="encoding") DynamicObject cachedEncoding, @Cached(value="isDummy(cachedEncoding)") boolean isDummy) {
            return isDummy;
        }

        @Specialization(contains={"isDummyCached"})
        public boolean isDummyUncached(DynamicObject encoding) {
            return DummyNode.isDummy(encoding);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_LOADED_CLASSES_CACHE;
        }

        protected static boolean isDummy(DynamicObject encoding) {
            assert (RubyGuards.isRubyEncoding(encoding));
            return Layouts.ENCODING.getDummy(encoding);
        }
    }

    @CoreMethod(names={"locale_charmap"}, onSingleton=true)
    public static abstract class LocaleCharacterMapNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject localeCharacterMap(@Cached(value="create()") GetRubyEncodingNode getRubyEncodingNode) {
            DynamicObject rubyEncoding = getRubyEncodingNode.executeGetRubyEncoding(this.getContext().getEncodingManager().getLocaleEncoding());
            return Layouts.ENCODING.getName(rubyEncoding);
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject list() {
            Object[] encodingsList = this.getContext().getEncodingManager().getEncodingList();
            return this.createArray(encodingsList, encodingsList.length);
        }
    }

    @CoreMethod(names={"compatible?"}, onSingleton=true, required=2)
    public static abstract class CompatibleQueryNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GetRubyEncodingNode getRubyEncodingNode = EncodingNodesFactory.GetRubyEncodingNodeGen.create();
        @Node.Child
        private NegotiateCompatibleEncodingNode negotiateCompatibleEncodingNode = NegotiateCompatibleEncodingNode.create();

        public abstract DynamicObject executeCompatibleQuery(Object var1, Object var2);

        @Specialization
        protected DynamicObject isCompatible(Object first, Object second, @Cached(value="createBinaryProfile()") ConditionProfile noNegotiatedEncodingProfile) {
            Encoding negotiatedEncoding = this.negotiateCompatibleEncodingNode.executeNegotiate(first, second);
            if (noNegotiatedEncodingProfile.profile(negotiatedEncoding == null)) {
                return this.nil();
            }
            return this.getRubyEncodingNode.executeGetRubyEncoding(negotiatedEncoding);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_COMPATIBLE_QUERY_CACHE;
        }
    }

    @NodeChildren(value={@NodeChild(value="first"), @NodeChild(value="second")})
    public static abstract class NegotiateCompatibleEncodingNode
    extends RubyNode {
        @Node.Child
        private ToEncodingNode getEncodingNode = ToEncodingNode.create();

        public static NegotiateCompatibleEncodingNode create() {
            return EncodingNodesFactory.NegotiateCompatibleEncodingNodeGen.create(null, null);
        }

        public abstract Encoding executeNegotiate(Object var1, Object var2);

        @Specialization(guards={"getEncoding(first) == getEncoding(second)", "getEncoding(first) == cachedEncoding"}, limit="getCacheLimit()")
        protected Encoding negotiateSameEncodingCached(DynamicObject first, DynamicObject second, @Cached(value="getEncoding(first)") Encoding cachedEncoding) {
            return cachedEncoding;
        }

        @Specialization(guards={"getEncoding(first) == getEncoding(second)"}, contains={"negotiateSameEncodingCached"})
        protected Encoding negotiateSameEncodingUncached(Object first, Object second) {
            return this.getEncoding(first);
        }

        @Specialization(guards={"firstEncoding != secondEncoding", "isRubyString(first)", "isRubyString(second)", "isEmpty(first) == isFirstEmpty", "isEmpty(second) == isSecondEmpty", "getCodeRange(first) == firstCodeRange", "getCodeRange(second) == secondCodeRange", "getEncoding(first) == firstEncoding", "getEncoding(second) == secondEncoding"}, limit="getCacheLimit()")
        protected Encoding negotiateStringStringCached(DynamicObject first, DynamicObject second, @Cached(value="getEncoding(first)") Encoding firstEncoding, @Cached(value="getEncoding(second)") Encoding secondEncoding, @Cached(value="isEmpty(first)") boolean isFirstEmpty, @Cached(value="isEmpty(second)") boolean isSecondEmpty, @Cached(value="getCodeRange(first)") CodeRange firstCodeRange, @Cached(value="getCodeRange(second)") CodeRange secondCodeRange, @Cached(value="negotiateStringStringUncached(first, second)") Encoding negotiatedEncoding) {
            return negotiatedEncoding;
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "isRubyString(first)", "isRubyString(second)"}, contains={"negotiateStringStringCached"})
        protected Encoding negotiateStringStringUncached(DynamicObject first, DynamicObject second) {
            return NegotiateCompatibleEncodingNode.compatibleEncodingForStrings(first, second);
        }

        @Specialization(guards={"isRubyString(first)", "!isRubyString(second)", "getCodeRange(first) == codeRange", "getEncoding(first) == firstEncoding", "getEncoding(second) == secondEncoding", "firstEncoding != secondEncoding"}, limit="getCacheLimit()")
        protected Encoding negotiateStringObjectCached(DynamicObject first, Object second, @Cached(value="getEncoding(first)") Encoding firstEncoding, @Cached(value="getEncoding(second)") Encoding secondEncoding, @Cached(value="getCodeRange(first)") CodeRange codeRange, @Cached(value="negotiateStringObjectUncached(first, second)") Encoding negotiatedEncoding) {
            return negotiatedEncoding;
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "isRubyString(first)", "!isRubyString(second)"}, contains={"negotiateStringObjectCached"})
        protected Encoding negotiateStringObjectUncached(DynamicObject first, Object second) {
            Encoding firstEncoding = this.getEncoding(first);
            Encoding secondEncoding = this.getEncoding(second);
            if (secondEncoding == null) {
                return null;
            }
            if (!firstEncoding.isAsciiCompatible() || !secondEncoding.isAsciiCompatible()) {
                return null;
            }
            if (secondEncoding == USASCIIEncoding.INSTANCE) {
                return firstEncoding;
            }
            if (this.getCodeRange(first) == CodeRange.CR_7BIT) {
                return secondEncoding;
            }
            return null;
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "!isRubyString(first)", "isRubyString(second)"})
        protected Encoding negotiateObjectString(Object first, DynamicObject second) {
            return this.negotiateStringObjectUncached(second, first);
        }

        @Specialization(guards={"firstEncoding != secondEncoding", "!isRubyString(first)", "!isRubyString(second)", "firstEncoding != null", "secondEncoding != null", "getEncoding(first) == firstEncoding", "getEncoding(second) == secondEncoding"}, limit="getCacheLimit()")
        protected Encoding negotiateObjectObjectCached(Object first, Object second, @Cached(value="getEncoding(first)") Encoding firstEncoding, @Cached(value="getEncoding(second)") Encoding secondEncoding, @Cached(value="areCompatible(firstEncoding, secondEncoding)") Encoding negotiatedEncoding) {
            return negotiatedEncoding;
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "!isRubyString(first)", "!isRubyString(second)"}, contains={"negotiateObjectObjectCached"})
        protected Encoding negotiateObjectObjectUncached(Object first, Object second) {
            Encoding firstEncoding = this.getEncoding(first);
            Encoding secondEncoding = this.getEncoding(second);
            return NegotiateCompatibleEncodingNode.areCompatible(firstEncoding, secondEncoding);
        }

        private static Encoding compatibleEncodingForStrings(DynamicObject first, DynamicObject second) {
            assert (RubyGuards.isRubyString(first));
            assert (RubyGuards.isRubyString(second));
            Rope firstRope = StringOperations.rope(first);
            Rope secondRope = StringOperations.rope(second);
            return NegotiateCompatibleEncodingNode.compatibleEncodingForRopes(firstRope, secondRope);
        }

        @CompilerDirectives.TruffleBoundary
        private static Encoding compatibleEncodingForRopes(Rope firstRope, Rope secondRope) {
            Encoding firstEncoding = firstRope.getEncoding();
            Encoding secondEncoding = secondRope.getEncoding();
            if (secondRope.isEmpty()) {
                return firstEncoding;
            }
            if (firstRope.isEmpty()) {
                return firstEncoding.isAsciiCompatible() && secondRope.getCodeRange() == CodeRange.CR_7BIT ? firstEncoding : secondEncoding;
            }
            if (!firstEncoding.isAsciiCompatible() || !secondEncoding.isAsciiCompatible()) {
                return null;
            }
            if (firstRope.getCodeRange() != secondRope.getCodeRange()) {
                if (firstRope.getCodeRange() == CodeRange.CR_7BIT) {
                    return secondEncoding;
                }
                if (secondRope.getCodeRange() == CodeRange.CR_7BIT) {
                    return firstEncoding;
                }
            }
            if (secondRope.getCodeRange() == CodeRange.CR_7BIT) {
                return firstEncoding;
            }
            if (firstRope.getCodeRange() == CodeRange.CR_7BIT) {
                return secondEncoding;
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        protected static Encoding areCompatible(Encoding enc1, Encoding enc2) {
            assert (enc1 != enc2);
            if (enc1 == null || enc2 == null) {
                return null;
            }
            if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
                return null;
            }
            if (enc2 instanceof USASCIIEncoding) {
                return enc1;
            }
            if (enc1 instanceof USASCIIEncoding) {
                return enc2;
            }
            return null;
        }

        protected boolean isEmpty(Object string) {
            if (RubyGuards.isRubyString(string)) {
                return StringOperations.rope((DynamicObject)string).isEmpty();
            }
            return false;
        }

        protected CodeRange getCodeRange(Object string) {
            if (RubyGuards.isRubyString(string)) {
                return StringOperations.rope((DynamicObject)string).getCodeRange();
            }
            return CodeRange.CR_UNKNOWN;
        }

        protected Encoding getEncoding(Object value) {
            return this.getEncodingNode.executeToEncoding(value);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_COMPATIBLE_QUERY_CACHE;
        }
    }

    @NodeChild(value="encoding")
    public static abstract class GetRubyEncodingNode
    extends RubyNode {
        public static GetRubyEncodingNode create() {
            return EncodingNodesFactory.GetRubyEncodingNodeGen.create(null);
        }

        public abstract DynamicObject executeGetRubyEncoding(Encoding var1);

        @Specialization(guards={"isSameEncoding(encoding, cachedRubyEncoding)"}, limit="getCacheLimit()")
        protected DynamicObject getRubyEncodingCached(Encoding encoding, @Cached(value="getRubyEncodingUncached(encoding)") DynamicObject cachedRubyEncoding) {
            return cachedRubyEncoding;
        }

        @Specialization(contains={"getRubyEncodingCached"})
        protected DynamicObject getRubyEncodingUncached(Encoding encoding) {
            if (encoding == null) {
                throw new UnsupportedOperationException("cannot convert null Java encoding to a Ruby encoding");
            }
            return this.getContext().getEncodingManager().getRubyEncoding(encoding);
        }

        protected boolean isSameEncoding(Encoding encoding, DynamicObject rubyEncoding) {
            return encoding == Layouts.ENCODING.getEncoding(rubyEncoding);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_LOADED_CLASSES_CACHE;
        }
    }

    @CoreMethod(names={"ascii_compatible?"})
    public static abstract class AsciiCompatibleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"encoding == cachedEncoding"}, limit="getCacheLimit()")
        public boolean isAsciiCompatibleCached(DynamicObject encoding, @Cached(value="encoding") DynamicObject cachedEncoding, @Cached(value="isAsciiCompatible(cachedEncoding)") boolean isAsciiCompatible) {
            return isAsciiCompatible;
        }

        @Specialization(contains={"isAsciiCompatibleCached"})
        public boolean isAsciiCompatibleUncached(DynamicObject encoding) {
            return AsciiCompatibleNode.isAsciiCompatible(encoding);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_LOADED_CLASSES_CACHE;
        }

        protected static boolean isAsciiCompatible(DynamicObject encoding) {
            assert (RubyGuards.isRubyEncoding(encoding));
            return EncodingOperations.getEncoding(encoding).isAsciiCompatible();
        }
    }
}

