/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.exception;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@CoreClass(value="SystemCallError")
public abstract class SystemCallErrorNodes {

    @Primitive(name="exception_set_errno")
    public static abstract class ErrnoSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object setErrno(DynamicObject error, Object errno) {
            Layouts.SYSTEM_CALL_ERROR.setErrno(error, errno);
            return errno;
        }
    }

    @CoreMethod(names={"errno"})
    public static abstract class ErrnoNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object errno(DynamicObject self) {
            return Layouts.SYSTEM_CALL_ERROR.getErrno(self);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocateNameError(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, this.nil(), null, this.nil());
        }
    }
}

