/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import org.jruby.truffle.core.hash.BucketsStrategy;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.core.hash.KeyValue;
import org.jruby.truffle.language.RubyNode;

public class ConcatHashLiteralNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;

    public ConcatHashLiteralNode(RubyNode[] children) {
        this.children = children;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.buildHash(this.executeChildren(frame));
    }

    @CompilerDirectives.TruffleBoundary
    private Object buildHash(DynamicObject[] parts) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (int i = 0; i < parts.length; ++i) {
            for (KeyValue keyValue : HashOperations.iterableKeyValues(parts[i])) {
                keyValues.add(keyValue);
            }
        }
        return BucketsStrategy.create(this.getContext(), keyValues, false);
    }

    @ExplodeLoop
    protected DynamicObject[] executeChildren(VirtualFrame frame) {
        DynamicObject[] values = new DynamicObject[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            try {
                DynamicObject hash;
                values[i] = hash = this.children[i].executeDynamicObject(frame);
                continue;
            }
            catch (UnexpectedResultException e) {
                throw new UnsupportedOperationException(this.children[i].getClass() + " " + e.getResult().getClass());
            }
        }
        return values;
    }
}

