/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.hash.BucketsStrategy;
import org.jruby.truffle.core.hash.CompareHashKeysNode;
import org.jruby.truffle.core.hash.Entry;
import org.jruby.truffle.core.hash.HashLookupResult;
import org.jruby.truffle.core.hash.HashNode;
import org.jruby.truffle.language.RubyBaseNode;

public class LookupEntryNode
extends RubyBaseNode {
    @Node.Child
    HashNode hashNode = new HashNode();
    @Node.Child
    CompareHashKeysNode compareHashKeysNode = new CompareHashKeysNode();
    private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();

    public HashLookupResult lookup(VirtualFrame frame, DynamicObject hash, Object key) {
        boolean compareByIdentity = this.byIdentityProfile.profile(Layouts.HASH.getCompareByIdentity(hash));
        int hashed = this.hashNode.hash(frame, key, compareByIdentity);
        Entry[] entries = (Entry[])Layouts.HASH.getStore(hash);
        int index = BucketsStrategy.getBucketIndex(hashed, entries.length);
        Entry previousEntry = null;
        for (Entry entry = entries[index]; entry != null; entry = entry.getNextInLookup()) {
            if (this.equalKeys(frame, compareByIdentity, key, hashed, entry.getKey(), entry.getHashed())) {
                return new HashLookupResult(hashed, index, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashLookupResult(hashed, index, previousEntry, null);
    }

    protected boolean equalKeys(VirtualFrame frame, boolean compareByIdentity, Object key, int hashed, Object otherKey, int otherHashed) {
        return this.compareHashKeysNode.equalKeys(frame, compareByIdentity, key, hashed, otherKey, otherHashed);
    }
}

