/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.objects.PropertyFlags;
import org.jruby.truffle.language.objects.ShapeCachingGuards;

@ImportStatic(value={RubyGuards.class, ShapeCachingGuards.class})
public abstract class ReadObjectFieldNode
extends RubyBaseNode {
    private final Object defaultValue;
    protected final Object name;

    public ReadObjectFieldNode(Object name, Object defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public Object getName() {
        return this.name;
    }

    public abstract Object execute(DynamicObject var1);

    @Specialization(guards={"receiver.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()")
    protected Object readObjectFieldCached(DynamicObject receiver, @Cached(value="receiver.getShape()") Shape cachedShape, @Cached(value="getProperty(cachedShape, name)") Property property) {
        if (property != null) {
            return property.get(receiver, cachedShape);
        }
        return this.defaultValue;
    }

    @Specialization(guards={"updateShape(object)"})
    public Object updateShapeAndRead(DynamicObject object) {
        return this.execute(object);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"readObjectFieldCached", "updateShapeAndRead"})
    protected Object readObjectFieldUncached(DynamicObject receiver) {
        return receiver.get(this.name, this.defaultValue);
    }

    protected Property getProperty(Shape shape, Object name) {
        Property property = shape.getProperty(name);
        if (!PropertyFlags.isDefined(property)) {
            return null;
        }
        return property;
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().INSTANCE_VARIABLE_CACHE;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }
}

