/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects.shared;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.collections.BoundaryIterable;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.queue.LinkedBlockingQueueLocksConditions;
import org.jruby.truffle.language.objects.ShapeCachingGuards;
import org.jruby.truffle.language.objects.shared.SharedObjects;
import org.jruby.truffle.language.objects.shared.WriteBarrierNode;
import org.jruby.truffle.language.objects.shared.WriteBarrierNodeGen;

@ImportStatic(value={ShapeCachingGuards.class, ArrayGuards.class})
public abstract class ShareInternalFieldsNode
extends Node {
    protected static final int CACHE_LIMIT = 8;
    protected final int depth;

    public ShareInternalFieldsNode(int depth) {
        this.depth = depth;
    }

    public abstract void executeShare(DynamicObject var1);

    @Specialization(guards={"array.getShape() == cachedShape", "isArrayShape(cachedShape)", "isObjectArray(array)"}, assumptions={"cachedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    protected void shareCachedObjectArray(DynamicObject array, @Cached(value="array.getShape()") Shape cachedShape, @Cached(value="createWriteBarrierNode()") WriteBarrierNode writeBarrierNode) {
        int size = Layouts.ARRAY.getSize(array);
        Object[] store = (Object[])Layouts.ARRAY.getStore(array);
        for (int i = 0; i < size; ++i) {
            writeBarrierNode.executeWriteBarrier(store[i]);
        }
    }

    @Specialization(guards={"array.getShape() == cachedShape", "isArrayShape(cachedShape)", "!isObjectArray(array)"}, assumptions={"cachedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    protected void shareCachedOtherArray(DynamicObject array, @Cached(value="array.getShape()") Shape cachedShape) {
    }

    @Specialization(guards={"object.getShape() == cachedShape", "isQueueShape(cachedShape)"}, assumptions={"cachedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    protected void shareCachedQueue(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="createBinaryProfile()") ConditionProfile profileEmpty, @Cached(value="createWriteBarrierNode()") WriteBarrierNode writeBarrierNode) {
        LinkedBlockingQueueLocksConditions<Object> queue = Layouts.QUEUE.getQueue(object);
        if (!profileEmpty.profile(queue.size() == 0)) {
            for (Object e : BoundaryIterable.wrap(queue)) {
                writeBarrierNode.executeWriteBarrier(e);
            }
        }
    }

    @Specialization(guards={"object.getShape() == cachedShape", "isBasicObjectShape(cachedShape)"}, assumptions={"cachedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    protected void shareCachedBasicObject(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape) {
    }

    @Specialization(guards={"updateShape(object)"})
    public void updateShapeAndShare(DynamicObject object) {
        this.executeShare(object);
    }

    @Specialization(contains={"shareCachedObjectArray", "shareCachedOtherArray", "shareCachedQueue", "shareCachedBasicObject", "updateShapeAndShare"})
    protected void shareUncached(DynamicObject object) {
        SharedObjects.writeBarrier(object);
    }

    protected WriteBarrierNode createWriteBarrierNode() {
        return WriteBarrierNodeGen.create(this.depth);
    }
}

