/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects.shared;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.objects.ShapeCachingGuards;
import org.jruby.truffle.language.objects.shared.ReadAndShareFieldNode;
import org.jruby.truffle.language.objects.shared.ReadAndShareFieldNodeGen;
import org.jruby.truffle.language.objects.shared.ShareInternalFieldsNode;
import org.jruby.truffle.language.objects.shared.ShareInternalFieldsNodeGen;
import org.jruby.truffle.language.objects.shared.SharedObjects;

@ImportStatic(value={ShapeCachingGuards.class})
public abstract class ShareObjectNode
extends Node {
    protected static final int CACHE_LIMIT = 8;
    protected final int depth;
    private static final Object SOME_OBJECT = new Object();

    public ShareObjectNode(int depth) {
        this.depth = depth;
    }

    public abstract void executeShare(DynamicObject var1);

    @Specialization(guards={"object.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    @ExplodeLoop
    protected void shareCached(DynamicObject object, @Cached(value="ensureSharedClasses(object.getShape())") Shape cachedShape, @Cached(value="createShareInternalFieldsNode()") ShareInternalFieldsNode shareInternalFieldsNode, @Cached(value="createReadAndShareFieldNodes(getObjectProperties(cachedShape))") ReadAndShareFieldNode[] readAndShareFieldNodes, @Cached(value="createSharedShape(object)") Shape sharedShape) {
        assert (!SharedObjects.isShared(cachedShape));
        object.setShapeAndGrow(cachedShape, sharedShape);
        shareInternalFieldsNode.executeShare(object);
        for (ReadAndShareFieldNode readAndShareFieldNode : readAndShareFieldNodes) {
            readAndShareFieldNode.executeReadFieldAndShare(object);
        }
    }

    @Specialization(guards={"updateShape(object)"})
    public void updateShapeAndShare(DynamicObject object) {
        this.executeShare(object);
    }

    @Specialization(contains={"shareCached", "updateShapeAndShare"})
    protected void shareUncached(DynamicObject object) {
        SharedObjects.writeBarrier(object);
    }

    protected static Shape ensureSharedClasses(Shape shape) {
        ObjectType objectType = shape.getObjectType();
        SharedObjects.writeBarrier(Layouts.BASIC_OBJECT.getLogicalClass(objectType));
        SharedObjects.writeBarrier(Layouts.BASIC_OBJECT.getMetaClass(objectType));
        return shape;
    }

    protected static List<Property> getObjectProperties(Shape shape) {
        ArrayList<Property> objectProperties = new ArrayList<Property>();
        for (Property property : shape.getProperties()) {
            if (!property.getLocation().canStore(SOME_OBJECT)) continue;
            objectProperties.add(property);
        }
        return objectProperties;
    }

    protected ShareInternalFieldsNode createShareInternalFieldsNode() {
        return ShareInternalFieldsNodeGen.create(this.depth);
    }

    protected ReadAndShareFieldNode[] createReadAndShareFieldNodes(List<Property> properties) {
        ReadAndShareFieldNode[] nodes = new ReadAndShareFieldNode[properties.size()];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = ReadAndShareFieldNodeGen.create(properties.get(i), this.depth);
        }
        return nodes;
    }

    protected static Shape createSharedShape(DynamicObject object) {
        object.updateShape();
        Shape oldShape = object.getShape();
        return oldShape.makeSharedShape();
    }
}

