/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import org.jruby.truffle.options.OptionDescription;
import org.jruby.truffle.options.OptionTypeException;

public class BooleanOptionDescription
extends OptionDescription {
    private final boolean defaultValue;

    public BooleanOptionDescription(String name, String description, boolean defaultValue) {
        super(name, description);
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object checkValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String) {
            switch ((String)value) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new OptionTypeException(this.getName(), value.toString());
        }
        throw new OptionTypeException(this.getName(), value.toString());
    }
}

