/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import com.oracle.truffle.api.CompilerDirectives;
import org.jruby.truffle.options.OptionDescription;
import org.jruby.truffle.options.OptionsBuilder;
import org.jruby.truffle.options.OptionsCatalog;
import org.jruby.truffle.options.Verbosity;

public class Options {
    public final String HOME;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final String[] LOAD_PATHS;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final String[] REQUIRED_LIBRARIES;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] INLINE_SCRIPT;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final String[] ARGUMENTS;
    public final String DISPLAYED_FILE_NAME;
    public final boolean DEBUG;
    public final Verbosity VERBOSITY;
    public final boolean FROZEN_STRING_LITERALS;
    public final boolean DISABLE_GEMS;
    public final String INTERNAL_ENCODING;
    public final String EXTERNAL_ENCODING;
    public final boolean PLATFORM_SAFE;
    public final boolean PLATFORM_SAFE_LOAD;
    public final boolean PLATFORM_SAFE_IO;
    public final boolean PLATFORM_SAFE_MEMORY;
    public final boolean PLATFORM_SAFE_THREADS;
    public final boolean PLATFORM_SAFE_PROCESSES;
    public final boolean PLATFORM_SAFE_SIGNALS;
    public final boolean PLATFORM_SAFE_EXIT;
    public final boolean PLATFORM_SAFE_AT_EXIT;
    public final boolean PLATFORM_SAFE_PUTS;
    public final boolean PLATFORM_USE_JAVA;
    public final boolean TRACE_CALLS;
    public final boolean COVERAGE_GLOBAL;
    public final boolean INLINE_JS;
    public final String CORE_LOAD_PATH;
    public final boolean CORE_PARALLEL_LOAD;
    public final boolean LAZY_TRANSLATION;
    public final int ARRAY_UNINITIALIZED_SIZE;
    public final int ARRAY_SMALL;
    public final int HASH_PACKED_ARRAY_MAX;
    public final boolean ROPE_LAZY_SUBSTRINGS;
    public final boolean ROPE_PRINT_INTERN_STATS;
    public final int ROPE_DEPTH_THRESHOLD;
    public final int GLOBAL_VARIABLE_MAX_INVALIDATIONS;
    public final int DEFAULT_CACHE;
    public final int METHOD_LOOKUP_CACHE;
    public final int DISPATCH_CACHE;
    public final int YIELD_CACHE;
    public final int METHOD_TO_PROC_CACHE;
    public final int IS_A_CACHE;
    public final int BIND_CACHE;
    public final int CONSTANT_CACHE;
    public final int INSTANCE_VARIABLE_CACHE;
    public final int BINDING_LOCAL_VARIABLE_CACHE;
    public final int SYMBOL_TO_PROC_CACHE;
    public final int ALLOCATE_CLASS_CACHE;
    public final int PACK_CACHE;
    public final int UNPACK_CACHE;
    public final int EVAL_CACHE;
    public final int CLASS_CACHE;
    public final int ENCODING_COMPATIBLE_QUERY_CACHE;
    public final int ENCODING_LOADED_CLASSES_CACHE;
    public final int THREAD_CACHE;
    public final int ROPE_CLASS_CACHE;
    public final int INTEROP_CONVERT_CACHE;
    public final int INTEROP_EXECUTE_CACHE;
    public final int INTEROP_READ_CACHE;
    public final int INTEROP_WRITE_CACHE;
    public final int INTEROP_INVOKE_CACHE;
    public final boolean CLONE_DEFAULT;
    public final boolean INLINE_DEFAULT;
    public final boolean CORE_ALWAYS_CLONE;
    public final boolean INLINE_NEEDS_CALLER_FRAME;
    public final boolean YIELD_ALWAYS_CLONE;
    public final boolean YIELD_ALWAYS_INLINE;
    public final boolean METHODMISSING_ALWAYS_CLONE;
    public final boolean METHODMISSING_ALWAYS_INLINE;
    public final int PACK_UNROLL_LIMIT;
    public final int PACK_RECOVER_LOOP_MIN;
    public final int INSTRUMENTATION_SERVER_PORT;
    public final boolean EXCEPTIONS_STORE_JAVA;
    public final boolean EXCEPTIONS_PRINT_JAVA;
    public final boolean EXCEPTIONS_PRINT_UNCAUGHT_JAVA;
    public final boolean EXCEPTIONS_TRANSLATE_ASSERT;
    public final boolean BACKTRACES_HIDE_CORE_FILES;
    public final boolean BACKTRACES_INTERLEAVE_JAVA;
    public final int BACKTRACES_LIMIT;
    public final boolean BACKTRACES_OMIT_UNUSED;
    public final boolean BASICOPS_INLINE;
    public final boolean METRICS_TIME;
    public final boolean METRICS_MEMORY_USED_ON_EXIT;
    public final boolean CALL_GRAPH;
    public final String CALL_GRAPH_WRITE;
    public final boolean CHAOS;
    public final boolean GRAAL_WARNING_UNLESS;
    public final boolean SHARED_OBJECTS_ENABLED;
    public final boolean SHARED_OBJECTS_DEBUG;
    public final boolean SHARED_OBJECTS_FORCE;
    public final boolean SHARED_OBJECTS_SHARE_ALL;
    public final boolean CEXTS_LOG_LOAD;
    public final boolean LOG_DYNAMIC_CONSTANT_LOOKUP;
    public final boolean OPTIONS_LOG;

    Options(OptionsBuilder builder) {
        this.HOME = (String)builder.getOrDefault(OptionsCatalog.HOME);
        this.LOAD_PATHS = (String[])builder.getOrDefault(OptionsCatalog.LOAD_PATHS);
        this.REQUIRED_LIBRARIES = (String[])builder.getOrDefault(OptionsCatalog.REQUIRED_LIBRARIES);
        this.INLINE_SCRIPT = (byte[])builder.getOrDefault(OptionsCatalog.INLINE_SCRIPT);
        this.ARGUMENTS = (String[])builder.getOrDefault(OptionsCatalog.ARGUMENTS);
        this.DISPLAYED_FILE_NAME = (String)builder.getOrDefault(OptionsCatalog.DISPLAYED_FILE_NAME);
        this.DEBUG = (Boolean)builder.getOrDefault(OptionsCatalog.DEBUG);
        this.VERBOSITY = builder.getOrDefault(OptionsCatalog.VERBOSITY, Verbosity.FALSE);
        this.FROZEN_STRING_LITERALS = (Boolean)builder.getOrDefault(OptionsCatalog.FROZEN_STRING_LITERALS);
        this.DISABLE_GEMS = (Boolean)builder.getOrDefault(OptionsCatalog.DISABLE_GEMS);
        this.INTERNAL_ENCODING = (String)builder.getOrDefault(OptionsCatalog.INTERNAL_ENCODING);
        this.EXTERNAL_ENCODING = (String)builder.getOrDefault(OptionsCatalog.EXTERNAL_ENCODING);
        this.PLATFORM_SAFE = (Boolean)builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE);
        this.PLATFORM_SAFE_LOAD = builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_LOAD, this.PLATFORM_SAFE);
        this.PLATFORM_SAFE_IO = builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_IO, this.PLATFORM_SAFE);
        this.PLATFORM_SAFE_MEMORY = builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_MEMORY, this.PLATFORM_SAFE);
        this.PLATFORM_SAFE_THREADS = builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_THREADS, this.PLATFORM_SAFE);
        this.PLATFORM_SAFE_PROCESSES = builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_PROCESSES, this.PLATFORM_SAFE);
        this.PLATFORM_SAFE_SIGNALS = builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_SIGNALS, this.PLATFORM_SAFE);
        this.PLATFORM_SAFE_EXIT = builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_EXIT, this.PLATFORM_SAFE);
        this.PLATFORM_SAFE_AT_EXIT = builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_AT_EXIT, this.PLATFORM_SAFE);
        this.PLATFORM_SAFE_PUTS = (Boolean)builder.getOrDefault(OptionsCatalog.PLATFORM_SAFE_PUTS);
        this.PLATFORM_USE_JAVA = (Boolean)builder.getOrDefault(OptionsCatalog.PLATFORM_USE_JAVA);
        this.TRACE_CALLS = (Boolean)builder.getOrDefault(OptionsCatalog.TRACE_CALLS);
        this.COVERAGE_GLOBAL = (Boolean)builder.getOrDefault(OptionsCatalog.COVERAGE_GLOBAL);
        this.INLINE_JS = (Boolean)builder.getOrDefault(OptionsCatalog.INLINE_JS);
        this.CORE_LOAD_PATH = (String)builder.getOrDefault(OptionsCatalog.CORE_LOAD_PATH);
        this.CORE_PARALLEL_LOAD = (Boolean)builder.getOrDefault(OptionsCatalog.CORE_PARALLEL_LOAD);
        this.LAZY_TRANSLATION = (Boolean)builder.getOrDefault(OptionsCatalog.LAZY_TRANSLATION);
        this.ARRAY_UNINITIALIZED_SIZE = (Integer)builder.getOrDefault(OptionsCatalog.ARRAY_UNINITIALIZED_SIZE);
        this.ARRAY_SMALL = (Integer)builder.getOrDefault(OptionsCatalog.ARRAY_SMALL);
        this.HASH_PACKED_ARRAY_MAX = (Integer)builder.getOrDefault(OptionsCatalog.HASH_PACKED_ARRAY_MAX);
        this.ROPE_LAZY_SUBSTRINGS = (Boolean)builder.getOrDefault(OptionsCatalog.ROPE_LAZY_SUBSTRINGS);
        this.ROPE_PRINT_INTERN_STATS = (Boolean)builder.getOrDefault(OptionsCatalog.ROPE_PRINT_INTERN_STATS);
        this.ROPE_DEPTH_THRESHOLD = (Integer)builder.getOrDefault(OptionsCatalog.ROPE_DEPTH_THRESHOLD);
        this.GLOBAL_VARIABLE_MAX_INVALIDATIONS = (Integer)builder.getOrDefault(OptionsCatalog.GLOBAL_VARIABLE_MAX_INVALIDATIONS);
        this.DEFAULT_CACHE = (Integer)builder.getOrDefault(OptionsCatalog.DEFAULT_CACHE);
        this.METHOD_LOOKUP_CACHE = builder.getOrDefault(OptionsCatalog.METHOD_LOOKUP_CACHE, this.DEFAULT_CACHE);
        this.DISPATCH_CACHE = builder.getOrDefault(OptionsCatalog.DISPATCH_CACHE, this.DEFAULT_CACHE);
        this.YIELD_CACHE = builder.getOrDefault(OptionsCatalog.YIELD_CACHE, this.DEFAULT_CACHE);
        this.METHOD_TO_PROC_CACHE = builder.getOrDefault(OptionsCatalog.METHOD_TO_PROC_CACHE, this.DEFAULT_CACHE);
        this.IS_A_CACHE = builder.getOrDefault(OptionsCatalog.IS_A_CACHE, this.DEFAULT_CACHE);
        this.BIND_CACHE = builder.getOrDefault(OptionsCatalog.BIND_CACHE, this.DEFAULT_CACHE);
        this.CONSTANT_CACHE = builder.getOrDefault(OptionsCatalog.CONSTANT_CACHE, this.DEFAULT_CACHE);
        this.INSTANCE_VARIABLE_CACHE = builder.getOrDefault(OptionsCatalog.INSTANCE_VARIABLE_CACHE, this.DEFAULT_CACHE);
        this.BINDING_LOCAL_VARIABLE_CACHE = builder.getOrDefault(OptionsCatalog.BINDING_LOCAL_VARIABLE_CACHE, this.DEFAULT_CACHE);
        this.SYMBOL_TO_PROC_CACHE = builder.getOrDefault(OptionsCatalog.SYMBOL_TO_PROC_CACHE, this.DEFAULT_CACHE);
        this.ALLOCATE_CLASS_CACHE = builder.getOrDefault(OptionsCatalog.ALLOCATE_CLASS_CACHE, this.DEFAULT_CACHE);
        this.PACK_CACHE = builder.getOrDefault(OptionsCatalog.PACK_CACHE, this.DEFAULT_CACHE);
        this.UNPACK_CACHE = builder.getOrDefault(OptionsCatalog.UNPACK_CACHE, this.DEFAULT_CACHE);
        this.EVAL_CACHE = builder.getOrDefault(OptionsCatalog.EVAL_CACHE, this.DEFAULT_CACHE);
        this.CLASS_CACHE = builder.getOrDefault(OptionsCatalog.CLASS_CACHE, this.DEFAULT_CACHE);
        this.ENCODING_COMPATIBLE_QUERY_CACHE = builder.getOrDefault(OptionsCatalog.ENCODING_COMPATIBLE_QUERY_CACHE, this.DEFAULT_CACHE);
        this.ENCODING_LOADED_CLASSES_CACHE = builder.getOrDefault(OptionsCatalog.ENCODING_LOADED_CLASSES_CACHE, this.DEFAULT_CACHE);
        this.THREAD_CACHE = builder.getOrDefault(OptionsCatalog.THREAD_CACHE, this.DEFAULT_CACHE);
        this.ROPE_CLASS_CACHE = (Integer)builder.getOrDefault(OptionsCatalog.ROPE_CLASS_CACHE);
        this.INTEROP_CONVERT_CACHE = builder.getOrDefault(OptionsCatalog.INTEROP_CONVERT_CACHE, this.DEFAULT_CACHE);
        this.INTEROP_EXECUTE_CACHE = builder.getOrDefault(OptionsCatalog.INTEROP_EXECUTE_CACHE, this.DEFAULT_CACHE);
        this.INTEROP_READ_CACHE = builder.getOrDefault(OptionsCatalog.INTEROP_READ_CACHE, this.DEFAULT_CACHE);
        this.INTEROP_WRITE_CACHE = builder.getOrDefault(OptionsCatalog.INTEROP_WRITE_CACHE, this.DEFAULT_CACHE);
        this.INTEROP_INVOKE_CACHE = builder.getOrDefault(OptionsCatalog.INTEROP_INVOKE_CACHE, this.DEFAULT_CACHE);
        this.CLONE_DEFAULT = (Boolean)builder.getOrDefault(OptionsCatalog.CLONE_DEFAULT);
        this.INLINE_DEFAULT = (Boolean)builder.getOrDefault(OptionsCatalog.INLINE_DEFAULT);
        this.CORE_ALWAYS_CLONE = builder.getOrDefault(OptionsCatalog.CORE_ALWAYS_CLONE, this.CLONE_DEFAULT);
        this.INLINE_NEEDS_CALLER_FRAME = builder.getOrDefault(OptionsCatalog.INLINE_NEEDS_CALLER_FRAME, this.INLINE_DEFAULT);
        this.YIELD_ALWAYS_CLONE = builder.getOrDefault(OptionsCatalog.YIELD_ALWAYS_CLONE, this.CLONE_DEFAULT);
        this.YIELD_ALWAYS_INLINE = builder.getOrDefault(OptionsCatalog.YIELD_ALWAYS_INLINE, this.INLINE_DEFAULT);
        this.METHODMISSING_ALWAYS_CLONE = builder.getOrDefault(OptionsCatalog.METHODMISSING_ALWAYS_CLONE, this.CLONE_DEFAULT);
        this.METHODMISSING_ALWAYS_INLINE = builder.getOrDefault(OptionsCatalog.METHODMISSING_ALWAYS_INLINE, this.INLINE_DEFAULT);
        this.PACK_UNROLL_LIMIT = (Integer)builder.getOrDefault(OptionsCatalog.PACK_UNROLL_LIMIT);
        this.PACK_RECOVER_LOOP_MIN = (Integer)builder.getOrDefault(OptionsCatalog.PACK_RECOVER_LOOP_MIN);
        this.INSTRUMENTATION_SERVER_PORT = (Integer)builder.getOrDefault(OptionsCatalog.INSTRUMENTATION_SERVER_PORT);
        this.EXCEPTIONS_STORE_JAVA = (Boolean)builder.getOrDefault(OptionsCatalog.EXCEPTIONS_STORE_JAVA);
        this.EXCEPTIONS_PRINT_JAVA = (Boolean)builder.getOrDefault(OptionsCatalog.EXCEPTIONS_PRINT_JAVA);
        this.EXCEPTIONS_PRINT_UNCAUGHT_JAVA = (Boolean)builder.getOrDefault(OptionsCatalog.EXCEPTIONS_PRINT_UNCAUGHT_JAVA);
        this.EXCEPTIONS_TRANSLATE_ASSERT = (Boolean)builder.getOrDefault(OptionsCatalog.EXCEPTIONS_TRANSLATE_ASSERT);
        this.BACKTRACES_HIDE_CORE_FILES = (Boolean)builder.getOrDefault(OptionsCatalog.BACKTRACES_HIDE_CORE_FILES);
        this.BACKTRACES_INTERLEAVE_JAVA = (Boolean)builder.getOrDefault(OptionsCatalog.BACKTRACES_INTERLEAVE_JAVA);
        this.BACKTRACES_LIMIT = (Integer)builder.getOrDefault(OptionsCatalog.BACKTRACES_LIMIT);
        this.BACKTRACES_OMIT_UNUSED = (Boolean)builder.getOrDefault(OptionsCatalog.BACKTRACES_OMIT_UNUSED);
        this.BASICOPS_INLINE = (Boolean)builder.getOrDefault(OptionsCatalog.BASICOPS_INLINE);
        this.METRICS_TIME = (Boolean)builder.getOrDefault(OptionsCatalog.METRICS_TIME);
        this.METRICS_MEMORY_USED_ON_EXIT = (Boolean)builder.getOrDefault(OptionsCatalog.METRICS_MEMORY_USED_ON_EXIT);
        this.CALL_GRAPH = (Boolean)builder.getOrDefault(OptionsCatalog.CALL_GRAPH);
        this.CALL_GRAPH_WRITE = (String)builder.getOrDefault(OptionsCatalog.CALL_GRAPH_WRITE);
        this.CHAOS = (Boolean)builder.getOrDefault(OptionsCatalog.CHAOS);
        this.GRAAL_WARNING_UNLESS = (Boolean)builder.getOrDefault(OptionsCatalog.GRAAL_WARNING_UNLESS);
        this.SHARED_OBJECTS_ENABLED = (Boolean)builder.getOrDefault(OptionsCatalog.SHARED_OBJECTS_ENABLED);
        this.SHARED_OBJECTS_DEBUG = (Boolean)builder.getOrDefault(OptionsCatalog.SHARED_OBJECTS_DEBUG);
        this.SHARED_OBJECTS_FORCE = (Boolean)builder.getOrDefault(OptionsCatalog.SHARED_OBJECTS_FORCE);
        this.SHARED_OBJECTS_SHARE_ALL = (Boolean)builder.getOrDefault(OptionsCatalog.SHARED_OBJECTS_SHARE_ALL);
        this.CEXTS_LOG_LOAD = (Boolean)builder.getOrDefault(OptionsCatalog.CEXTS_LOG_LOAD);
        this.LOG_DYNAMIC_CONSTANT_LOOKUP = (Boolean)builder.getOrDefault(OptionsCatalog.LOG_DYNAMIC_CONSTANT_LOOKUP);
        this.OPTIONS_LOG = (Boolean)builder.getOrDefault(OptionsCatalog.OPTIONS_LOG);
    }

    public Object fromDescription(OptionDescription description) {
        switch (description.getName()) {
            case "home": {
                return this.HOME;
            }
            case "load_paths": {
                return this.LOAD_PATHS;
            }
            case "required_libraries": {
                return this.REQUIRED_LIBRARIES;
            }
            case "inline_script": {
                return this.INLINE_SCRIPT;
            }
            case "arguments": {
                return this.ARGUMENTS;
            }
            case "displayed_file_name": {
                return this.DISPLAYED_FILE_NAME;
            }
            case "debug": {
                return this.DEBUG;
            }
            case "verbosity": {
                return this.VERBOSITY;
            }
            case "frozen_string_literals": {
                return this.FROZEN_STRING_LITERALS;
            }
            case "disable_gems": {
                return this.DISABLE_GEMS;
            }
            case "internal_encoding": {
                return this.INTERNAL_ENCODING;
            }
            case "external_encoding": {
                return this.EXTERNAL_ENCODING;
            }
            case "platform.safe": {
                return this.PLATFORM_SAFE;
            }
            case "platform.safe.load": {
                return this.PLATFORM_SAFE_LOAD;
            }
            case "platform.safe.io": {
                return this.PLATFORM_SAFE_IO;
            }
            case "platform.safe.memory": {
                return this.PLATFORM_SAFE_MEMORY;
            }
            case "platform.safe.threads": {
                return this.PLATFORM_SAFE_THREADS;
            }
            case "platform.safe.processes": {
                return this.PLATFORM_SAFE_PROCESSES;
            }
            case "platform.safe.siganls": {
                return this.PLATFORM_SAFE_SIGNALS;
            }
            case "platform.safe.exit": {
                return this.PLATFORM_SAFE_EXIT;
            }
            case "platform.safe.at_exit": {
                return this.PLATFORM_SAFE_AT_EXIT;
            }
            case "platform.safe_puts": {
                return this.PLATFORM_SAFE_PUTS;
            }
            case "platform.use_java": {
                return this.PLATFORM_USE_JAVA;
            }
            case "trace.calls": {
                return this.TRACE_CALLS;
            }
            case "coverage.global": {
                return this.COVERAGE_GLOBAL;
            }
            case "inline_js": {
                return this.INLINE_JS;
            }
            case "core.load_path": {
                return this.CORE_LOAD_PATH;
            }
            case "core.parallel_load": {
                return this.CORE_PARALLEL_LOAD;
            }
            case "lazy_translation": {
                return this.LAZY_TRANSLATION;
            }
            case "array.uninitialized_size": {
                return this.ARRAY_UNINITIALIZED_SIZE;
            }
            case "array.small": {
                return this.ARRAY_SMALL;
            }
            case "hash.packed_array.max": {
                return this.HASH_PACKED_ARRAY_MAX;
            }
            case "rope.lazy_substrings": {
                return this.ROPE_LAZY_SUBSTRINGS;
            }
            case "rope.print_intern_stats": {
                return this.ROPE_PRINT_INTERN_STATS;
            }
            case "rope.depth_threshold": {
                return this.ROPE_DEPTH_THRESHOLD;
            }
            case "global_variable.max_invalidations": {
                return this.GLOBAL_VARIABLE_MAX_INVALIDATIONS;
            }
            case "default_cache": {
                return this.DEFAULT_CACHE;
            }
            case "method_lookup.cache": {
                return this.METHOD_LOOKUP_CACHE;
            }
            case "dispatch.cache": {
                return this.DISPATCH_CACHE;
            }
            case "yield.cache": {
                return this.YIELD_CACHE;
            }
            case "to_proc.cache": {
                return this.METHOD_TO_PROC_CACHE;
            }
            case "is_a.cache": {
                return this.IS_A_CACHE;
            }
            case "bind.cache": {
                return this.BIND_CACHE;
            }
            case "constant.cache": {
                return this.CONSTANT_CACHE;
            }
            case "instance_variable.cache": {
                return this.INSTANCE_VARIABLE_CACHE;
            }
            case "binding_local_variable.cache": {
                return this.BINDING_LOCAL_VARIABLE_CACHE;
            }
            case "symbol_to_proc.cache": {
                return this.SYMBOL_TO_PROC_CACHE;
            }
            case "allocate_class.cache": {
                return this.ALLOCATE_CLASS_CACHE;
            }
            case "pack.cache": {
                return this.PACK_CACHE;
            }
            case "unpack.cache": {
                return this.UNPACK_CACHE;
            }
            case "eval.cache": {
                return this.EVAL_CACHE;
            }
            case "class.cache": {
                return this.CLASS_CACHE;
            }
            case "encoding_compatible_query.cache": {
                return this.ENCODING_COMPATIBLE_QUERY_CACHE;
            }
            case "encoding_loaded_classes.cache": {
                return this.ENCODING_LOADED_CLASSES_CACHE;
            }
            case "thread.cache": {
                return this.THREAD_CACHE;
            }
            case "rope_class.cache": {
                return this.ROPE_CLASS_CACHE;
            }
            case "interop.convert.cache": {
                return this.INTEROP_CONVERT_CACHE;
            }
            case "interop.execute.cache": {
                return this.INTEROP_EXECUTE_CACHE;
            }
            case "interop.read.cache": {
                return this.INTEROP_READ_CACHE;
            }
            case "interop.write.cache": {
                return this.INTEROP_WRITE_CACHE;
            }
            case "interop.invoke.cache": {
                return this.INTEROP_INVOKE_CACHE;
            }
            case "clone.default": {
                return this.CLONE_DEFAULT;
            }
            case "inline.default": {
                return this.INLINE_DEFAULT;
            }
            case "core.always_clone": {
                return this.CORE_ALWAYS_CLONE;
            }
            case "inline_needs_caller_frame": {
                return this.INLINE_NEEDS_CALLER_FRAME;
            }
            case "yield.always_clone": {
                return this.YIELD_ALWAYS_CLONE;
            }
            case "yield.always_inline": {
                return this.YIELD_ALWAYS_INLINE;
            }
            case "method_missing.always_clone": {
                return this.METHODMISSING_ALWAYS_CLONE;
            }
            case "method_missing.always_inline": {
                return this.METHODMISSING_ALWAYS_INLINE;
            }
            case "pack.unroll": {
                return this.PACK_UNROLL_LIMIT;
            }
            case "pack.recover": {
                return this.PACK_RECOVER_LOOP_MIN;
            }
            case "instrumentation_server_port": {
                return this.INSTRUMENTATION_SERVER_PORT;
            }
            case "exceptions.store_java": {
                return this.EXCEPTIONS_STORE_JAVA;
            }
            case "exceptions.print_java": {
                return this.EXCEPTIONS_PRINT_JAVA;
            }
            case "exceptions.print_uncaught_java": {
                return this.EXCEPTIONS_PRINT_UNCAUGHT_JAVA;
            }
            case "exceptions.translate_assert": {
                return this.EXCEPTIONS_TRANSLATE_ASSERT;
            }
            case "backtraces.hide_core_files": {
                return this.BACKTRACES_HIDE_CORE_FILES;
            }
            case "backtraces.interleave_java": {
                return this.BACKTRACES_INTERLEAVE_JAVA;
            }
            case "backtraces.limit": {
                return this.BACKTRACES_LIMIT;
            }
            case "backtraces.omit_unused": {
                return this.BACKTRACES_OMIT_UNUSED;
            }
            case "basic_ops.inline": {
                return this.BASICOPS_INLINE;
            }
            case "metrics.time": {
                return this.METRICS_TIME;
            }
            case "metrics.memory_used_on_exit": {
                return this.METRICS_MEMORY_USED_ON_EXIT;
            }
            case "callgraph": {
                return this.CALL_GRAPH;
            }
            case "callgraph.write": {
                return this.CALL_GRAPH_WRITE;
            }
            case "chaos": {
                return this.CHAOS;
            }
            case "graal.warn_unless": {
                return this.GRAAL_WARNING_UNLESS;
            }
            case "shared.objects": {
                return this.SHARED_OBJECTS_ENABLED;
            }
            case "shared.objects.debug": {
                return this.SHARED_OBJECTS_DEBUG;
            }
            case "shared.objects.force": {
                return this.SHARED_OBJECTS_FORCE;
            }
            case "shared.objects.share_all": {
                return this.SHARED_OBJECTS_SHARE_ALL;
            }
            case "cexts.log.load": {
                return this.CEXTS_LOG_LOAD;
            }
            case "constant.dynamic_lookup.log": {
                return this.LOG_DYNAMIC_CONSTANT_LOOKUP;
            }
            case "options.log": {
                return this.OPTIONS_LOG;
            }
        }
        return null;
    }
}

