/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.percolator.MultiPercolateRequest;
import org.elasticsearch.percolator.MultiPercolateResponse;
import org.elasticsearch.percolator.PercolateRequest;
import org.elasticsearch.percolator.TransportPercolateAction;
import org.elasticsearch.search.SearchRequestParsers;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Deprecated
public class TransportMultiPercolateAction
extends HandledTransportAction<MultiPercolateRequest, MultiPercolateResponse> {
    private final Client client;
    private final ParseFieldMatcher parseFieldMatcher;
    private final SearchRequestParsers searchRequestParsers;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportMultiPercolateAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, SearchRequestParsers searchRequestParsers, NamedXContentRegistry xContentRegistry) {
        super(settings, "indices:data/read/mpercolate", threadPool, transportService, actionFilters, indexNameExpressionResolver, MultiPercolateRequest::new);
        this.client = client;
        this.searchRequestParsers = searchRequestParsers;
        this.xContentRegistry = xContentRegistry;
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
    }

    protected void doExecute(final MultiPercolateRequest request, final ActionListener<MultiPercolateResponse> listener) {
        final ArrayList<Tuple> getRequests = new ArrayList<Tuple>();
        for (int i = 0; i < request.requests().size(); ++i) {
            GetRequest getRequest = request.requests().get(i).getRequest();
            if (getRequest == null) continue;
            getRequests.add(new Tuple((Object)i, (Object)getRequest));
        }
        if (getRequests.isEmpty()) {
            this.innerDoExecute(request, listener, Collections.emptyMap(), new HashMap<Integer, MultiPercolateResponse.Item>());
        } else {
            MultiGetRequest multiGetRequest = new MultiGetRequest();
            for (Tuple tuple : getRequests) {
                GetRequest getRequest = (GetRequest)tuple.v2();
                multiGetRequest.add(new MultiGetRequest.Item(getRequest.index(), getRequest.type(), getRequest.id()));
            }
            this.client.multiGet(multiGetRequest, (ActionListener)new ActionListener<MultiGetResponse>(){

                public void onResponse(MultiGetResponse response) {
                    HashMap<Integer, BytesReference> getResponseSources = new HashMap<Integer, BytesReference>(response.getResponses().length);
                    HashMap<Integer, MultiPercolateResponse.Item> preFailures = new HashMap<Integer, MultiPercolateResponse.Item>();
                    for (int i = 0; i < response.getResponses().length; ++i) {
                        MultiGetItemResponse itemResponse = response.getResponses()[i];
                        int originalSlot = (Integer)((Tuple)getRequests.get(i)).v1();
                        if (itemResponse.isFailed()) {
                            preFailures.put(originalSlot, new MultiPercolateResponse.Item(itemResponse.getFailure().getFailure()));
                            continue;
                        }
                        if (itemResponse.getResponse().isExists()) {
                            getResponseSources.put(originalSlot, itemResponse.getResponse().getSourceAsBytesRef());
                            continue;
                        }
                        GetRequest getRequest = (GetRequest)((Tuple)getRequests.get(i)).v2();
                        preFailures.put(originalSlot, new MultiPercolateResponse.Item((Exception)new ResourceNotFoundException("percolate document [{}/{}/{}] doesn't exist", new Object[]{getRequest.index(), getRequest.type(), getRequest.id()})));
                    }
                    TransportMultiPercolateAction.this.innerDoExecute(request, (ActionListener<MultiPercolateResponse>)listener, getResponseSources, preFailures);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private void innerDoExecute(final MultiPercolateRequest request, final ActionListener<MultiPercolateResponse> listener, Map<Integer, BytesReference> getResponseSources, final Map<Integer, MultiPercolateResponse.Item> preFailures) {
        try {
            MultiSearchRequest multiSearchRequest = this.createMultiSearchRequest(request, getResponseSources, preFailures);
            if (multiSearchRequest.requests().isEmpty()) {
                listener.onResponse((Object)this.createMultiPercolateResponse(new MultiSearchResponse(new MultiSearchResponse.Item[0]), request, preFailures));
            } else {
                this.client.multiSearch(multiSearchRequest, (ActionListener)new ActionListener<MultiSearchResponse>(){

                    public void onResponse(MultiSearchResponse response) {
                        try {
                            listener.onResponse((Object)TransportMultiPercolateAction.this.createMultiPercolateResponse(response, request, preFailures));
                        }
                        catch (Exception e) {
                            this.onFailure(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private MultiSearchRequest createMultiSearchRequest(MultiPercolateRequest multiPercolateRequest, Map<Integer, BytesReference> getResponseSources, Map<Integer, MultiPercolateResponse.Item> preFailures) throws IOException {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        multiSearchRequest.indicesOptions(multiPercolateRequest.indicesOptions());
        for (int i = 0; i < multiPercolateRequest.requests().size(); ++i) {
            if (preFailures.keySet().contains(i)) continue;
            PercolateRequest percolateRequest = multiPercolateRequest.requests().get(i);
            BytesReference docSource = getResponseSources.get(i);
            try {
                SearchRequest searchRequest = TransportPercolateAction.createSearchRequest(percolateRequest, docSource, this.searchRequestParsers.aggParsers, this.searchRequestParsers.searchExtParsers, this.xContentRegistry, this.parseFieldMatcher);
                multiSearchRequest.add(searchRequest);
                continue;
            }
            catch (Exception e) {
                preFailures.put(i, new MultiPercolateResponse.Item(e));
            }
        }
        return multiSearchRequest;
    }

    private MultiPercolateResponse createMultiPercolateResponse(MultiSearchResponse multiSearchResponse, MultiPercolateRequest request, Map<Integer, MultiPercolateResponse.Item> preFailures) {
        int searchResponseIndex = 0;
        MultiPercolateResponse.Item[] percolateItems = new MultiPercolateResponse.Item[request.requests().size()];
        for (int i = 0; i < percolateItems.length; ++i) {
            if (preFailures.keySet().contains(i)) {
                percolateItems[i] = preFailures.get(i);
                continue;
            }
            MultiSearchResponse.Item searchItem = multiSearchResponse.getResponses()[searchResponseIndex++];
            if (searchItem.isFailure()) {
                percolateItems[i] = new MultiPercolateResponse.Item(searchItem.getFailure());
                continue;
            }
            PercolateRequest percolateRequest = request.requests().get(i);
            percolateItems[i] = new MultiPercolateResponse.Item(TransportPercolateAction.createPercolateResponse(searchItem.getResponse(), percolateRequest.onlyCount()));
        }
        return new MultiPercolateResponse(percolateItems);
    }
}

