/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.pack;

import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatEncoding;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.LiteralFormatNode;
import org.jruby.truffle.core.format.SharedTreeBuilder;
import org.jruby.truffle.core.format.control.AdvanceSourcePositionNode;
import org.jruby.truffle.core.format.control.ReverseOutputPositionNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.control.SetOutputPositionNode;
import org.jruby.truffle.core.format.convert.Integer16BigToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer16LittleToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer32BigToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer32LittleToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer64BigToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer64LittleToBytesNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretAsLongNodeGen;
import org.jruby.truffle.core.format.convert.ToFloatNodeGen;
import org.jruby.truffle.core.format.convert.ToLongNode;
import org.jruby.truffle.core.format.convert.ToLongNodeGen;
import org.jruby.truffle.core.format.pack.SimplePackListener;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.format.read.array.ReadDoubleNode;
import org.jruby.truffle.core.format.read.array.ReadDoubleNodeGen;
import org.jruby.truffle.core.format.read.array.ReadLongOrBigIntegerNodeGen;
import org.jruby.truffle.core.format.read.array.ReadStringNodeGen;
import org.jruby.truffle.core.format.read.array.ReadValueNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBERNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBase64StringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBinaryStringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBitStringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteByteNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBytesNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteHexStringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteMIMEStringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteUTF8CharacterNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteUUStringNodeGen;
import org.jruby.truffle.language.control.RaiseException;

public class SimplePackTreeBuilder
implements SimplePackListener {
    private final RubyContext context;
    private final Node currentNode;
    private final SharedTreeBuilder sharedTreeBuilder;
    private FormatEncoding encoding = FormatEncoding.DEFAULT;
    private final Deque<List<FormatNode>> sequenceStack = new ArrayDeque<List<FormatNode>>();

    public SimplePackTreeBuilder(RubyContext context, Node currentNode) {
        this.context = context;
        this.currentNode = currentNode;
        this.sharedTreeBuilder = new SharedTreeBuilder(context);
        this.pushSequence();
    }

    public void enterSequence() {
        this.pushSequence();
    }

    public void exitSequence() {
        List<FormatNode> sequence = this.sequenceStack.pop();
        this.appendNode(new SequenceNode(sequence.toArray(new FormatNode[sequence.size()])));
    }

    @Override
    public void integer(int size, boolean signed, ByteOrder byteOrder, int count) {
        this.appendIntegerNode(size, byteOrder, count);
    }

    @Override
    public void floatingPoint(int size, ByteOrder byteOrder, int count) {
        this.appendFloatNode(size, byteOrder, count);
    }

    @Override
    public void utf8Character(int count) {
        this.unify(FormatEncoding.UTF_8);
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteUTF8CharacterNodeGen.create(ToLongNodeGen.create(false, ReadValueNodeGen.create(new SourceNode())))));
    }

    @Override
    public void berInteger(int count) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteBERNodeGen.create(ReadLongOrBigIntegerNodeGen.create(new SourceNode()))));
    }

    @Override
    public void binaryStringSpacePadded(int count) {
        this.binaryString((byte)32, true, false, count);
    }

    @Override
    public void binaryStringNullPadded(int count) {
        this.binaryString((byte)0, true, false, count);
    }

    @Override
    public void binaryStringNullStar(int count) {
        this.binaryString((byte)0, true, count == -2, count);
    }

    @Override
    public void bitStringMSBFirst(int count) {
        this.bitString(ByteOrder.BIG_ENDIAN, count);
    }

    @Override
    public void bitStringMSBLast(int count) {
        this.bitString(ByteOrder.LITTLE_ENDIAN, count);
    }

    @Override
    public void hexStringHighFirst(int count) {
        this.hexString(ByteOrder.BIG_ENDIAN, count);
    }

    @Override
    public void hexStringLowFirst(int count) {
        this.hexString(ByteOrder.LITTLE_ENDIAN, count);
    }

    @Override
    public void uuString(int count) {
        this.unify(FormatEncoding.US_ASCII);
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(count);
        this.appendNode(WriteUUStringNodeGen.create(starLength.getLength(), starLength.isStar(), ReadStringNodeGen.create(false, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void mimeString(int count) {
        int length;
        this.unify(FormatEncoding.US_ASCII);
        if (count == -2) {
            length = 72;
        } else {
            length = count;
            if (length <= 1) {
                length = 72;
            }
        }
        this.appendNode(WriteMIMEStringNodeGen.create(length, ReadStringNodeGen.create(true, "to_s", true, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void base64String(int count) {
        this.unify(FormatEncoding.US_ASCII);
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(count);
        this.appendNode(WriteBase64StringNodeGen.create(starLength.getLength(), starLength.isStar(), ReadStringNodeGen.create(false, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void pointer() {
        this.appendNode(new SequenceNode(new FormatNode[]{new AdvanceSourcePositionNode(false), this.writeInteger(64, ByteOrder.nativeOrder(), new LiteralFormatNode(0L))}));
    }

    @Override
    public void at(int position) {
        if (position == -1) {
            position = 1;
        } else if (position == -2) {
            throw new UnsupportedOperationException();
        }
        this.appendNode(new SetOutputPositionNode(position));
    }

    @Override
    public void back(int count) {
        if (count == -1 || count >= 0) {
            this.appendNode(this.sharedTreeBuilder.applyCount(count, new ReverseOutputPositionNode()));
        }
    }

    @Override
    public void nullByte(int count) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteByteNodeGen.create(new LiteralFormatNode((byte)0))));
    }

    @Override
    public void startSubSequence() {
        this.pushSequence();
    }

    @Override
    public void finishSubSequence(int count) {
        this.appendNode(this.sharedTreeBuilder.finishSubSequence(this.sequenceStack, count));
    }

    @Override
    public void error(String message) {
        throw new RaiseException(this.context.getCoreExceptions().argumentError(message, this.currentNode));
    }

    public FormatNode getNode() {
        return this.sequenceStack.peek().get(0);
    }

    public FormatEncoding getEncoding() {
        return this.encoding;
    }

    private void pushSequence() {
        this.sequenceStack.push(new ArrayList());
    }

    private void appendNode(FormatNode node) {
        this.sequenceStack.peek().add(node);
    }

    private void appendIntegerNode(int size, ByteOrder byteOrder, int count) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, this.writeInteger(size, byteOrder)));
    }

    private void appendFloatNode(int size, ByteOrder byteOrder, int count) {
        FormatNode typeNode;
        ReadDoubleNode readNode = ReadDoubleNodeGen.create(new SourceNode());
        switch (size) {
            case 32: {
                typeNode = ToFloatNodeGen.create(readNode);
                break;
            }
            case 64: {
                typeNode = readNode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.appendNode(this.sharedTreeBuilder.applyCount(count, this.writeInteger(size, byteOrder, ReinterpretAsLongNodeGen.create(typeNode))));
    }

    private FormatNode writeInteger(int size, ByteOrder byteOrder) {
        ToLongNode readNode = ToLongNodeGen.create(false, ReadValueNodeGen.create(new SourceNode()));
        return this.writeInteger(size, byteOrder, readNode);
    }

    private FormatNode writeInteger(int size, ByteOrder byteOrder, FormatNode readNode) {
        FormatNode convertNode;
        switch (size) {
            case 8: {
                return WriteByteNodeGen.create(readNode);
            }
            case 16: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer16LittleToBytesNodeGen.create(readNode);
                    break;
                }
                convertNode = Integer16BigToBytesNodeGen.create(readNode);
                break;
            }
            case 32: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer32LittleToBytesNodeGen.create(readNode);
                    break;
                }
                convertNode = Integer32BigToBytesNodeGen.create(readNode);
                break;
            }
            case 64: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer64LittleToBytesNodeGen.create(readNode);
                    break;
                }
                convertNode = Integer64BigToBytesNodeGen.create(readNode);
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(size));
            }
        }
        return WriteBytesNodeGen.create(convertNode);
    }

    private void binaryString(byte padding, boolean padOnNull, boolean appendNull, int count) {
        int width;
        boolean pad;
        this.unify(FormatEncoding.ASCII_8BIT);
        if (count >= 0) {
            pad = true;
            width = count;
        } else {
            pad = false;
            if (count == -2) {
                padOnNull = false;
            }
            width = 1;
        }
        boolean takeAll = count == -2;
        this.appendNode(WriteBinaryStringNodeGen.create(pad, padOnNull, width, padding, takeAll, appendNull, ReadStringNodeGen.create(true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private void bitString(ByteOrder byteOrder, int count) {
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(count);
        this.appendNode(WriteBitStringNodeGen.create(byteOrder, starLength.isStar(), starLength.getLength(), ReadStringNodeGen.create(true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private void hexString(ByteOrder byteOrder, int count) {
        int length = count == -1 ? 1 : (count == -2 ? -1 : count);
        this.appendNode(WriteHexStringNodeGen.create(byteOrder, length, ReadStringNodeGen.create(true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private void unify(FormatEncoding other) {
        this.encoding = this.encoding.unifyWith(other);
    }
}

