/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.thread;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.jruby.truffle.core.InterruptMode;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.fiber.FiberManager;
import org.jruby.truffle.core.thread.ThreadLayout;
import org.jruby.truffle.core.thread.ThreadStatus;

@GeneratedBy(value=ThreadLayout.class)
public class ThreadLayoutImpl
extends BasicObjectLayoutImpl
implements ThreadLayout {
    public static final ThreadLayout INSTANCE = new ThreadLayoutImpl();
    protected static final Shape.Allocator THREAD_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey THREAD_LOCALS_IDENTIFIER = new HiddenKey("threadLocals");
    protected static final Property THREAD_LOCALS_PROPERTY = Property.create(THREAD_LOCALS_IDENTIFIER, THREAD_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey INTERRUPT_MODE_IDENTIFIER = new HiddenKey("interruptMode");
    protected static final Property INTERRUPT_MODE_PROPERTY = Property.create(INTERRUPT_MODE_IDENTIFIER, THREAD_ALLOCATOR.locationForType(AtomicReference.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey STATUS_IDENTIFIER = new HiddenKey("status");
    protected static final Property STATUS_PROPERTY = Property.create(STATUS_IDENTIFIER, THREAD_ALLOCATOR.locationForType(AtomicReference.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey OWNED_LOCKS_IDENTIFIER = new HiddenKey("ownedLocks");
    protected static final Property OWNED_LOCKS_PROPERTY = Property.create(OWNED_LOCKS_IDENTIFIER, THREAD_ALLOCATOR.locationForType(List.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey FIBER_MANAGER_IDENTIFIER = new HiddenKey("fiberManager");
    protected static final Property FIBER_MANAGER_PROPERTY = Property.create(FIBER_MANAGER_IDENTIFIER, THREAD_ALLOCATOR.locationForType(FiberManager.class, EnumSet.of(LocationModifier.Final)), 0);
    protected static final HiddenKey FINISHED_LATCH_IDENTIFIER = new HiddenKey("finishedLatch");
    protected static final Property FINISHED_LATCH_PROPERTY = Property.create(FINISHED_LATCH_IDENTIFIER, THREAD_ALLOCATOR.locationForType(CountDownLatch.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey ABORT_ON_EXCEPTION_IDENTIFIER = new HiddenKey("abortOnException");
    protected static final Property ABORT_ON_EXCEPTION_PROPERTY = Property.create(ABORT_ON_EXCEPTION_IDENTIFIER, THREAD_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey THREAD_IDENTIFIER = new HiddenKey("thread");
    protected static final Property THREAD_PROPERTY = Property.create(THREAD_IDENTIFIER, THREAD_ALLOCATOR.locationForType(AtomicReference.class), 0);
    protected static final HiddenKey EXCEPTION_IDENTIFIER = new HiddenKey("exception");
    protected static final Property EXCEPTION_PROPERTY = Property.create(EXCEPTION_IDENTIFIER, THREAD_ALLOCATOR.locationForType(AtomicReference.class), 0);
    protected static final HiddenKey VALUE_IDENTIFIER = new HiddenKey("value");
    protected static final Property VALUE_PROPERTY = Property.create(VALUE_IDENTIFIER, THREAD_ALLOCATOR.locationForType(AtomicReference.class), 0);
    protected static final HiddenKey WAKE_UP_IDENTIFIER = new HiddenKey("wakeUp");
    protected static final Property WAKE_UP_PROPERTY = Property.create(WAKE_UP_IDENTIFIER, THREAD_ALLOCATOR.locationForType(AtomicBoolean.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey PRIORITY_IDENTIFIER = new HiddenKey("priority");
    protected static final Property PRIORITY_PROPERTY = Property.create(PRIORITY_IDENTIFIER, THREAD_ALLOCATOR.locationForType(AtomicInteger.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey THREAD_GROUP_IDENTIFIER = new HiddenKey("threadGroup");
    protected static final Property THREAD_GROUP_PROPERTY = Property.create(THREAD_GROUP_IDENTIFIER, THREAD_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey NAME_IDENTIFIER = new HiddenKey("name");
    protected static final Property NAME_PROPERTY = Property.create(NAME_IDENTIFIER, THREAD_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected ThreadLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createThreadShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new ThreadType(logicalClass, metaClass)).addProperty(THREAD_LOCALS_PROPERTY).addProperty(INTERRUPT_MODE_PROPERTY).addProperty(STATUS_PROPERTY).addProperty(OWNED_LOCKS_PROPERTY).addProperty(FIBER_MANAGER_PROPERTY).addProperty(FINISHED_LATCH_PROPERTY).addProperty(ABORT_ON_EXCEPTION_PROPERTY).addProperty(THREAD_PROPERTY).addProperty(EXCEPTION_PROPERTY).addProperty(VALUE_PROPERTY).addProperty(WAKE_UP_PROPERTY).addProperty(PRIORITY_PROPERTY).addProperty(THREAD_GROUP_PROPERTY).addProperty(NAME_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createThread(DynamicObjectFactory factory, DynamicObject threadLocals, InterruptMode interruptMode, ThreadStatus status, List<Lock> ownedLocks, FiberManager fiberManager, CountDownLatch finishedLatch, boolean abortOnException, Thread thread, DynamicObject exception, Object value, AtomicBoolean wakeUp, int priority, DynamicObject threadGroup, DynamicObject name) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsThread(factory));
        assert (factory.getShape().hasProperty(THREAD_LOCALS_IDENTIFIER));
        assert (factory.getShape().hasProperty(INTERRUPT_MODE_IDENTIFIER));
        assert (factory.getShape().hasProperty(STATUS_IDENTIFIER));
        assert (factory.getShape().hasProperty(OWNED_LOCKS_IDENTIFIER));
        assert (factory.getShape().hasProperty(FIBER_MANAGER_IDENTIFIER));
        assert (factory.getShape().hasProperty(FINISHED_LATCH_IDENTIFIER));
        assert (factory.getShape().hasProperty(ABORT_ON_EXCEPTION_IDENTIFIER));
        assert (factory.getShape().hasProperty(THREAD_IDENTIFIER));
        assert (factory.getShape().hasProperty(EXCEPTION_IDENTIFIER));
        assert (factory.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (factory.getShape().hasProperty(WAKE_UP_IDENTIFIER));
        assert (factory.getShape().hasProperty(PRIORITY_IDENTIFIER));
        assert (factory.getShape().hasProperty(THREAD_GROUP_IDENTIFIER));
        assert (factory.getShape().hasProperty(NAME_IDENTIFIER));
        assert (threadLocals != null);
        assert (interruptMode != null);
        assert (status != null);
        assert (ownedLocks != null);
        assert (finishedLatch != null);
        assert (wakeUp != null);
        assert (threadGroup != null);
        assert (name != null);
        return factory.newInstance(threadLocals, new AtomicReference<InterruptMode>(interruptMode), new AtomicReference<ThreadStatus>(status), ownedLocks, fiberManager, finishedLatch, abortOnException, new AtomicReference<Thread>(thread), new AtomicReference<DynamicObject>(exception), new AtomicReference<Object>(value), wakeUp, new AtomicInteger(priority), threadGroup, name);
    }

    @Override
    public boolean isThread(DynamicObject object) {
        return this.isThread(object.getShape().getObjectType());
    }

    @Override
    public boolean isThread(ObjectType objectType) {
        return objectType instanceof ThreadType;
    }

    private boolean createsThread(DynamicObjectFactory factory) {
        return this.isThread(factory.getShape().getObjectType());
    }

    @Override
    public DynamicObject getThreadLocals(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(THREAD_LOCALS_IDENTIFIER));
        return (DynamicObject)THREAD_LOCALS_PROPERTY.get(object, this.isThread(object));
    }

    @Override
    public InterruptMode getInterruptMode(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(INTERRUPT_MODE_IDENTIFIER));
        return (InterruptMode)((Object)((AtomicReference)INTERRUPT_MODE_PROPERTY.get(object, this.isThread(object))).get());
    }

    @Override
    public void setInterruptMode(DynamicObject object, InterruptMode value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(INTERRUPT_MODE_IDENTIFIER));
        assert (value != null);
        ((AtomicReference)INTERRUPT_MODE_PROPERTY.get(object, this.isThread(object))).set(value);
    }

    @Override
    public ThreadStatus getStatus(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(STATUS_IDENTIFIER));
        return (ThreadStatus)((Object)((AtomicReference)STATUS_PROPERTY.get(object, this.isThread(object))).get());
    }

    @Override
    public void setStatus(DynamicObject object, ThreadStatus value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(STATUS_IDENTIFIER));
        assert (value != null);
        ((AtomicReference)STATUS_PROPERTY.get(object, this.isThread(object))).set(value);
    }

    @Override
    public List<Lock> getOwnedLocks(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(OWNED_LOCKS_IDENTIFIER));
        return (List)OWNED_LOCKS_PROPERTY.get(object, this.isThread(object));
    }

    @Override
    public FiberManager getFiberManager(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(FIBER_MANAGER_IDENTIFIER));
        return (FiberManager)FIBER_MANAGER_PROPERTY.get(object, this.isThread(object));
    }

    @Override
    public void setFiberManagerUnsafe(DynamicObject object, FiberManager value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(FIBER_MANAGER_IDENTIFIER));
        FIBER_MANAGER_PROPERTY.setInternal(object, value);
    }

    @Override
    public CountDownLatch getFinishedLatch(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(FINISHED_LATCH_IDENTIFIER));
        return (CountDownLatch)FINISHED_LATCH_PROPERTY.get(object, this.isThread(object));
    }

    @Override
    public boolean getAbortOnException(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(ABORT_ON_EXCEPTION_IDENTIFIER));
        return (Boolean)ABORT_ON_EXCEPTION_PROPERTY.get(object, this.isThread(object));
    }

    @Override
    public void setAbortOnException(DynamicObject object, boolean value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(ABORT_ON_EXCEPTION_IDENTIFIER));
        try {
            ABORT_ON_EXCEPTION_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Thread getThread(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(THREAD_IDENTIFIER));
        return (Thread)((AtomicReference)THREAD_PROPERTY.get(object, this.isThread(object))).get();
    }

    @Override
    public void setThread(DynamicObject object, Thread value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(THREAD_IDENTIFIER));
        ((AtomicReference)THREAD_PROPERTY.get(object, this.isThread(object))).set(value);
    }

    @Override
    public DynamicObject getException(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(EXCEPTION_IDENTIFIER));
        return (DynamicObject)((AtomicReference)EXCEPTION_PROPERTY.get(object, this.isThread(object))).get();
    }

    @Override
    public void setException(DynamicObject object, DynamicObject value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(EXCEPTION_IDENTIFIER));
        ((AtomicReference)EXCEPTION_PROPERTY.get(object, this.isThread(object))).set(value);
    }

    @Override
    public Object getValue(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        return ((AtomicReference)VALUE_PROPERTY.get(object, this.isThread(object))).get();
    }

    @Override
    public void setValue(DynamicObject object, Object value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        ((AtomicReference)VALUE_PROPERTY.get(object, this.isThread(object))).set(value);
    }

    @Override
    public AtomicBoolean getWakeUp(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(WAKE_UP_IDENTIFIER));
        return (AtomicBoolean)WAKE_UP_PROPERTY.get(object, this.isThread(object));
    }

    @Override
    public int getPriority(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(PRIORITY_IDENTIFIER));
        return ((AtomicInteger)PRIORITY_PROPERTY.get(object, this.isThread(object))).get();
    }

    @Override
    public void setPriority(DynamicObject object, int value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(PRIORITY_IDENTIFIER));
        ((AtomicInteger)PRIORITY_PROPERTY.get(object, this.isThread(object))).set(value);
    }

    @Override
    public DynamicObject getThreadGroup(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(THREAD_GROUP_IDENTIFIER));
        return (DynamicObject)THREAD_GROUP_PROPERTY.get(object, this.isThread(object));
    }

    @Override
    public void setThreadGroup(DynamicObject object, DynamicObject value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(THREAD_GROUP_IDENTIFIER));
        assert (value != null);
        try {
            THREAD_GROUP_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public DynamicObject getName(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(NAME_IDENTIFIER));
        return (DynamicObject)NAME_PROPERTY.get(object, this.isThread(object));
    }

    @Override
    public void setName(DynamicObject object, DynamicObject value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty(NAME_IDENTIFIER));
        assert (value != null);
        try {
            NAME_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class ThreadType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ThreadType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ThreadType setLogicalClass(DynamicObject logicalClass) {
            return new ThreadType(logicalClass, this.metaClass);
        }

        @Override
        public ThreadType setMetaClass(DynamicObject metaClass) {
            return new ThreadType(this.logicalClass, metaClass);
        }
    }
}

