/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.gem.bcrypt;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.gem.bcrypt.BCrypt;

@CoreClass(value="Truffle::Gem::BCrypt")
public abstract class BCryptNodes {

    @CoreMethod(names={"gensalt"}, required=1, onSingleton=true, lowerFixnum={1})
    public static abstract class GenerateSalt
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object gensalt(int cost) {
            return StringOperations.createString(this.getContext(), StringOperations.encodeRope(BCrypt.gensalt(cost), USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT));
        }
    }

    @CoreMethod(names={"hashpw"}, required=2, onSingleton=true)
    public static abstract class HashPassword
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(secret)", "isRubyString(salt)"})
        public Object hashpw(DynamicObject secret, DynamicObject salt) {
            String result = BCrypt.hashpw(StringOperations.getString(secret), StringOperations.getString(salt));
            return StringOperations.createString(this.getContext(), StringOperations.encodeRope(result, USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT));
        }
    }
}

