#------------------------------------------------------------------------------
#
#  Copyright (c) 2005, Enthought, Inc.
#  All rights reserved.
#
#  This software is provided without warranty under the terms of the BSD
#  license included in enthought/LICENSE.txt and may be redistributed only
#  under the conditions described in the aforementioned license.  The license
#  is also available online at http://www.enthought.com/licenses/BSD.txt
#
#  Thanks for using Enthought open source!
#
#  Author: David C. Morrill
#  Date:   10/07/2004
#
#------------------------------------------------------------------------------

""" Exports the symbols defined by the traits.ui package.
"""

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------



from .basic_editor_factory import BasicEditorFactory

from .context_value import CV, CVFloat, CVInt, CVStr, CVType, ContextValue

from .editor import Editor

from .editor_factory import EditorFactory

try:
    from .editors.api import ArrayEditor
except ImportError:
    # ArrayEditor depends on numpy, so ignore if numpy is not present.
    pass

from .editors.api import (BooleanEditor, ButtonEditor,
    CheckListEditor, CodeEditor, ColorEditor, CompoundEditor, CustomEditor,
    CSVListEditor,
    DNDEditor, StyledDateEditor, DateEditor, DefaultOverride, DirectoryEditor, DropEditor,
    EnumEditor, FileEditor, FontEditor, HTMLEditor, HistoryEditor, ImageEditor,
    ImageEnumEditor, InstanceEditor, KeyBindingEditor, ListEditor,
    ListStrEditor, NullEditor, PopupEditor, ProgressEditor, RGBColorEditor,
    RangeEditor, ScrubberEditor, SearchEditor, SetEditor, ShellEditor,
    TableEditor, TabularEditor, TextEditor, TimeEditor, TitleEditor, TreeEditor,
    TupleEditor, ValueEditor)

from .group import (Group, HFlow, HGroup, HSplit, Tabbed, VFlow, VFold, VGrid,
    VGroup, VSplit)

from .handler import Controller, Handler, ModelView, ViewHandler, default_handler

from .help import on_help_call

from .help_template import help_template

from .include import Include

from .item import (Custom, Heading, Item, Label, Readonly, Spring, UCustom,
    UItem, UReadonly, spring)

from .menu import (Action, ActionGroup, ApplyButton, CancelButton, CloseAction,
    HelpAction, HelpButton, LiveButtons, Menu, MenuBar, ModalButtons, NoButton,
    NoButtons, OKButton, OKCancelButtons, PyFaceAction, RedoAction,
    RevertAction, RevertButton, Separator, StandardMenuBar, ToolBar, UndoAction,
    UndoButton)

from .message import auto_close_message, error, message

from .table_column import (ExpressionColumn, ListColumn, NumericColumn,
    ObjectColumn, TableColumn)

from .table_filter import (EvalTableFilter, MenuTableFilter, RuleTableFilter,
    TableFilter)

from .theme import Theme, default_theme

from .toolkit import toolkit

from .toolkit_traits import ColorTrait, FontTrait, RGBColorTrait

from .tree_node import (ITreeNode, ITreeNodeAdapter, MultiTreeNode,
    ObjectTreeNode, TreeNode, TreeNodeObject)

from .ui import UI

from .ui_info import UIInfo

from .ui_traits import (ATheme, Border, HasBorder, HasMargin, Image, Margin,
    StatusItem)

from .undo import (AbstractUndoItem, ListUndoItem, UndoHistory,
    UndoHistoryUndoItem, UndoItem)

from .view import View

from .view_element import ViewElement, ViewSubElement

from . import view_elements

_constants  = toolkit().constants()
WindowColor = _constants.get( 'WindowColor', 0xFFFFFF )


def raise_to_debug() :
    """ When we would otherwise silently swallow an exception, call this instead
    to allow people to set the TRAITS_DEBUG environment variable and get the
    exception.
    """
    import os
    if os.getenv('TRAITS_DEBUG') is not None : raise
