/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.StatusToXContent;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.suggest.Suggest;

public class SearchResponse
extends ActionResponse
implements StatusToXContent {
    private InternalSearchResponse internalResponse;
    private String scrollId;
    private int totalShards;
    private int successfulShards;
    private ShardSearchFailure[] shardFailures;
    private long tookInMillis;

    public SearchResponse() {
    }

    public SearchResponse(InternalSearchResponse internalResponse, String scrollId, int totalShards, int successfulShards, long tookInMillis, ShardSearchFailure[] shardFailures) {
        this.internalResponse = internalResponse;
        this.scrollId = scrollId;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.tookInMillis = tookInMillis;
        this.shardFailures = shardFailures;
    }

    @Override
    public RestStatus status() {
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures);
    }

    public SearchHits getHits() {
        return this.internalResponse.hits();
    }

    public Aggregations getAggregations() {
        return this.internalResponse.aggregations();
    }

    public Suggest getSuggest() {
        return this.internalResponse.suggest();
    }

    public boolean isTimedOut() {
        return this.internalResponse.timedOut();
    }

    public Boolean isTerminatedEarly() {
        return this.internalResponse.terminatedEarly();
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.shardFailures.length;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardFailures;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public void scrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    @Nullable
    public Map<String, ProfileShardResult> getProfileResults() {
        return this.internalResponse.profile();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.scrollId != null) {
            builder.field("_scroll_id", this.scrollId);
        }
        builder.field("took", this.tookInMillis);
        builder.field("timed_out", this.isTimedOut());
        if (this.isTerminatedEarly() != null) {
            builder.field("terminated_early", this.isTerminatedEarly());
        }
        RestActions.buildBroadcastShardsHeader(builder, params, this.getTotalShards(), this.getSuccessfulShards(), this.getFailedShards(), this.getShardFailures());
        this.internalResponse.toXContent(builder, params);
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.internalResponse = InternalSearchResponse.readInternalSearchResponse(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        int size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (int i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure(in);
            }
        }
        this.scrollId = in.readOptionalString();
        this.tookInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.internalResponse.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        out.writeOptionalString(this.scrollId);
        out.writeVLong(this.tookInMillis);
    }

    public String toString() {
        return Strings.toString(this, true);
    }

    static final class Fields {
        static final String _SCROLL_ID = "_scroll_id";
        static final String TOOK = "took";
        static final String TIMED_OUT = "timed_out";
        static final String TERMINATED_EARLY = "terminated_early";

        Fields() {
        }
    }
}

