/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RecentRelationsAction
extends JosmAction
implements ActionListener,
OsmDataLayer.CommandQueueListener {
    private final SideButton editButton;
    private final BasicArrowButton arrow;
    private final Shortcut shortcut;
    private final LaunchEditorAction launchAction;

    public RecentRelationsAction(SideButton sideButton) {
        super(RecentRelationsAction.class.getName(), null, null, null, false, true);
        this.editButton = sideButton;
        this.arrow = sideButton.createArrow(this);
        this.arrow.setToolTipText(I18n.tr("List of recent relations", new Object[0]));
        Main.main.undoRedo.addCommandQueueListener(this);
        this.enableArrow();
        this.shortcut = Shortcut.registerShortcut("relationeditor:editrecentrelation", I18n.tr("Relation Editor: {0}", I18n.tr("Open recent relation", new Object[0])), 27, 5005);
        this.launchAction = new LaunchEditorAction();
        Main.registerActionShortcut(this.launchAction, this.shortcut);
    }

    public void enableArrow() {
        if (this.arrow != null) {
            this.arrow.setVisible(RecentRelationsAction.getLastRelation() != null);
        }
    }

    public static Relation getLastRelation() {
        List<Relation> list = RecentRelationsAction.getRecentRelationsOnActiveLayer();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (Relation relation : list) {
            if (!RecentRelationsAction.isRelationListable(relation)) continue;
            return relation;
        }
        return null;
    }

    public static boolean isRelationListable(Relation relation) {
        return relation != null && !relation.isDeleted() && Main.getLayerManager().getEditDataSet().containsRelation(relation);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        RecentRelationsPopupMenu.launch(this.editButton, this.shortcut.getKeyStroke());
    }

    @Override
    public void commandChanged(int n, int n2) {
        this.enableArrow();
    }

    @Override
    protected void updateEnabledState() {
        this.enableArrow();
    }

    @Override
    public void destroy() {
        Main.unregisterActionShortcut(this.launchAction, this.shortcut);
        super.destroy();
    }

    public static List<Relation> getRecentRelationsOnActiveLayer() {
        if (!Main.isDisplayingMapView()) {
            return Collections.emptyList();
        }
        Layer layer = Main.getLayerManager().getActiveLayer();
        if (!(layer instanceof OsmDataLayer)) {
            return Collections.emptyList();
        }
        return ((OsmDataLayer)layer).getRecentRelations();
    }

    static class RecentRelationsMenuItem
    extends JMenuItem
    implements ActionListener {
        private final transient Relation relation;

        RecentRelationsMenuItem(Relation relation) {
            super(relation.getDisplayName(DefaultNameFormatter.getInstance()));
            this.relation = relation;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditRelationAction.launchEditor(this.relation);
        }
    }

    static class RecentRelationsPopupMenu
    extends JPopupMenu {
        RecentRelationsPopupMenu(List<Relation> list, KeyStroke keyStroke) {
            boolean bl = true;
            for (Relation relation : list) {
                if (!RecentRelationsAction.isRelationListable(relation)) continue;
                RecentRelationsMenuItem recentRelationsMenuItem = new RecentRelationsMenuItem(relation);
                if (bl) {
                    recentRelationsMenuItem.setAccelerator(keyStroke);
                    bl = false;
                }
                recentRelationsMenuItem.setIcon(ImageProvider.getPadded(relation, ImageProvider.ImageSizes.MENU.getImageDimension()));
                this.add(recentRelationsMenuItem);
            }
        }

        static void launch(Component component, KeyStroke keyStroke) {
            Rectangle rectangle = component.getBounds();
            new RecentRelationsPopupMenu(RecentRelationsAction.getRecentRelationsOnActiveLayer(), keyStroke).show(component, rectangle.x, rectangle.y + rectangle.height);
        }
    }

    static class LaunchEditorAction
    extends AbstractAction {
        LaunchEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditRelationAction.launchEditor(RecentRelationsAction.getLastRelation());
        }
    }
}

