/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitiveFlagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public final class DataSet
implements Data,
ProjectionChangeListener {
    private static final int MAX_SINGLE_EVENTS = 30;
    private static final int MAX_EVENTS = 1000;
    private final Storage<OsmPrimitive> allPrimitives = new Storage<PrimitiveId>(new Storage.PrimitiveIdHash(), true);
    private final Map<PrimitiveId, OsmPrimitive> primitivesMap = this.allPrimitives.foreignKey(new Storage.PrimitiveIdHash());
    private final CopyOnWriteArrayList<DataSetListener> listeners = new CopyOnWriteArrayList();
    private Collection<WaySegment> highlightedVirtualNodes = new LinkedList<WaySegment>();
    private Collection<WaySegment> highlightedWaySegments = new LinkedList<WaySegment>();
    private int updateCount;
    private final List<AbstractDatasetChangedEvent> cachedEvents = new ArrayList<AbstractDatasetChangedEvent>();
    private int highlightUpdateCount;
    private boolean uploadDiscouraged;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Object selectionLock = new Object();
    private Area cachedDataSourceArea;
    private List<Bounds> cachedDataSourceBounds;
    private final Collection<DataSource> dataSources = new LinkedList<DataSource>();
    private final LinkedList<Collection<? extends OsmPrimitive>> selectionHistory = new LinkedList();
    private AutoCompletionManager autocomplete;
    private String version;
    private final Map<String, String> changeSetTags = new HashMap<String, String>();
    private final QuadBuckets<Node> nodes = new QuadBuckets();
    private final QuadBuckets<Way> ways = new QuadBuckets();
    private final Collection<Relation> relations = new ArrayList<Relation>();
    private static final Collection<SelectionChangedListener> selListeners = new CopyOnWriteArrayList<SelectionChangedListener>();
    private Set<OsmPrimitive> selectedPrimitives = new LinkedHashSet<OsmPrimitive>();
    private Collection<OsmPrimitive> selectionSnapshot;

    public DataSet() {
        Main.addProjectionChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet(DataSet dataSet) {
        this();
        dataSet.getReadLock().lock();
        try {
            ArrayList<Node> arrayList;
            OsmPrimitive osmPrimitive;
            HashMap<OsmPrimitive, OsmPrimitive> hashMap = new HashMap<OsmPrimitive, OsmPrimitive>();
            for (Node object : dataSet.nodes) {
                osmPrimitive = new Node(object);
                hashMap.put(object, osmPrimitive);
                this.addPrimitive(osmPrimitive);
            }
            for (Way way : dataSet.ways) {
                osmPrimitive = new Way(way);
                hashMap.put(way, osmPrimitive);
                arrayList = new ArrayList<Node>();
                for (Node node : way.getNodes()) {
                    arrayList.add((Node)hashMap.get(node));
                }
                ((Way)osmPrimitive).setNodes(arrayList);
                this.addPrimitive(osmPrimitive);
            }
            for (Relation relation : dataSet.relations) {
                osmPrimitive = new Relation(relation, relation.isNew());
                ((Relation)osmPrimitive).setMembers(null);
                hashMap.put(relation, osmPrimitive);
                this.addPrimitive(osmPrimitive);
            }
            for (Relation relation : dataSet.relations) {
                osmPrimitive = (Relation)hashMap.get(relation);
                arrayList = new ArrayList();
                for (RelationMember relationMember : relation.getMembers()) {
                    arrayList.add((Node)((Object)new RelationMember(relationMember.getRole(), (OsmPrimitive)hashMap.get(relationMember.getMember()))));
                }
                ((Relation)osmPrimitive).setMembers(arrayList);
            }
            for (DataSource dataSource : dataSet.dataSources) {
                this.dataSources.add(new DataSource(dataSource));
            }
            this.version = dataSet.version;
        }
        finally {
            dataSet.getReadLock().unlock();
        }
    }

    public synchronized boolean addDataSource(DataSource dataSource) {
        return this.addDataSources(Collections.singleton(dataSource));
    }

    public synchronized boolean addDataSources(Collection<DataSource> collection) {
        boolean bl = this.dataSources.addAll(collection);
        if (bl) {
            this.cachedDataSourceArea = null;
            this.cachedDataSourceBounds = null;
        }
        return bl;
    }

    public Lock getReadLock() {
        return this.lock.readLock();
    }

    public int getHighlightUpdateCount() {
        return this.highlightUpdateCount;
    }

    public LinkedList<Collection<? extends OsmPrimitive>> getSelectionHistory() {
        return this.selectionHistory;
    }

    public void clearSelectionHistory() {
        this.selectionHistory.clear();
    }

    public AutoCompletionManager getAutoCompletionManager() {
        if (this.autocomplete == null) {
            this.autocomplete = new AutoCompletionManager(this);
            this.addDataSetListener(this.autocomplete);
        }
        return this.autocomplete;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public boolean isUploadDiscouraged() {
        return this.uploadDiscouraged;
    }

    public void setUploadDiscouraged(boolean bl) {
        this.uploadDiscouraged = bl;
    }

    public Map<String, String> getChangeSetTags() {
        return this.changeSetTags;
    }

    public void addChangeSetTag(String string, String string2) {
        this.changeSetTags.put(string, string2);
    }

    public <T extends OsmPrimitive> Collection<T> getPrimitives(Predicate<? super OsmPrimitive> predicate) {
        return new SubclassFilteredCollection(this.allPrimitives, predicate);
    }

    public Collection<Node> getNodes() {
        return this.getPrimitives(Node.class::isInstance);
    }

    public List<Node> searchNodes(BBox bBox) {
        this.lock.readLock().lock();
        try {
            List<Node> list = this.nodes.search(bBox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsNode(Node node) {
        return this.nodes.contains(node);
    }

    public Collection<Way> getWays() {
        return this.getPrimitives(Way.class::isInstance);
    }

    public List<Way> searchWays(BBox bBox) {
        this.lock.readLock().lock();
        try {
            List<Way> list = this.ways.search(bBox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsWay(Way way) {
        return this.ways.contains(way);
    }

    public Collection<Relation> getRelations() {
        return this.getPrimitives(Relation.class::isInstance);
    }

    public List<Relation> searchRelations(BBox bBox) {
        this.lock.readLock().lock();
        try {
            List<Relation> list = this.relations.stream().filter(relation -> relation.getBBox().intersects(bBox)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsRelation(Relation relation) {
        return this.relations.contains(relation);
    }

    public Collection<OsmPrimitive> allPrimitives() {
        return this.getPrimitives(osmPrimitive -> true);
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        return this.getPrimitives(osmPrimitive -> !osmPrimitive.isDeleted());
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        return this.getPrimitives(osmPrimitive -> !osmPrimitive.isDeleted() && !osmPrimitive.isIncomplete());
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        return this.getPrimitives(osmPrimitive -> !osmPrimitive.isDeleted() && !osmPrimitive.isIncomplete() && !(osmPrimitive instanceof Relation));
    }

    public Collection<OsmPrimitive> allModifiedPrimitives() {
        return this.getPrimitives(AbstractPrimitive::isModified);
    }

    public void addPrimitive(OsmPrimitive osmPrimitive) {
        Objects.requireNonNull(osmPrimitive, "primitive");
        this.beginUpdate();
        try {
            if (this.getPrimitiveById(osmPrimitive) != null) {
                throw new DataIntegrityProblemException(I18n.tr("Unable to add primitive {0} to the dataset because it is already included", osmPrimitive.toString()));
            }
            this.allPrimitives.add(osmPrimitive);
            osmPrimitive.setDataset(this);
            osmPrimitive.updatePosition();
            boolean bl = false;
            if (osmPrimitive instanceof Node) {
                bl = this.nodes.add((Node)osmPrimitive);
            } else if (osmPrimitive instanceof Way) {
                bl = this.ways.add((Way)osmPrimitive);
            } else if (osmPrimitive instanceof Relation) {
                bl = this.relations.add((Relation)osmPrimitive);
            }
            if (!bl) {
                throw new JosmRuntimeException("failed to add primitive: " + osmPrimitive);
            }
            this.firePrimitivesAdded(Collections.singletonList(osmPrimitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimitive(PrimitiveId primitiveId) {
        this.beginUpdate();
        try {
            OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
            if (osmPrimitive == null) {
                return;
            }
            boolean bl = false;
            if (osmPrimitive instanceof Node) {
                bl = this.nodes.remove(osmPrimitive);
            } else if (osmPrimitive instanceof Way) {
                bl = this.ways.remove(osmPrimitive);
            } else if (osmPrimitive instanceof Relation) {
                bl = this.relations.remove(osmPrimitive);
            }
            if (!bl) {
                throw new JosmRuntimeException("failed to remove primitive: " + osmPrimitive);
            }
            Object object = this.selectionLock;
            synchronized (object) {
                this.selectedPrimitives.remove(osmPrimitive);
                this.selectionSnapshot = null;
            }
            this.allPrimitives.remove(osmPrimitive);
            osmPrimitive.setDataset(null);
            this.firePrimitivesRemoved(Collections.singletonList(osmPrimitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    public static void addSelectionListener(SelectionChangedListener selectionChangedListener) {
        ((CopyOnWriteArrayList)selListeners).addIfAbsent(selectionChangedListener);
    }

    public static void removeSelectionListener(SelectionChangedListener selectionChangedListener) {
        selListeners.remove(selectionChangedListener);
    }

    public void fireSelectionChanged() {
        Collection<OsmPrimitive> collection = this.getAllSelected();
        for (SelectionChangedListener selectionChangedListener : selListeners) {
            selectionChangedListener.selectionChanged(collection);
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        return new SubclassFilteredCollection(this.getSelected(), osmPrimitive -> osmPrimitive instanceof Node || osmPrimitive instanceof Way);
    }

    public Collection<WaySegment> getHighlightedVirtualNodes() {
        return Collections.unmodifiableCollection(this.highlightedVirtualNodes);
    }

    public Collection<WaySegment> getHighlightedWaySegments() {
        return Collections.unmodifiableCollection(this.highlightedWaySegments);
    }

    public Collection<OsmPrimitive> getSelected() {
        return new SubclassFilteredCollection(this.getAllSelected(), osmPrimitive -> !osmPrimitive.isDeleted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OsmPrimitive> getAllSelected() {
        Collection<OsmPrimitive> collection;
        Object object = this.selectionLock;
        synchronized (object) {
            if (this.selectionSnapshot == null) {
                this.selectionSnapshot = Collections.unmodifiableList(new ArrayList<OsmPrimitive>(this.selectedPrimitives));
            }
            collection = this.selectionSnapshot;
        }
        return collection;
    }

    public Collection<Node> getSelectedNodes() {
        return new SubclassFilteredCollection(this.getSelected(), Node.class::isInstance);
    }

    public Collection<Way> getSelectedWays() {
        return new SubclassFilteredCollection(this.getSelected(), Way.class::isInstance);
    }

    public Collection<Relation> getSelectedRelations() {
        return new SubclassFilteredCollection(this.getSelected(), Relation.class::isInstance);
    }

    public boolean selectionEmpty() {
        return this.selectedPrimitives.isEmpty();
    }

    public boolean isSelected(OsmPrimitive osmPrimitive) {
        return this.selectedPrimitives.contains(osmPrimitive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleSelected(Collection<? extends PrimitiveId> collection) {
        boolean bl = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : collection) {
                bl |= this.dotoggleSelected(primitiveId);
            }
            if (bl) {
                this.selectionSnapshot = null;
            }
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    public void toggleSelected(PrimitiveId ... primitiveIdArray) {
        this.toggleSelected(Arrays.asList(primitiveIdArray));
    }

    private boolean dotoggleSelected(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
        if (osmPrimitive == null) {
            return false;
        }
        if (!this.selectedPrimitives.remove(osmPrimitive)) {
            this.selectedPrimitives.add(osmPrimitive);
        }
        this.selectionSnapshot = null;
        return true;
    }

    public void setHighlightedVirtualNodes(Collection<WaySegment> collection) {
        if (this.highlightedVirtualNodes.isEmpty() && collection.isEmpty()) {
            return;
        }
        this.highlightedVirtualNodes = collection;
        this.fireHighlightingChanged();
    }

    public void setHighlightedWaySegments(Collection<WaySegment> collection) {
        if (this.highlightedWaySegments.isEmpty() && collection.isEmpty()) {
            return;
        }
        this.highlightedWaySegments = collection;
        this.fireHighlightingChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(Collection<? extends PrimitiveId> collection, boolean bl) {
        boolean bl2;
        Object object = this.selectionLock;
        synchronized (object) {
            LinkedHashSet<OsmPrimitive> linkedHashSet = new LinkedHashSet<OsmPrimitive>(this.selectedPrimitives);
            this.selectedPrimitives = new LinkedHashSet<OsmPrimitive>();
            this.addSelected(collection, false);
            boolean bl3 = bl2 = !linkedHashSet.equals(this.selectedPrimitives);
            if (bl2) {
                this.selectionSnapshot = null;
            }
        }
        if (bl2 && bl) {
            this.fireSelectionChanged();
        }
    }

    public void setSelected(Collection<? extends PrimitiveId> collection) {
        this.setSelected(collection, true);
    }

    public void setSelected(PrimitiveId ... primitiveIdArray) {
        if (primitiveIdArray.length == 1 && primitiveIdArray[0] == null) {
            this.setSelected(new PrimitiveId[0]);
            return;
        }
        List<PrimitiveId> list = Arrays.asList(primitiveIdArray);
        this.setSelected(list);
    }

    public void addSelected(Collection<? extends PrimitiveId> collection) {
        this.addSelected(collection, true);
    }

    public void addSelected(PrimitiveId ... primitiveIdArray) {
        this.addSelected(Arrays.asList(primitiveIdArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSelected(Collection<? extends PrimitiveId> collection, boolean bl) {
        boolean bl2 = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : collection) {
                OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
                if (osmPrimitive == null) continue;
                bl2 |= this.selectedPrimitives.add(osmPrimitive);
            }
            if (bl2) {
                this.selectionSnapshot = null;
            }
        }
        if (bl && bl2) {
            this.fireSelectionChanged();
        }
        return bl2;
    }

    public void clearHighlightedVirtualNodes() {
        this.setHighlightedVirtualNodes(new ArrayList<WaySegment>());
    }

    public void clearHighlightedWaySegments() {
        this.setHighlightedWaySegments(new ArrayList<WaySegment>());
    }

    public void clearSelection(PrimitiveId ... primitiveIdArray) {
        this.clearSelection(Arrays.asList(primitiveIdArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection(Collection<? extends PrimitiveId> collection) {
        boolean bl = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : collection) {
                OsmPrimitive osmPrimitive = this.getPrimitiveById(primitiveId);
                if (osmPrimitive == null) continue;
                bl |= this.selectedPrimitives.remove(osmPrimitive);
            }
            if (bl) {
                this.selectionSnapshot = null;
            }
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        if (!this.selectedPrimitives.isEmpty()) {
            Object object = this.selectionLock;
            synchronized (object) {
                this.selectedPrimitives.clear();
                this.selectionSnapshot = null;
            }
            this.fireSelectionChanged();
        }
    }

    @Override
    public synchronized Area getDataSourceArea() {
        if (this.cachedDataSourceArea == null) {
            this.cachedDataSourceArea = Data.super.getDataSourceArea();
        }
        return this.cachedDataSourceArea;
    }

    @Override
    public synchronized List<Bounds> getDataSourceBounds() {
        if (this.cachedDataSourceBounds == null) {
            this.cachedDataSourceBounds = Data.super.getDataSourceBounds();
        }
        return Collections.unmodifiableList(this.cachedDataSourceBounds);
    }

    @Override
    public synchronized Collection<DataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.dataSources);
    }

    public OsmPrimitive getPrimitiveById(long l, OsmPrimitiveType osmPrimitiveType) {
        return this.getPrimitiveById(new SimplePrimitiveId(l, osmPrimitiveType));
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId) {
        return primitiveId != null ? this.primitivesMap.get(primitiveId) : null;
    }

    private OsmPrimitive getPrimitiveByIdChecked(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.getPrimitiveById(primitiveId);
        if (osmPrimitive == null && primitiveId != null) {
            Main.warn(I18n.tr("JOSM expected to find primitive [{0} {1}] in dataset but it is not there. Please report this at {2}. This is not a critical error, it should be safe to continue in your work.", new Object[]{primitiveId.getType(), Long.toString(primitiveId.getUniqueId()), Main.getJOSMWebsite()}));
            Main.error(new Exception());
        }
        return osmPrimitive;
    }

    private static void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Way> unlinkNodeFromWays(Node node) {
        HashSet<Way> hashSet = new HashSet<Way>();
        this.beginUpdate();
        try {
            for (Way way : OsmPrimitive.getFilteredList(node.getReferrers(), Way.class)) {
                List<Node> list = way.getNodes();
                if (!list.remove(node)) continue;
                if (list.size() < 2) {
                    DataSet.deleteWay(way);
                } else {
                    way.setNodes(list);
                }
                hashSet.add(way);
            }
        }
        finally {
            this.endUpdate();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Relation> unlinkPrimitiveFromRelations(OsmPrimitive osmPrimitive) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        this.beginUpdate();
        try {
            for (Relation relation : this.relations) {
                List<RelationMember> list = relation.getMembers();
                Iterator<RelationMember> iterator = list.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    RelationMember relationMember = iterator.next();
                    if (!relationMember.getMember().equals(osmPrimitive)) continue;
                    iterator.remove();
                    bl = true;
                }
                if (!bl) continue;
                relation.setMembers(list);
                hashSet.add(relation);
            }
        }
        finally {
            this.endUpdate();
        }
        return hashSet;
    }

    public Set<OsmPrimitive> unlinkReferencesToPrimitive(OsmPrimitive osmPrimitive) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        this.beginUpdate();
        try {
            if (osmPrimitive instanceof Node) {
                hashSet.addAll(this.unlinkNodeFromWays((Node)osmPrimitive));
            }
            hashSet.addAll(this.unlinkPrimitiveFromRelations(osmPrimitive));
        }
        finally {
            this.endUpdate();
        }
        return hashSet;
    }

    public boolean isModified() {
        for (OsmPrimitive osmPrimitive : this.allPrimitives) {
            if (!osmPrimitive.isModified()) continue;
            return true;
        }
        return false;
    }

    private void reindexNode(Node node, LatLon latLon, EastNorth eastNorth) {
        if (!this.nodes.remove(node)) {
            throw new JosmRuntimeException("Reindexing node failed to remove");
        }
        node.setCoorInternal(latLon, eastNorth);
        if (!this.nodes.add(node)) {
            throw new JosmRuntimeException("Reindexing node failed to add");
        }
        for (OsmPrimitive osmPrimitive : node.getReferrers()) {
            if (osmPrimitive instanceof Way) {
                this.reindexWay((Way)osmPrimitive);
                continue;
            }
            DataSet.reindexRelation((Relation)osmPrimitive);
        }
    }

    private void reindexWay(Way way) {
        BBox bBox = way.getBBox();
        if (!this.ways.remove(way)) {
            throw new JosmRuntimeException("Reindexing way failed to remove");
        }
        way.updatePosition();
        if (!this.ways.add(way)) {
            throw new JosmRuntimeException("Reindexing way failed to add");
        }
        if (!way.getBBox().equals(bBox)) {
            for (OsmPrimitive osmPrimitive : way.getReferrers()) {
                DataSet.reindexRelation((Relation)osmPrimitive);
            }
        }
    }

    private static void reindexRelation(Relation relation) {
        BBox bBox = relation.getBBox();
        relation.updatePosition();
        if (!bBox.equals(relation.getBBox())) {
            for (OsmPrimitive osmPrimitive : relation.getReferrers()) {
                DataSet.reindexRelation((Relation)osmPrimitive);
            }
        }
    }

    public void addDataSetListener(DataSetListener dataSetListener) {
        this.listeners.addIfAbsent(dataSetListener);
    }

    public void removeDataSetListener(DataSetListener dataSetListener) {
        this.listeners.remove(dataSetListener);
    }

    public void beginUpdate() {
        this.lock.writeLock().lock();
        ++this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            List<AbstractDatasetChangedEvent> list = Collections.emptyList();
            if (this.updateCount == 0) {
                list = new ArrayList<AbstractDatasetChangedEvent>(this.cachedEvents);
                this.cachedEvents.clear();
            }
            if (!list.isEmpty()) {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
                try {
                    if (list.size() < 30) {
                        for (AbstractDatasetChangedEvent abstractDatasetChangedEvent : list) {
                            this.fireEventToListeners(abstractDatasetChangedEvent);
                        }
                    }
                    if (list.size() == 1000) {
                        this.fireEventToListeners(new DataChangedEvent(this));
                    }
                    this.fireEventToListeners(new DataChangedEvent(this, list));
                }
                finally {
                    this.lock.readLock().unlock();
                }
            } else {
                this.lock.writeLock().unlock();
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }

    private void fireEventToListeners(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        for (DataSetListener dataSetListener : this.listeners) {
            abstractDatasetChangedEvent.fire(dataSetListener);
        }
    }

    private void fireEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        if (this.updateCount == 0) {
            throw new AssertionError((Object)"dataset events can be fired only when dataset is locked");
        }
        if (this.cachedEvents.size() < 1000) {
            this.cachedEvents.add(abstractDatasetChangedEvent);
        }
    }

    void firePrimitivesAdded(Collection<? extends OsmPrimitive> collection, boolean bl) {
        this.fireEvent(new PrimitivesAddedEvent(this, collection, bl));
    }

    void firePrimitivesRemoved(Collection<? extends OsmPrimitive> collection, boolean bl) {
        this.fireEvent(new PrimitivesRemovedEvent(this, collection, bl));
    }

    void fireTagsChanged(OsmPrimitive osmPrimitive, Map<String, String> map) {
        this.fireEvent(new TagsChangedEvent(this, osmPrimitive, map));
    }

    void fireRelationMembersChanged(Relation relation) {
        DataSet.reindexRelation(relation);
        this.fireEvent(new RelationMembersChangedEvent(this, relation));
    }

    void fireNodeMoved(Node node, LatLon latLon, EastNorth eastNorth) {
        this.reindexNode(node, latLon, eastNorth);
        this.fireEvent(new NodeMovedEvent(this, node));
    }

    void fireWayNodesChanged(Way way) {
        this.reindexWay(way);
        this.fireEvent(new WayNodesChangedEvent(this, way));
    }

    void fireChangesetIdChanged(OsmPrimitive osmPrimitive, int n, int n2) {
        this.fireEvent(new ChangesetIdChangedEvent(this, Collections.singletonList(osmPrimitive), n, n2));
    }

    void firePrimitiveFlagsChanged(OsmPrimitive osmPrimitive) {
        this.fireEvent(new PrimitiveFlagsChangedEvent(this, osmPrimitive));
    }

    void fireHighlightingChanged() {
        ++this.highlightUpdateCount;
    }

    public void invalidateEastNorthCache() {
        if (Main.getProjection() == null) {
            return;
        }
        try {
            this.beginUpdate();
            for (Node node : Utils.filteredCollection(this.allPrimitives, Node.class)) {
                node.invalidateEastNorthCache();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void cleanupDeletedPrimitives() {
        this.beginUpdate();
        try {
            boolean bl = this.cleanupDeleted(this.nodes.iterator());
            if (this.cleanupDeleted(this.ways.iterator())) {
                bl = true;
            }
            if (this.cleanupDeleted(this.relations.iterator())) {
                bl = true;
            }
            if (bl) {
                this.fireSelectionChanged();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupDeleted(Iterator<? extends OsmPrimitive> iterator) {
        boolean bl = false;
        Object object = this.selectionLock;
        synchronized (object) {
            while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive = iterator.next();
                if (!osmPrimitive.isDeleted() || osmPrimitive.isVisible() && !osmPrimitive.isNew()) continue;
                this.selectedPrimitives.remove(osmPrimitive);
                this.selectionSnapshot = null;
                this.allPrimitives.remove(osmPrimitive);
                osmPrimitive.setDataset(null);
                bl = true;
                iterator.remove();
            }
            if (bl) {
                this.selectionSnapshot = null;
            }
        }
        return bl;
    }

    public void clear() {
        this.beginUpdate();
        try {
            this.clearSelection();
            for (OsmPrimitive osmPrimitive : this.allPrimitives) {
                osmPrimitive.setDataset(null);
            }
            this.nodes.clear();
            this.ways.clear();
            this.relations.clear();
            this.allPrimitives.clear();
        }
        finally {
            this.endUpdate();
        }
    }

    public void deleteInvisible() {
        for (OsmPrimitive osmPrimitive : this.allPrimitives) {
            if (osmPrimitive.isVisible()) continue;
            osmPrimitive.setDeleted(true);
        }
    }

    public void mergeFrom(DataSet dataSet) {
        this.mergeFrom(dataSet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mergeFrom(DataSet dataSet, ProgressMonitor progressMonitor) {
        if (dataSet != null) {
            new DataSetMerger(this, dataSet).merge(progressMonitor);
            DataSet dataSet2 = dataSet;
            synchronized (dataSet2) {
                if (!dataSet.dataSources.isEmpty()) {
                    if (this.dataSources.addAll(dataSet.dataSources)) {
                        this.cachedDataSourceArea = null;
                        this.cachedDataSourceBounds = null;
                    }
                    dataSet.dataSources.clear();
                    dataSet.cachedDataSourceArea = null;
                    dataSet.cachedDataSourceBounds = null;
                }
            }
        }
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        this.invalidateEastNorthCache();
    }

    public synchronized ProjectionBounds getDataSourceBoundingBox() {
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        for (DataSource dataSource : this.dataSources) {
            boundingXYVisitor.visit(dataSource.bounds);
        }
        if (boundingXYVisitor.hasExtend()) {
            return boundingXYVisitor.getBounds();
        }
        return null;
    }
}

