/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.ArrowPaintHelper;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.RenderBenchmarkCollector;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.BoxTextElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.RepeatImageElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.Symbol;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.tools.CompositeList;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class StyledMapRenderer
extends AbstractMapRenderer {
    private static final ForkJoinPool THREAD_POOL = Utils.newForkJoinPool("mappaint.StyledMapRenderer.style_creation.numberOfThreads", "styled-map-renderer-%d", 5);
    private static Map<Font, Boolean> IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG = new HashMap<Font, Boolean>();
    private double circum;
    private double scale;
    private MapPaintSettings paintSettings;
    private Color highlightColorTransparent;
    private static final int FLAG_NORMAL = 0;
    private static final int FLAG_DISABLED = 1;
    private static final int FLAG_MEMBER_OF_SELECTED = 2;
    private static final int FLAG_SELECTED = 4;
    private static final int FLAG_OUTERMEMBER_OF_SELECTED = 8;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);
    private Collection<WaySegment> highlightWaySegments;
    private int highlightLineWidth;
    private int highlightPointRadius;
    private int widerHighlight;
    private int highlightStep;
    private boolean useWiderHighlight;
    private boolean useStrokes;
    private boolean showNames;
    private boolean showIcons;
    private boolean isOutlineOnly;
    private Font orderFont;
    private boolean leftHandTraffic;
    private Object antialiasing;
    private Supplier<RenderBenchmarkCollector> benchmarkFactory = RenderBenchmarkCollector.defaultBenchmarkSupplier();

    public static boolean isGlyphVectorDoubleTranslationBug(Font font) {
        Boolean bl = IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.get(font);
        if (bl != null) {
            return bl;
        }
        String string = Main.pref.get("glyph-bug", "auto");
        if ("auto".equals(string)) {
            int n;
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, "x");
            glyphVector.setGlyphTransform(0, AffineTransform.getTranslateInstance(1000.0, 1000.0));
            Shape shape = glyphVector.getGlyphOutline(0);
            if (Main.isTraceEnabled()) {
                Main.trace("#10446: shape: " + shape.getBounds());
            }
            boolean bl2 = (n = shape.getBounds().x) > 1500;
            IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.put(font, bl2);
            return bl2;
        }
        boolean bl3 = Boolean.parseBoolean(string);
        IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.put(font, bl3);
        return bl3;
    }

    public StyledMapRenderer(Graphics2D graphics2D, NavigatableComponent navigatableComponent, boolean bl) {
        super(graphics2D, navigatableComponent, bl);
        if (navigatableComponent != null) {
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            this.useWiderHighlight = !(component instanceof AbstractButton) && component != navigatableComponent;
        }
    }

    private void displaySegments(MapViewPath mapViewPath, Path2D path2D, Path2D path2D2, Path2D path2D3, Color color, BasicStroke basicStroke, BasicStroke basicStroke2, Color color2) {
        this.g.setColor(this.isInactiveMode ? this.inactiveColor : color);
        if (this.useStrokes) {
            this.g.setStroke(basicStroke);
        }
        this.g.draw(mapViewPath.computeClippedLine(this.g.getStroke()));
        if (!this.isInactiveMode && this.useStrokes && basicStroke2 != null) {
            this.g.setColor(color2);
            this.g.setStroke(basicStroke2);
            this.g.draw(mapViewPath.computeClippedLine(basicStroke2));
        }
        if (path2D != null) {
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : color);
            this.g.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), 0, basicStroke.getMiterLimit()));
            this.g.draw(path2D);
        }
        if (path2D2 != null) {
            this.g.setStroke(new BasicStroke(1.0f, basicStroke.getEndCap(), 0, basicStroke.getMiterLimit()));
            this.g.fill(path2D3);
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : this.backgroundColor);
            this.g.fill(path2D2);
        }
        if (this.useStrokes) {
            this.g.setStroke(new BasicStroke());
        }
    }

    private void displayText(GlyphVector glyphVector, String string, int n, int n2, boolean bl, TextLabel textLabel) {
        if (glyphVector == null && string.isEmpty()) {
            return;
        }
        if (this.isInactiveMode || bl) {
            this.g.setColor(this.inactiveColor);
            if (glyphVector != null) {
                this.g.drawGlyphVector(glyphVector, n, n2);
            } else {
                this.g.setFont(textLabel.font);
                this.g.drawString(string, n, n2);
            }
        } else if (textLabel.haloRadius != null) {
            Shape shape;
            this.g.setStroke(new BasicStroke(2.0f * textLabel.haloRadius.floatValue(), 0, 1));
            this.g.setColor(textLabel.haloColor);
            if (glyphVector == null) {
                FontRenderContext fontRenderContext = this.g.getFontRenderContext();
                TextLayout textLayout = new TextLayout(string, textLabel.font, fontRenderContext);
                shape = textLayout.getOutline(AffineTransform.getTranslateInstance(n, n2));
            } else {
                shape = glyphVector.getOutline(n, n2);
            }
            this.g.draw(shape);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(textLabel.color);
            this.g.fill(shape);
        } else {
            this.g.setColor(textLabel.color);
            if (glyphVector != null) {
                this.g.drawGlyphVector(glyphVector, n, n2);
            } else {
                this.g.setFont(textLabel.font);
                this.g.drawString(string, n, n2);
            }
        }
    }

    protected void drawArea(OsmPrimitive osmPrimitive, Path2D.Double double_, Color color, MapImage mapImage, Float f, Path2D.Double double_2, boolean bl, TextLabel textLabel) {
        Shape shape = double_.createTransformedShape(this.mapState.getAffineTransform());
        if (!this.isOutlineOnly) {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (mapImage == null) {
                if (this.isInactiveMode) {
                    this.g.setComposite(AlphaComposite.getInstance(3, 0.33f));
                }
                this.g.setColor(color);
                if (f == null) {
                    this.g.fill(shape);
                } else {
                    Shape shape2 = this.g.getClip();
                    Shape shape3 = shape;
                    if (double_2 != null) {
                        shape3 = double_2.createTransformedShape(this.mapState.getAffineTransform());
                    }
                    this.g.clip(shape3);
                    this.g.setStroke(new BasicStroke(2.0f * f.floatValue(), 0, 0, 4.0f));
                    this.g.draw(shape);
                    this.g.setClip(shape2);
                }
            } else {
                TexturePaint texturePaint = new TexturePaint(mapImage.getImage(bl), new Rectangle(0, 0, mapImage.getWidth(), mapImage.getHeight()));
                this.g.setPaint(texturePaint);
                Float f2 = Float.valueOf(mapImage.getAlphaFloat());
                if (!Utils.equalsEpsilon(f2.floatValue(), 1.0)) {
                    this.g.setComposite(AlphaComposite.getInstance(3, f2.floatValue()));
                }
                if (f == null) {
                    this.g.fill(shape);
                } else {
                    Shape shape4 = this.g.getClip();
                    BasicStroke basicStroke = new BasicStroke(2.0f * f.floatValue(), 0, 0);
                    this.g.clip(basicStroke.createStrokedShape(shape));
                    Shape shape5 = shape;
                    if (double_2 != null) {
                        shape5 = double_2.createTransformedShape(this.mapState.getAffineTransform());
                    }
                    this.g.fill(shape5);
                    this.g.setClip(shape4);
                }
                this.g.setPaintMode();
            }
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing);
        }
        this.drawAreaText(osmPrimitive, textLabel, shape);
    }

    private void drawAreaText(OsmPrimitive osmPrimitive, TextLabel textLabel, Shape shape) {
        if (textLabel != null && this.isShowNames()) {
            if (textLabel.labelCompositionStrategy == null) {
                return;
            }
            String string = textLabel.labelCompositionStrategy.compose(osmPrimitive);
            if (string == null) {
                return;
            }
            Rectangle rectangle = shape.getBounds();
            FontMetrics fontMetrics = this.g.getFontMetrics(this.orderFont);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.g);
            if ((double)rectangle.width >= rectangle2D.getWidth() && (double)rectangle.height >= rectangle2D.getHeight()) {
                int n;
                int n2;
                int n3;
                int n4;
                double d;
                int n5;
                double d2 = (double)rectangle.width - rectangle2D.getWidth();
                int n6 = rectangle.x + (int)(d2 / 2.0);
                Rectangle rectangle2 = new Rectangle(n6, n5 = rectangle.y + (int)((d = (double)rectangle.height - rectangle2D.getHeight()) / 2.0), n4 = (int)rectangle2D.getWidth(), n3 = (int)rectangle2D.getHeight());
                boolean bl = shape.contains(rectangle2);
                if (!bl) {
                    int n7 = rectangle.x + (int)(d2 / 4.0);
                    n2 = rectangle.x + (int)(3.0 * d2 / 4.0);
                    n = rectangle.y + (int)(d / 4.0);
                    int n8 = rectangle.y + (int)(3.0 * d / 4.0);
                    Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n6, n, n4, n3), new Rectangle(n2, n5, n4, n3), new Rectangle(n6, n8, n4, n3), new Rectangle(n7, n5, n4, n3), new Rectangle(n7, n, n4, n3), new Rectangle(n2, n, n4, n3), new Rectangle(n2, n8, n4, n3), new Rectangle(n7, n8, n4, n3)};
                    for (int i = 0; i < rectangleArray.length && !bl; ++i) {
                        rectangle2 = rectangleArray[i];
                        bl = shape.contains(rectangle2);
                    }
                }
                if (bl) {
                    Font font = this.g.getFont();
                    n2 = (int)(rectangle2.getMinX() - rectangle2D.getMinX());
                    n = (int)(rectangle2.getMinY() - rectangle2D.getMinY());
                    this.displayText(null, string, n2, n, osmPrimitive.isDisabled(), textLabel);
                    this.g.setFont(font);
                } else if (Main.isTraceEnabled()) {
                    Main.trace("Couldn't find a correct label placement for " + osmPrimitive + " / " + string);
                }
            }
        }
    }

    public void drawArea(Relation relation, Color color, MapImage mapImage, Float f, Float f2, boolean bl, TextLabel textLabel) {
        Multipolygon multipolygon = MultipolygonCache.getInstance().get(this.nc, relation);
        if (!relation.isDisabled() && !multipolygon.getOuterWays().isEmpty()) {
            for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
                Path2D.Double double_ = polyData.get();
                Path2D.Double double_2 = null;
                if (!this.isAreaVisible(double_)) continue;
                if (f != null) {
                    if (!this.usePartialFill(polyData.getAreaAndPerimeter(null), f.floatValue(), f2)) {
                        f = null;
                    } else if (!polyData.isClosed()) {
                        double_2 = StyledMapRenderer.getPFClip(polyData, (double)f.floatValue() * this.scale);
                    }
                }
                this.drawArea(relation, double_, polyData.isSelected() ? this.paintSettings.getRelationSelectedColor(color.getAlpha()) : color, mapImage, f, double_2, bl, textLabel);
            }
        }
    }

    public void drawArea(Way way, Color color, MapImage mapImage, Float f, Float f2, boolean bl, TextLabel textLabel) {
        Path2D.Double double_ = null;
        if (f != null) {
            if (!this.usePartialFill(Geometry.getAreaAndPerimeter(way.getNodes()), f.floatValue(), f2)) {
                f = null;
            } else if (!way.isClosed()) {
                double_ = StyledMapRenderer.getPFClip(way, (double)f.floatValue() * this.scale);
            }
        }
        this.drawArea(way, StyledMapRenderer.getPath(way), color, mapImage, f, double_, bl, textLabel);
    }

    private boolean usePartialFill(Geometry.AreaAndPerimeter areaAndPerimeter, float f, Float f2) {
        if (f2 == null) {
            return true;
        }
        return areaAndPerimeter.getPerimeter() * (double)f * this.scale < (double)f2.floatValue() * areaAndPerimeter.getArea();
    }

    public void drawBoxText(Node node, BoxTextElement boxTextElement) {
        Object object;
        FontRenderContext fontRenderContext;
        if (!this.isShowNames() || boxTextElement == null) {
            return;
        }
        MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(node);
        TextLabel textLabel = boxTextElement.text;
        String string = textLabel.labelCompositionStrategy.compose(node);
        if (string == null) {
            return;
        }
        Font font = this.g.getFont();
        this.g.setFont(textLabel.font);
        int n = (int)(Math.round(mapViewPoint.getInViewX()) + (long)textLabel.xOffset);
        int n2 = (int)(Math.round(mapViewPoint.getInViewY()) + (long)textLabel.yOffset);
        Rectangle rectangle = boxTextElement.getBox();
        if (boxTextElement.hAlign == BoxTextElement.HorizontalTextAlignment.RIGHT) {
            n += rectangle.x + rectangle.width + 2;
        } else {
            fontRenderContext = this.g.getFontRenderContext();
            object = textLabel.font.getStringBounds(string, fontRenderContext);
            int n3 = (int)((RectangularShape)object).getWidth();
            if (boxTextElement.hAlign == BoxTextElement.HorizontalTextAlignment.CENTER) {
                n -= n3 / 2;
            } else if (boxTextElement.hAlign == BoxTextElement.HorizontalTextAlignment.LEFT) {
                n -= -rectangle.x + 4 + n3;
            } else {
                throw new AssertionError();
            }
        }
        if (boxTextElement.vAlign == BoxTextElement.VerticalTextAlignment.BOTTOM) {
            n2 += rectangle.y + rectangle.height;
        } else {
            fontRenderContext = this.g.getFontRenderContext();
            object = textLabel.font.getLineMetrics(string, fontRenderContext);
            if (boxTextElement.vAlign == BoxTextElement.VerticalTextAlignment.ABOVE) {
                n2 -= -rectangle.y + (int)((LineMetrics)object).getDescent();
            } else if (boxTextElement.vAlign == BoxTextElement.VerticalTextAlignment.TOP) {
                n2 -= -rectangle.y - (int)((LineMetrics)object).getAscent();
            } else if (boxTextElement.vAlign == BoxTextElement.VerticalTextAlignment.CENTER) {
                n2 += (int)((((LineMetrics)object).getAscent() - ((LineMetrics)object).getDescent()) / 2.0f);
            } else if (boxTextElement.vAlign == BoxTextElement.VerticalTextAlignment.BELOW) {
                n2 += rectangle.y + rectangle.height + (int)((LineMetrics)object).getAscent() + 2;
            } else {
                throw new AssertionError();
            }
        }
        this.displayText(null, string, n, n2, node.isDisabled(), textLabel);
        this.g.setFont(font);
    }

    public void drawRepeatImage(Way way, MapImage mapImage, boolean bl2, double d, double d3, double d4, RepeatImageElement.LineImageAlignment lineImageAlignment) {
        int n = mapImage.getWidth();
        double d5 = (double)n + d3;
        int n2 = mapImage.getHeight();
        int n3 = (int)((lineImageAlignment.getAlignmentOffset() - 0.5) * (double)n2);
        int n4 = n3 + n2;
        OffsetIterator offsetIterator = new OffsetIterator(way.getNodes(), d);
        MapViewPath mapViewPath = new MapViewPath(this.mapState);
        if (offsetIterator.hasNext()) {
            mapViewPath.moveTo(offsetIterator.next());
        }
        while (offsetIterator.hasNext()) {
            mapViewPath.lineTo(offsetIterator.next());
        }
        double d6 = d4 % d5;
        if (d6 < 0.0) {
            d6 += d5;
        }
        BufferedImage bufferedImage = mapImage.getImage(bl2);
        mapViewPath.visitClippedLine(d6, d5, (d2, mapViewPoint, mapViewPoint2, bl) -> {
            double d3 = mapViewPoint.distanceToInView(mapViewPoint2);
            if (d3 < 0.1) {
                return;
            }
            if (d3 > d5 * 500.0) {
                return;
            }
            AffineTransform affineTransform = this.g.getTransform();
            this.g.translate(mapViewPoint.getInViewX(), mapViewPoint.getInViewY());
            double d4 = mapViewPoint2.getInViewX() - mapViewPoint.getInViewX();
            double d5 = mapViewPoint2.getInViewY() - mapViewPoint.getInViewY();
            this.g.rotate(Math.atan2(d5, d4));
            for (double d6 = -(d2 % d5); d6 < d3; d6 += d5) {
                int n5 = (int)d6;
                int n6 = Math.max(0, -n5);
                int n7 = n - Math.max(0, n5 + n - (int)Math.ceil(d3));
                this.g.drawImage(bufferedImage, n5 + n6, n3, n5 + n7, n4, n6, 0, n7, n2, null);
            }
            this.g.setTransform(affineTransform);
        });
    }

    @Override
    public void drawNode(Node node, Color color, int n, boolean bl) {
        if (n <= 0 && !node.isHighlighted()) {
            return;
        }
        MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(node);
        if (node.isHighlighted()) {
            this.drawPointHighlight(mapViewPoint.getInView(), n);
        }
        if (n > 1 && mapViewPoint.isInView()) {
            int n2 = n / 2;
            if (this.isInactiveMode || node.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(color);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(mapViewPoint.getInViewX() - (double)n2 - 1.0, mapViewPoint.getInViewY() - (double)n2 - 1.0, n + 1, n + 1);
            if (bl) {
                this.g.fill(double_);
            } else {
                this.g.draw(double_);
            }
        }
    }

    public void drawNodeIcon(Node node, MapImage mapImage, boolean bl, boolean bl2, boolean bl3, double d) {
        MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(node);
        int n = mapImage.getWidth();
        int n2 = mapImage.getHeight();
        if (node.isHighlighted()) {
            this.drawPointHighlight(mapViewPoint.getInView(), Math.max(n, n2));
        }
        float f = mapImage.getAlphaFloat();
        Graphics2D graphics2D = (Graphics2D)this.g.create();
        if (!Utils.equalsEpsilon(f, 1.0)) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        double d2 = Math.round(mapViewPoint.getInViewX());
        double d3 = Math.round(mapViewPoint.getInViewY());
        graphics2D.translate(d2, d3);
        graphics2D.rotate(d);
        int n3 = -n / 2 + mapImage.offsetX;
        int n4 = -n2 / 2 + mapImage.offsetY;
        graphics2D.drawImage((Image)mapImage.getImage(bl), n3, n4, this.nc);
        if (bl2 || bl3) {
            Color color = bl ? this.inactiveColor : (bl2 ? this.selectedColor : this.relationSelectedColor);
            graphics2D.setColor(color);
            graphics2D.draw(new Rectangle2D.Double(n3 - 2, n4 - 2, n + 4, n2 + 4));
        }
    }

    public void drawNodeSymbol(Node node, Symbol symbol, Color color, Color color2) {
        MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(node);
        if (node.isHighlighted()) {
            this.drawPointHighlight(mapViewPoint.getInView(), symbol.size);
        }
        if (color != null || color2 != null) {
            Shape shape = symbol.buildShapeAround(mapViewPoint.getInViewX(), mapViewPoint.getInViewY());
            if (color != null) {
                this.g.setColor(color);
                this.g.fill(shape);
            }
            if (symbol.stroke != null) {
                this.g.setStroke(symbol.stroke);
                this.g.setColor(color2);
                this.g.draw(shape);
                this.g.setStroke(new BasicStroke());
            }
        }
    }

    public void drawOrderNumber(Node node, Node node2, int n, Color color) {
        MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(node);
        MapViewState.MapViewPoint mapViewPoint2 = this.mapState.getPointFor(node2);
        this.drawOrderNumber(mapViewPoint, mapViewPoint2, n, color);
    }

    private void drawPathHighlight(MapViewPath mapViewPath, BasicStroke basicStroke) {
        if (mapViewPath == null) {
            return;
        }
        this.g.setColor(this.highlightColorTransparent);
        float f = basicStroke.getLineWidth() + (float)this.highlightLineWidth;
        if (this.useWiderHighlight) {
            f += (float)this.widerHighlight;
        }
        while (f >= basicStroke.getLineWidth()) {
            this.g.setStroke(new BasicStroke(f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit()));
            this.g.draw(mapViewPath);
            f -= (float)this.highlightStep;
        }
    }

    private void drawPointHighlight(Point2D point2D, int n) {
        this.g.setColor(this.highlightColorTransparent);
        int n2 = n + this.highlightPointRadius;
        if (this.useWiderHighlight) {
            n2 += this.widerHighlight;
        }
        while (n2 >= n) {
            int n3 = (int)Math.floor((double)n2 / 2.0);
            this.g.fill(new RoundRectangle2D.Double(point2D.getX() - (double)n3, point2D.getY() - (double)n3, n2, n2, n3, n3));
            n2 -= this.highlightStep;
        }
    }

    public void drawRestriction(Image image, Point point, double d, double d2, double d3, double d4, double d5, boolean bl) {
        Image image2 = ImageProvider.createRotatedImage(image, d5, new Dimension(16, 16));
        int n = image2.getWidth(null);
        int n2 = image2.getHeight(null);
        this.g.drawImage(image2, (int)((double)point.x + d + d2) - n / 2, (int)((double)point.y + d3 + d4) - n2 / 2, this.nc);
        if (bl) {
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : this.relationSelectedColor);
            this.g.drawRect((int)((double)point.x + d + d2) - n / 2 - 2, (int)((double)point.y + d3 + d4) - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawRestriction(Relation relation, MapImage mapImage, boolean bl) {
        void var8_13;
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        for (RelationMember primitiveId2 : relation.getMembers()) {
            if (primitiveId2.getMember().isIncomplete()) {
                return;
            }
            if (primitiveId2.isWay()) {
                object3 = primitiveId2.getWay();
                if (((Way)object3).getNodesCount() < 2) continue;
                switch (primitiveId2.getRole()) {
                    case "from": {
                        if (object4 != null) break;
                        object4 = object3;
                        break;
                    }
                    case "to": {
                        if (object5 != null) break;
                        object5 = object3;
                        break;
                    }
                    case "via": {
                        if (object6 != null) break;
                        object6 = object3;
                        break;
                    }
                }
                continue;
            }
            if (!primitiveId2.isNode()) continue;
            object3 = primitiveId2.getNode();
            if (object6 != null || !"via".equals(primitiveId2.getRole())) continue;
            object6 = object3;
        }
        if (object4 == null || object5 == null || object6 == null) {
            return;
        }
        if (object6 instanceof Node) {
            object2 = (Node)object6;
            if (!((Way)object4).isFirstLastNode((Node)object2)) {
                return;
            }
        } else {
            Way way = (Way)object6;
            object3 = way.firstNode();
            object = way.lastNode();
            Boolean bl2 = Boolean.FALSE;
            String string = way.get("oneway");
            if (string != null) {
                if ("-1".equals(string)) {
                    bl2 = Boolean.TRUE;
                    Object object7 = object3;
                    object3 = object;
                    object = object7;
                } else {
                    bl2 = Optional.ofNullable(OsmUtils.getOsmBoolean(string)).orElse(Boolean.FALSE);
                }
            }
            if (((Way)object4).isFirstLastNode((Node)object3)) {
                object2 = object3;
            } else if (!bl2.booleanValue() && ((Way)object4).isFirstLastNode((Node)object)) {
                object2 = object;
            } else {
                return;
            }
        }
        if (((Way)object4).firstNode() == object6) {
            Node node = ((Way)object4).getNode(1);
        } else {
            Node node = ((Way)object4).getNode(((Way)object4).getNodesCount() - 2);
        }
        object3 = this.nc.getPoint((Node)var8_13);
        object = this.nc.getPoint((Node)object2);
        double d = 14.0;
        double d2 = ((Point)object3).x >= ((Point)object).x ? (double)(((Point)object3).x - ((Point)object).x) : (double)(((Point)object).x - ((Point)object3).x);
        double d3 = ((Point)object3).y >= ((Point)object).y ? (double)(((Point)object3).y - ((Point)object).y) : (double)(((Point)object).y - ((Point)object3).y);
        double d4 = d2 == 0.0 ? 1.5707963267948966 : Math.atan(d3 / d2);
        double d5 = Math.toDegrees(d4);
        double d6 = d * Math.cos(d4);
        double d7 = d * Math.sin(d4);
        if (((Point)object3).x < ((Point)object).x) {
            d6 = -d6;
        }
        if (((Point)object3).y < ((Point)object).y) {
            d7 = -d7;
        }
        double d8 = 10.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            }
            d11 = 270.0 + d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            }
            d11 = 90.0 - d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            }
            d11 = 90.0 + d5;
        }
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            }
            d11 = 270.0 - d5;
        }
        this.drawRestriction(mapImage.getImage(bl), (Point)object, d6, d9, d7, d10, d11, relation.isSelected());
    }

    public void drawTextOnPath(Way way, TextLabel textLabel) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        Object object;
        Optional<HalfSegment> optional;
        if (way == null || textLabel == null) {
            return;
        }
        String string = textLabel.getString(way);
        if (string == null || string.isEmpty()) {
            return;
        }
        FontMetrics fontMetrics = this.g.getFontMetrics(textLabel.font);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.g);
        Rectangle rectangle = this.g.getClipBounds();
        List<MapViewState.MapViewPoint> list = way.getNodes().stream().map(this.mapState::getPointFor).collect(Collectors.toList());
        ArrayList<HalfSegment> arrayList = new ArrayList<HalfSegment>();
        double d6 = StyledMapRenderer.computePath(2.0 * (rectangle2D.getWidth() + 4.0), rectangle, list, arrayList);
        if (rectangle2D.getWidth() > d6) {
            return;
        }
        if (!arrayList.isEmpty()) {
            optional = arrayList.stream().max(Comparator.comparingDouble(halfSegment -> halfSegment.quality - 1.0E-5 * Math.abs(0.5 * (halfSegment.end + halfSegment.start) - 0.5 * d6)));
            if (!optional.isPresent()) {
                throw new IllegalStateException("Unable to find the segment with the best quality for " + way);
            }
            object = optional.get();
            d5 = ((HalfSegment)object).end - ((HalfSegment)object).start - rectangle2D.getWidth();
            d4 = Math.min(Math.max(0.2 * d5, 7.0), 0.5 * d5);
            if ((((HalfSegment)object).end + ((HalfSegment)object).start) / 2.0 < d6 / 2.0) {
                d3 = ((HalfSegment)object).end - d4;
                d2 = d3 - rectangle2D.getWidth();
            } else {
                d2 = ((HalfSegment)object).start + d4;
                d3 = d2 + rectangle2D.getWidth();
            }
        } else {
            d2 = d6 / 2.0 - rectangle2D.getWidth() / 2.0;
            d3 = d6 / 2.0 + rectangle2D.getWidth() / 2.0;
        }
        optional = (Optional<HalfSegment>)StyledMapRenderer.pointAt(d2 /= d6, list, d6);
        object = StyledMapRenderer.pointAt(d3 /= d6, list, d6);
        if (optional == null || object == null) {
            return;
        }
        if (optional[0] < object[0] && optional[2] < 1.5707963267948966 && optional[2] > -1.5707963267948966) {
            d5 = 0.0;
            d4 = 1.0;
            d = d2;
        } else {
            d5 = Math.PI;
            d4 = -1.0;
            d = d3;
        }
        List<GlyphVector> list2 = Utils.getGlyphVectorsBidi(string, textLabel.font, this.g.getFontRenderContext());
        double d7 = 0.0;
        for (GlyphVector glyphVector : list2) {
            double d8 = glyphVector.getLogicalBounds().getBounds2D().getWidth();
            for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
                Rectangle2D rectangle2D2 = glyphVector.getGlyphLogicalBounds(i).getBounds2D();
                double d9 = d + d4 * (d7 + rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0) / d6;
                double[] dArray = StyledMapRenderer.pointAt(d9, list, d6);
                if (dArray == null) continue;
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(dArray[0] - rectangle2D2.getX(), dArray[1]);
                affineTransform.rotate(dArray[2] + d5);
                double d10 = -rectangle2D2.getY() - rectangle2D2.getHeight() / 2.0 + (double)textLabel.yOffset;
                affineTransform.translate(-rectangle2D2.getWidth() / 2.0, d10);
                if (StyledMapRenderer.isGlyphVectorDoubleTranslationBug(textLabel.font)) {
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(-0.5 * affineTransform.getTranslateX(), -0.5 * affineTransform.getTranslateY());
                    affineTransform2.concatenate(affineTransform);
                    affineTransform = affineTransform2;
                }
                glyphVector.setGlyphTransform(i, affineTransform);
            }
            this.displayText(glyphVector, null, 0, 0, way.isDisabled(), textLabel);
            d7 += d8;
        }
    }

    private static double computePath(double d, Rectangle rectangle, List<MapViewState.MapViewPoint> list, List<HalfSegment> list2) {
        MapViewState.MapViewPoint mapViewPoint = list.get(0);
        double d2 = 0.0;
        for (MapViewState.MapViewPoint mapViewPoint2 : list.subList(1, list.size())) {
            double d3 = mapViewPoint2.distanceToInView(mapViewPoint);
            if (d3 > d) {
                Point2D.Double double_ = new Point2D.Double((mapViewPoint.getInViewX() + mapViewPoint2.getInViewX()) / 2.0, (mapViewPoint.getInViewY() + mapViewPoint2.getInViewY()) / 2.0);
                double d4 = StyledMapRenderer.computeQuality(rectangle, mapViewPoint, double_);
                list2.add(new HalfSegment(d2, d2 + d3 / 2.0, d4));
                d4 = 0.0;
                if (rectangle != null) {
                    if (rectangle.contains(double_) && rectangle.contains(mapViewPoint2.getInView())) {
                        d4 = 2.0;
                    } else if (rectangle.contains(double_) || rectangle.contains(mapViewPoint2.getInView())) {
                        d4 = 1.0;
                    }
                }
                list2.add(new HalfSegment(d2 + d3 / 2.0, d2 + d3, d4));
            }
            d2 += d3;
            mapViewPoint = mapViewPoint2;
        }
        return d2;
    }

    private static double computeQuality(Rectangle rectangle, MapViewState.MapViewPoint mapViewPoint, Point2D point2D) {
        double d = 0.0;
        if (rectangle != null) {
            if (rectangle.contains(mapViewPoint.getInView())) {
                d += 1.0;
            }
            if (rectangle.contains(point2D)) {
                d += 1.0;
            }
        }
        return d;
    }

    public void drawWay(Way way, Color color, BasicStroke basicStroke, BasicStroke basicStroke2, Color color2, float f, boolean bl, boolean bl3, boolean bl4, boolean bl5) {
        MapViewPath mapViewPath;
        MapViewPath mapViewPath2;
        Object object;
        List<Node> list;
        MapViewPath mapViewPath3 = new MapViewPath(this.mapState);
        MapViewPath mapViewPath4 = bl ? new MapViewPath(this.mapState) : null;
        Rectangle rectangle = this.g.getClipBounds();
        if (rectangle != null) {
            rectangle.grow(100, 100);
        }
        if ((list = way.getNodes()).size() < 2) {
            return;
        }
        if (!way.isHighlighted() && this.highlightWaySegments != null) {
            object = null;
            for (WaySegment waySegment : this.highlightWaySegments) {
                if (waySegment.way != way || (float)waySegment.lowerIndex < f) continue;
                if (object == null) {
                    object = new MapViewPath(this.mapState);
                }
                ((MapViewPath)object).moveTo(waySegment.getFirstNode());
                ((MapViewPath)object).lineTo(waySegment.getSecondNode());
            }
            this.drawPathHighlight((MapViewPath)object, basicStroke);
        }
        object = null;
        OffsetIterator offsetIterator = new OffsetIterator(list, f);
        boolean bl6 = true;
        while (offsetIterator.hasNext()) {
            MapViewState.MapViewPoint mapViewPoint3 = (MapViewState.MapViewPoint)offsetIterator.next();
            if (object != null) {
                MapViewState.MapViewPoint mapViewPoint4 = object;
                MapViewState.MapViewPoint mapViewPoint5 = mapViewPoint3;
                if (bl6) {
                    bl6 = false;
                    mapViewPath3.moveTo(mapViewPoint4);
                }
                mapViewPath3.lineTo(mapViewPoint5);
                if (bl3 ? !offsetIterator.hasNext() : bl) {
                    ArrowPaintHelper arrowPaintHelper = new ArrowPaintHelper(PHI, 10.0f + basicStroke.getLineWidth());
                    arrowPaintHelper.paintArrowAt(mapViewPath4, mapViewPoint5, mapViewPoint4);
                }
            }
            object = mapViewPoint3;
        }
        if (bl4) {
            mapViewPath2 = new MapViewPath(this.mapState);
            mapViewPath = new MapViewPath(this.mapState);
            double d = 60.0;
            mapViewPath3.visitClippedLine(0.0, 60.0, (d2, mapViewPoint, mapViewPoint2, bl2) -> {
                double d3 = mapViewPoint.distanceToInView(mapViewPoint2);
                if (d3 > 0.001) {
                    double d4 = (mapViewPoint2.getInViewX() - mapViewPoint.getInViewX()) / d3;
                    double d5 = (mapViewPoint2.getInViewY() - mapViewPoint.getInViewY()) / d3;
                    for (double d6 = d - d2 % d; d6 < d3; d6 += d) {
                        StyledMapRenderer.appenOnewayPath(bl5, mapViewPoint, d4, d5, d6, 3.0, mapViewPath);
                        StyledMapRenderer.appenOnewayPath(bl5, mapViewPoint, d4, d5, d6, 2.0, mapViewPath2);
                    }
                }
            });
        } else {
            mapViewPath2 = null;
            mapViewPath = null;
        }
        if (way.isHighlighted()) {
            this.drawPathHighlight(mapViewPath3, basicStroke);
        }
        this.displaySegments(mapViewPath3, mapViewPath4, mapViewPath2, mapViewPath, color, basicStroke, basicStroke2, color2);
    }

    private static void appenOnewayPath(boolean bl, MapViewState.MapViewPoint mapViewPoint, double d, double d2, double d3, double d4, Path2D path2D) {
        double d5 = (double)(-(bl ? -1 : 1)) * d4 * (1.0 + sinPHI) / (sinPHI * cosPHI);
        double d6 = d * d5;
        double d7 = d2 * d5;
        double d8 = mapViewPoint.getInViewX() + d * (d3 + (double)(bl ? -1 : 1) * (d4 / sinPHI));
        double d9 = mapViewPoint.getInViewY() + d2 * (d3 + (double)(bl ? -1 : 1) * (d4 / sinPHI));
        path2D.moveTo(d8, d9);
        path2D.lineTo(d8 + cosPHI * d6 - sinPHI * d7, d9 + sinPHI * d6 + cosPHI * d7);
        path2D.lineTo(d8 + cosPHI * d6 + sinPHI * d7, d9 - sinPHI * d6 + cosPHI * d7);
        path2D.lineTo(d8, d9);
    }

    public double getCircum() {
        return this.circum;
    }

    @Override
    public void getColors() {
        super.getColors();
        this.highlightColorTransparent = new Color(this.highlightColor.getRed(), this.highlightColor.getGreen(), this.highlightColor.getBlue(), 100);
        this.backgroundColor = PaintColors.getBackgroundColor();
    }

    @Override
    public void getSettings(boolean bl) {
        Object object;
        super.getSettings(bl);
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.circum = this.nc.getDist100Pixel();
        this.scale = this.nc.getScale();
        this.leftHandTraffic = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.useStrokes = (double)this.paintSettings.getUseStrokesDistance() > this.circum;
        this.showNames = (double)this.paintSettings.getShowNamesDistance() > this.circum;
        this.showIcons = (double)this.paintSettings.getShowIconsDistance() > this.circum;
        this.isOutlineOnly = this.paintSettings.isOutlineOnly();
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Droid Sans"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        this.antialiasing = Main.pref.getBoolean("mappaint.use-antialiasing", true) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing);
        switch (Main.pref.get("mappaint.text-antialiasing", "default")) {
            case "on": {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                break;
            }
            case "off": {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                break;
            }
            case "gasp": {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
                break;
            }
            case "lcd-hrgb": {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                break;
            }
            case "lcd-hbgr": {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
                break;
            }
            case "lcd-vrgb": {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
                break;
            }
            case "lcd-vbgr": {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
                break;
            }
            default: {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            }
        }
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        this.highlightLineWidth = Main.pref.getInteger("mappaint.highlight.width", 4);
        this.highlightPointRadius = Main.pref.getInteger("mappaint.highlight.radius", 7);
        this.widerHighlight = Main.pref.getInteger("mappaint.highlight.bigger-increment", 5);
        this.highlightStep = Main.pref.getInteger("mappaint.highlight.step", 4);
    }

    private static Path2D.Double getPath(Way way) {
        Path2D.Double double_ = new Path2D.Double();
        boolean bl = true;
        for (Node node : way.getNodes()) {
            EastNorth eastNorth = node.getEastNorth();
            if (eastNorth == null) continue;
            if (bl) {
                double_.moveTo(eastNorth.getX(), eastNorth.getY());
                bl = false;
                continue;
            }
            double_.lineTo(eastNorth.getX(), eastNorth.getY());
        }
        if (way.isClosed()) {
            double_.closePath();
        }
        return double_;
    }

    private static Path2D.Double getPFClip(Way way, double d) {
        Path2D.Double double_ = new Path2D.Double();
        StyledMapRenderer.buildPFClip(double_, way.getNodes(), d);
        return double_;
    }

    private static Path2D.Double getPFClip(Multipolygon.PolyData polyData, double d) {
        Path2D.Double double_ = new Path2D.Double();
        double_.setWindingRule(0);
        StyledMapRenderer.buildPFClip(double_, polyData.getNodes(), d);
        for (Multipolygon.PolyData polyData2 : polyData.getInners()) {
            StyledMapRenderer.buildPFClip(double_, polyData2.getNodes(), d);
        }
        return double_;
    }

    private static void buildPFClip(Path2D.Double double_, List<Node> list, double d) {
        EastNorth eastNorth;
        boolean bl = true;
        for (Node object : list) {
            eastNorth = object.getEastNorth();
            if (eastNorth == null) continue;
            if (bl) {
                double_.moveTo(eastNorth.getX(), eastNorth.getY());
                bl = false;
                continue;
            }
            double_.lineTo(eastNorth.getX(), eastNorth.getY());
        }
        if (list.size() >= 3) {
            EastNorth eastNorth2 = list.get(0).getEastNorth();
            EastNorth eastNorth3 = list.get(1).getEastNorth();
            eastNorth = list.get(list.size() - 1).getEastNorth();
            EastNorth eastNorth4 = list.get(list.size() - 2).getEastNorth();
            EastNorth eastNorth5 = StyledMapRenderer.getPFDisplacedEndPoint(eastNorth4, eastNorth, eastNorth2, d);
            EastNorth eastNorth6 = StyledMapRenderer.getPFDisplacedEndPoint(eastNorth3, eastNorth2, eastNorth5 != null ? eastNorth5 : eastNorth, d);
            if (eastNorth5 == null && eastNorth6 != null) {
                eastNorth5 = StyledMapRenderer.getPFDisplacedEndPoint(eastNorth4, eastNorth, eastNorth6, d);
            }
            if (eastNorth5 != null) {
                double_.lineTo(eastNorth5.getX(), eastNorth5.getY());
            }
            if (eastNorth6 != null) {
                double_.lineTo(eastNorth6.getX(), eastNorth6.getY());
            }
        }
    }

    private static EastNorth getPFDisplacedEndPoint(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, double d) {
        double d2;
        double d3 = eastNorth2.getX() - eastNorth.getX();
        double d4 = eastNorth2.getY() - eastNorth.getY();
        double d5 = eastNorth3.getX() - eastNorth2.getX();
        if (d3 * d5 + d4 * (d2 = eastNorth3.getY() - eastNorth2.getY()) < 0.0) {
            double d6 = Math.sqrt(d3 * d3 + d4 * d4);
            if (d6 == 0.0) {
                return null;
            }
            double d7 = -d4 * d / d6;
            double d8 = d3 * d / d6;
            if (d3 * d2 - d5 * d4 < 0.0) {
                d7 = -d7;
                d8 = -d8;
            }
            return new EastNorth(eastNorth2.getX() + d7, eastNorth2.getY() + d8);
        }
        return null;
    }

    private boolean isAreaVisible(Path2D.Double double_) {
        Rectangle2D rectangle2D = double_.getBounds2D();
        if (rectangle2D.isEmpty()) {
            return false;
        }
        MapViewState.MapViewPoint mapViewPoint = this.mapState.getPointFor(new EastNorth(rectangle2D.getX(), rectangle2D.getY()));
        if (mapViewPoint.getInViewX() > this.mapState.getViewWidth()) {
            return false;
        }
        if (mapViewPoint.getInViewY() < 0.0) {
            return false;
        }
        mapViewPoint = this.mapState.getPointFor(new EastNorth(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()));
        if (mapViewPoint.getInViewX() < 0.0) {
            return false;
        }
        return !(mapViewPoint.getInViewY() > this.mapState.getViewHeight());
    }

    public boolean isInactiveMode() {
        return this.isInactiveMode;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    private static double[] pointAt(double d, List<MapViewState.MapViewPoint> list, double d2) {
        double d3 = d * d2;
        double d4 = 0.0;
        for (int i = 1; i < list.size(); ++i) {
            double d5;
            double d6 = list.get(i).getInViewX() - list.get(i - 1).getInViewX();
            double d7 = Math.sqrt(d6 * d6 + (d5 = list.get(i).getInViewY() - list.get(i - 1).getInViewY()) * d5);
            if (d3 > d4 + d7) {
                d4 += d7;
                continue;
            }
            return new double[]{list.get(i - 1).getInViewX() + (d3 - d4) / d7 * d6, list.get(i - 1).getInViewY() + (d3 - d4) / d7 * d5, Math.atan2(d5, d6)};
        }
        return null;
    }

    public static int computeFlags(OsmPrimitive osmPrimitive, boolean bl) {
        if (osmPrimitive.isDisabled()) {
            return 1;
        }
        if (osmPrimitive.isSelected()) {
            return 4;
        }
        if (bl && osmPrimitive.isOuterMemberOfSelected()) {
            return 8;
        }
        if (osmPrimitive.isMemberOfSelected()) {
            return 2;
        }
        return 0;
    }

    public void setBenchmarkFactory(Supplier<RenderBenchmarkCollector> supplier) {
        this.benchmarkFactory = supplier;
    }

    @Override
    public void render(DataSet dataSet, boolean bl, Bounds bounds) {
        RenderBenchmarkCollector renderBenchmarkCollector = this.benchmarkFactory.get();
        BBox bBox = bounds.toBBox();
        this.getSettings(bl);
        dataSet.getReadLock().lock();
        try {
            this.highlightWaySegments = dataSet.getHighlightedWaySegments();
            renderBenchmarkCollector.renderStart(this.circum);
            List<Node> list = dataSet.searchNodes(bBox);
            List<Way> list2 = dataSet.searchWays(bBox);
            List<Relation> list3 = dataSet.searchRelations(bBox);
            ArrayList<StyleRecord> arrayList = new ArrayList<StyleRecord>(list.size() + list2.size() + list3.size());
            THREAD_POOL.invoke(new ComputeStyleListWorker(this.circum, this.nc, list3, arrayList, Math.max(20, list3.size() / THREAD_POOL.getParallelism() / 3)));
            THREAD_POOL.invoke(new ComputeStyleListWorker(this.circum, this.nc, new CompositeList<Way>(list, list2), arrayList, Math.max(100, (list.size() + list2.size()) / THREAD_POOL.getParallelism() / 3)));
            if (!renderBenchmarkCollector.renderSort()) {
                return;
            }
            Collections.sort(arrayList);
            if (!renderBenchmarkCollector.renderDraw(arrayList)) {
                return;
            }
            for (StyleRecord styleRecord : arrayList) {
                this.paintRecord(styleRecord);
            }
            this.drawVirtualNodes(dataSet, bBox);
            renderBenchmarkCollector.renderDone();
        }
        catch (RuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("data", dataSet).put("circum", this.circum).put("scale", this.scale).put("paintSettings", this.paintSettings).put("renderVirtualNodes", bl);
        }
        finally {
            dataSet.getReadLock().unlock();
        }
    }

    private void paintRecord(StyleRecord styleRecord) {
        try {
            styleRecord.paintPrimitive(this.paintSettings, this);
        }
        catch (RuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("record", styleRecord);
        }
    }

    private static class ComputeStyleListWorker
    extends RecursiveTask<List<StyleRecord>>
    implements Visitor {
        private final transient List<? extends OsmPrimitive> input;
        private final transient List<StyleRecord> output;
        private final transient ElemStyles styles = MapPaintStyles.getStyles();
        private final int directExecutionTaskSize;
        private final double circum;
        private final NavigatableComponent nc;
        private final boolean drawArea;
        private final boolean drawMultipolygon;
        private final boolean drawRestriction;

        ComputeStyleListWorker(double d, NavigatableComponent navigatableComponent, List<? extends OsmPrimitive> list, List<StyleRecord> list2, int n) {
            this.circum = d;
            this.nc = navigatableComponent;
            this.input = list;
            this.output = list2;
            this.directExecutionTaskSize = n;
            this.drawArea = d <= (double)Main.pref.getInteger("mappaint.fillareas", 10000000);
            this.drawMultipolygon = this.drawArea && Main.pref.getBoolean("mappaint.multipolygon", true);
            this.drawRestriction = Main.pref.getBoolean("mappaint.restriction", true);
            this.styles.setDrawMultipolygon(this.drawMultipolygon);
        }

        @Override
        protected List<StyleRecord> compute() {
            if (this.input.size() <= this.directExecutionTaskSize) {
                return this.computeDirectly();
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.input.size(); i += this.directExecutionTaskSize) {
                int n = Math.min(i + this.directExecutionTaskSize, this.input.size());
                ArrayList<StyleRecord> arrayList2 = new ArrayList<StyleRecord>(this.directExecutionTaskSize);
                arrayList.add(new ComputeStyleListWorker(this.circum, this.nc, this.input.subList(i, n), arrayList2, this.directExecutionTaskSize).fork());
            }
            for (ForkJoinTask forkJoinTask : arrayList) {
                this.output.addAll((Collection)forkJoinTask.join());
            }
            return this.output;
        }

        public List<StyleRecord> computeDirectly() {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
            try {
                for (OsmPrimitive osmPrimitive : this.input) {
                    this.acceptDrawable(osmPrimitive);
                }
                List<StyleRecord> list = this.output;
                return list;
            }
            catch (RuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("input-size", this.input.size()).put("output-size", this.output.size());
            }
            finally {
                MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
            }
        }

        private void acceptDrawable(OsmPrimitive osmPrimitive) {
            try {
                if (osmPrimitive.isDrawable()) {
                    osmPrimitive.accept(this);
                }
            }
            catch (RuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("osm", osmPrimitive);
            }
        }

        @Override
        public void visit(Node node) {
            this.add(node, StyledMapRenderer.computeFlags(node, false));
        }

        @Override
        public void visit(Way way) {
            this.add(way, StyledMapRenderer.computeFlags(way, true));
        }

        @Override
        public void visit(Relation relation) {
            this.add(relation, StyledMapRenderer.computeFlags(relation, true));
        }

        @Override
        public void visit(Changeset changeset) {
            throw new UnsupportedOperationException();
        }

        public void add(Node node, int n) {
            StyleElementList styleElementList = this.styles.get(node, this.circum, this.nc);
            for (StyleElement styleElement : styleElementList) {
                this.output.add(new StyleRecord(styleElement, node, n));
            }
        }

        public void add(Relation relation, int n) {
            StyleElementList styleElementList = this.styles.get(relation, this.circum, this.nc);
            for (StyleElement styleElement : styleElementList) {
                if (this.drawMultipolygon && this.drawArea && styleElement instanceof AreaElement && (n & 1) == 0) {
                    this.output.add(new StyleRecord(styleElement, relation, n));
                    continue;
                }
                if (!this.drawRestriction || !(styleElement instanceof NodeElement)) continue;
                this.output.add(new StyleRecord(styleElement, relation, n));
            }
        }

        public void add(Way way, int n) {
            StyleElementList styleElementList = this.styles.get(way, this.circum, this.nc);
            for (StyleElement styleElement : styleElementList) {
                if ((!this.drawArea || (n & 1) != 0) && styleElement instanceof AreaElement) continue;
                this.output.add(new StyleRecord(styleElement, way, n));
            }
        }
    }

    private static class HalfSegment {
        final double start;
        final double end;
        final double quality;

        HalfSegment(double d, double d2, double d3) {
            this.start = d;
            this.end = d2;
            this.quality = d3;
        }

        public String toString() {
            return "HalfSegment [start=" + this.start + ", end=" + this.end + ", quality=" + this.quality + "]";
        }
    }

    public static class StyleRecord
    implements Comparable<StyleRecord> {
        private final StyleElement style;
        private final OsmPrimitive osm;
        private final int flags;

        StyleRecord(StyleElement styleElement, OsmPrimitive osmPrimitive, int n) {
            this.style = styleElement;
            this.osm = osmPrimitive;
            this.flags = n;
        }

        @Override
        public int compareTo(StyleRecord styleRecord) {
            if ((this.flags & 1) != 0 && (styleRecord.flags & 1) == 0) {
                return -1;
            }
            if ((this.flags & 1) == 0 && (styleRecord.flags & 1) != 0) {
                return 1;
            }
            int n = Float.compare(this.style.majorZIndex, styleRecord.style.majorZIndex);
            if (n != 0) {
                return n;
            }
            if (this.flags > styleRecord.flags) {
                return 1;
            }
            if (this.flags < styleRecord.flags) {
                return -1;
            }
            int n2 = Float.compare(this.style.zIndex, styleRecord.style.zIndex);
            if (n2 != 0) {
                return n2;
            }
            if (NodeElement.SIMPLE_NODE_ELEMSTYLE.equals(this.style) && !NodeElement.SIMPLE_NODE_ELEMSTYLE.equals(styleRecord.style)) {
                return 1;
            }
            if (!NodeElement.SIMPLE_NODE_ELEMSTYLE.equals(this.style) && NodeElement.SIMPLE_NODE_ELEMSTYLE.equals(styleRecord.style)) {
                return -1;
            }
            long l = this.osm.getUniqueId() - styleRecord.osm.getUniqueId();
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return Float.compare(this.style.objectZIndex, styleRecord.style.objectZIndex);
        }

        public StyleElement getStyle() {
            return this.style;
        }

        public void paintPrimitive(MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer) {
            this.style.paintPrimitive(this.osm, mapPaintSettings, styledMapRenderer, (this.flags & 4) != 0, (this.flags & 8) != 0, (this.flags & 2) != 0);
        }

        public String toString() {
            return "StyleRecord [style=" + this.style + ", osm=" + this.osm + ", flags=" + this.flags + "]";
        }
    }

    private class OffsetIterator
    implements Iterator<MapViewState.MapViewPoint> {
        private final List<Node> nodes;
        private final double offset;
        private int idx;
        private MapViewState.MapViewPoint prev;
        private double xPrev0;
        private double yPrev0;

        OffsetIterator(List<Node> list, double d) {
            this.nodes = list;
            this.offset = d;
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.nodes.size();
        }

        @Override
        public MapViewState.MapViewPoint next() {
            double d;
            double d2;
            double d3;
            double d4;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MapViewState.MapViewPoint mapViewPoint = this.getForIndex(this.idx);
            if (Math.abs(this.offset) < 0.1) {
                ++this.idx;
                return mapViewPoint;
            }
            double d5 = mapViewPoint.getInViewX();
            double d6 = mapViewPoint.getInViewY();
            if (this.idx == this.nodes.size() - 1) {
                ++this.idx;
                if (this.prev != null) {
                    return StyledMapRenderer.this.mapState.getForView(this.xPrev0 + d5 - this.prev.getInViewX(), this.yPrev0 + d6 - this.prev.getInViewY());
                }
                return mapViewPoint;
            }
            MapViewState.MapViewPoint mapViewPoint2 = this.getForIndex(this.idx + 1);
            double d7 = mapViewPoint2.getInViewX() - d5;
            double d8 = Math.sqrt(d7 * d7 + (d4 = mapViewPoint2.getInViewY() - d6) * d4);
            if (d8 < 1.0E-11) {
                d8 = 1.0;
            }
            double d9 = this.offset / d8;
            double d10 = d5 + d9 * d4;
            double d11 = d6 - d9 * d7;
            if (this.idx == 0) {
                ++this.idx;
                this.prev = mapViewPoint;
                this.xPrev0 = d10;
                this.yPrev0 = d11;
                return StyledMapRenderer.this.mapState.getForView(d10, d11);
            }
            double d12 = d5 - this.prev.getInViewX();
            double d13 = d6 - this.prev.getInViewY();
            double d14 = d7 * d13 - d12 * d4;
            double d15 = d7 * (d11 - this.yPrev0) - d4 * (d10 - this.xPrev0);
            if (Utils.equalsEpsilon(d14, 0.0) || Math.signum(d14) != Math.signum(d15)) {
                ++this.idx;
                this.prev = mapViewPoint;
                this.xPrev0 = d10;
                this.yPrev0 = d11;
                return StyledMapRenderer.this.mapState.getForView(d10, d11);
            }
            double d16 = d15 / d14;
            if (d16 < 0.0) {
                ++this.idx;
                this.prev = mapViewPoint;
                this.xPrev0 = d10;
                this.yPrev0 = d11;
                return StyledMapRenderer.this.mapState.getForView(d10, d11);
            }
            double d17 = this.xPrev0 + d16 * d12;
            double d18 = this.yPrev0 + d16 * d13;
            if (d16 > 1.0 && (d3 = (d2 = d17 - d5) * d2 + (d = d18 - d6) * d) > Math.abs(2.0 * this.offset * this.offset)) {
                double d19 = d10 - this.xPrev0;
                double d20 = d11 - this.yPrev0;
                double d21 = Math.sqrt(d19 * d19 + d20 * d20);
                d16 = 1.0 + Math.abs(this.offset / d21);
                double d22 = this.xPrev0 + d16 * d12;
                double d23 = this.yPrev0 + d16 * d13;
                this.xPrev0 = d22;
                this.yPrev0 = d23;
                double d24 = Math.sqrt(d3);
                double d25 = d5 + d / d24;
                double d26 = d6 - d2 / d24;
                this.prev = StyledMapRenderer.this.mapState.getForView(d25, d26);
                return StyledMapRenderer.this.mapState.getForView(d22, d23);
            }
            ++this.idx;
            this.prev = mapViewPoint;
            this.xPrev0 = d10;
            this.yPrev0 = d11;
            return StyledMapRenderer.this.mapState.getForView(d17, d18);
        }

        private MapViewState.MapViewPoint getForIndex(int n) {
            return StyledMapRenderer.this.mapState.getPointFor(this.nodes.get(n));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

