/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public abstract class CrossingWays
extends Test {
    protected static final int CROSSING_WAYS = 601;
    private static final String HIGHWAY = "highway";
    private static final String RAILWAY = "railway";
    private static final String WATERWAY = "waterway";
    private final Map<Point2D, List<WaySegment>> cellSegments = new HashMap<Point2D, List<WaySegment>>(1000);
    private final Map<List<Way>, List<WaySegment>> seenWays = new HashMap<List<Way>, List<WaySegment>>(50);

    public CrossingWays(String string) {
        super(string, I18n.tr("This test checks if two roads, railways, waterways or buildings crosses in the same layer, but are not connected by a node.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.cellSegments.clear();
        this.seenWays.clear();
    }

    @Override
    public void endTest() {
        super.endTest();
        this.cellSegments.clear();
        this.seenWays.clear();
    }

    static String getLayer(OsmPrimitive osmPrimitive) {
        String string = osmPrimitive.get("layer");
        if ("0".equals(string)) {
            string = null;
        }
        return string;
    }

    static boolean isCoastline(OsmPrimitive osmPrimitive) {
        return osmPrimitive.hasTag("natural", "water", "coastline") || osmPrimitive.hasTag("landuse", "reservoir");
    }

    static boolean isHighway(OsmPrimitive osmPrimitive) {
        return osmPrimitive.hasTagDifferent(HIGHWAY, "rest_area", "services");
    }

    static boolean isRailway(OsmPrimitive osmPrimitive) {
        return osmPrimitive.hasKey(RAILWAY) && !CrossingWays.isSubwayOrTramOrRazed(osmPrimitive);
    }

    static boolean isSubwayOrTramOrRazed(OsmPrimitive osmPrimitive) {
        return osmPrimitive.hasTag(RAILWAY, "subway", "tram", "razed");
    }

    static boolean isProposedOrAbandoned(OsmPrimitive osmPrimitive) {
        return osmPrimitive.hasTag(HIGHWAY, "proposed") || osmPrimitive.hasTag(RAILWAY, "proposed", "abandoned");
    }

    abstract boolean ignoreWaySegmentCombination(Way var1, Way var2);

    abstract String createMessage(Way var1, Way var2);

    @Override
    public void visit(Way way) {
        if (this instanceof SelfCrossing) {
            this.cellSegments.clear();
            this.seenWays.clear();
        }
        int n = way.getNodesCount();
        for (int i = 0; i < n - 1; ++i) {
            WaySegment waySegment = new WaySegment(way, i);
            EastNorth eastNorth = waySegment.getFirstNode().getEastNorth();
            EastNorth eastNorth2 = waySegment.getSecondNode().getEastNorth();
            if (eastNorth == null || eastNorth2 == null) {
                Main.warn("Crossing ways test skipped " + waySegment);
                continue;
            }
            for (List<WaySegment> list : CrossingWays.getSegments(this.cellSegments, eastNorth, eastNorth2)) {
                for (WaySegment waySegment2 : list) {
                    List<WaySegment> list2;
                    if (!waySegment.intersects(waySegment2) || this.ignoreWaySegmentCombination(waySegment.way, waySegment2.way)) continue;
                    ArrayList<Way> arrayList = new ArrayList<Way>();
                    arrayList.add(waySegment.way);
                    if (waySegment.way != waySegment2.way) {
                        arrayList.add(waySegment2.way);
                    }
                    if ((list2 = this.seenWays.get(arrayList)) == null) {
                        list2 = new ArrayList<WaySegment>();
                        list2.add(waySegment);
                        list2.add(waySegment2);
                        String string = this.createMessage(waySegment.way, waySegment2.way);
                        this.errors.add(TestError.builder(this, Severity.WARNING, 601).message(string).primitives(arrayList).highlightWaySegments(list2).build());
                        this.seenWays.put(arrayList, list2);
                        continue;
                    }
                    list2.add(waySegment);
                    list2.add(waySegment2);
                }
                list.add(waySegment);
            }
        }
    }

    public static List<List<WaySegment>> getSegments(Map<Point2D, List<WaySegment>> map, EastNorth eastNorth, EastNorth eastNorth2) {
        ArrayList<List<WaySegment>> arrayList = new ArrayList<List<WaySegment>>();
        for (Point2D point2D : ValUtil.getSegmentCells(eastNorth, eastNorth2, OsmValidator.griddetail)) {
            List<WaySegment> list = map.get(point2D);
            if (list == null) {
                list = new ArrayList<WaySegment>();
                map.put(point2D, list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static class SelfCrossing
    extends CrossingWays {
        Ways normalTest = new Ways();
        Barrier barrierTest = new Barrier();
        Boundaries boundariesTest = new Boundaries();

        public SelfCrossing() {
            super(I18n.tr("Self crossing", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && !this.normalTest.isPrimitiveUsable(osmPrimitive) && !this.barrierTest.isPrimitiveUsable(osmPrimitive) && !this.boundariesTest.isPrimitiveUsable(osmPrimitive);
        }

        @Override
        boolean ignoreWaySegmentCombination(Way way, Way way2) {
            return way != way2;
        }

        @Override
        String createMessage(Way way, Way way2) {
            return I18n.tr("Self-crossing ways", new Object[0]);
        }
    }

    public static class Barrier
    extends CrossingWays {
        public Barrier() {
            super(I18n.tr("Crossing barriers", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && osmPrimitive.hasKey("barrier");
        }

        @Override
        boolean ignoreWaySegmentCombination(Way way, Way way2) {
            return !Objects.equals(Barrier.getLayer(way), Barrier.getLayer(way2));
        }

        @Override
        String createMessage(Way way, Way way2) {
            return I18n.tr("Crossing barriers", new Object[0]);
        }
    }

    public static class Boundaries
    extends CrossingWays {
        public Boundaries() {
            super(I18n.tr("Crossing boundaries", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && osmPrimitive.hasKey("boundary") && (!(osmPrimitive instanceof Relation) || ((Relation)osmPrimitive).isMultipolygon() && !((Relation)osmPrimitive).hasIncompleteMembers());
        }

        @Override
        boolean ignoreWaySegmentCombination(Way way, Way way2) {
            return !Objects.equals(way.get("boundary"), way2.get("boundary"));
        }

        @Override
        String createMessage(Way way, Way way2) {
            return I18n.tr("Crossing boundaries", new Object[0]);
        }

        @Override
        public void visit(Relation relation) {
            for (Way way : relation.getMemberPrimitives(Way.class)) {
                this.visit(way);
            }
        }
    }

    public static class Ways
    extends CrossingWays {
        public Ways() {
            super(I18n.tr("Crossing ways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && !Ways.isProposedOrAbandoned(osmPrimitive) && (Ways.isHighway(osmPrimitive) || osmPrimitive.hasKey(CrossingWays.WATERWAY) || Ways.isRailway(osmPrimitive) || Ways.isCoastline(osmPrimitive) || Ways.isBuilding(osmPrimitive));
        }

        @Override
        boolean ignoreWaySegmentCombination(Way way, Way way2) {
            if (way == way2) {
                return false;
            }
            if (!Objects.equals(Ways.getLayer(way), Ways.getLayer(way2))) {
                return true;
            }
            if (way.hasKey(CrossingWays.HIGHWAY) && way2.hasKey(CrossingWays.HIGHWAY) && !Objects.equals(way.get("level"), way2.get("level"))) {
                return true;
            }
            if (Ways.isSubwayOrTramOrRazed(way2)) {
                return true;
            }
            if (Ways.isCoastline(way) != Ways.isCoastline(way2)) {
                return true;
            }
            if (way.hasTag(CrossingWays.WATERWAY, "river", "stream", "canal", "drain", "ditch") && way2.hasTag(CrossingWays.WATERWAY, "riverbank") || way2.hasTag(CrossingWays.WATERWAY, "river", "stream", "canal", "drain", "ditch") && way.hasTag(CrossingWays.WATERWAY, "riverbank")) {
                return true;
            }
            return Ways.isProposedOrAbandoned(way2);
        }

        @Override
        String createMessage(Way way, Way way2) {
            if (Ways.isBuilding(way)) {
                return I18n.tr("Crossing buildings", new Object[0]);
            }
            if (way.hasKey(CrossingWays.WATERWAY) && way2.hasKey(CrossingWays.WATERWAY)) {
                return I18n.tr("Crossing waterways", new Object[0]);
            }
            if (way.hasKey(CrossingWays.HIGHWAY) && way2.hasKey(CrossingWays.WATERWAY) || way2.hasKey(CrossingWays.HIGHWAY) && way.hasKey(CrossingWays.WATERWAY)) {
                return I18n.tr("Crossing waterway/highway", new Object[0]);
            }
            return I18n.tr("Crossing ways", new Object[0]);
        }
    }
}

