/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.ParametrizedEnumProperty;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.ShowHideButtonListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ToggleDialog
extends JPanel
implements ShowHideButtonListener,
Helpful,
AWTEventListener,
Destroyable,
Preferences.PreferenceChangedListener {
    public static final BooleanProperty PROP_DYNAMIC_BUTTONS = new BooleanProperty("dialog.dynamic.buttons", false);
    private final transient ParametrizedEnumProperty<ButtonHidingType> propButtonHiding = new ParametrizedEnumProperty<ButtonHidingType>(ButtonHidingType.class, ButtonHidingType.DYNAMIC){

        @Override
        protected String getKey(String ... stringArray) {
            return ToggleDialog.this.preferencePrefix + ".buttonhiding";
        }

        @Override
        protected ButtonHidingType parse(String string) {
            try {
                return (ButtonHidingType)((Object)super.parse(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.trace(illegalArgumentException);
                return Boolean.parseBoolean(string) ? ButtonHidingType.DYNAMIC : ButtonHidingType.ALWAYS_SHOWN;
            }
        }
    };
    protected final ToggleDialogAction toggleAction;
    protected String preferencePrefix;
    protected final String name;
    protected DialogsPanel dialogsPanel;
    protected TitleBar titleBar;
    protected boolean isShowing;
    protected boolean isDocked;
    protected boolean isCollapsed;
    protected ButtonHidingType buttonHiding;
    private int preferredHeight;
    protected JDialog detachedDialog;
    protected JToggleButton button;
    private JPanel buttonsPanel;
    private final transient List<Action> buttonActions = new ArrayList<Action>();
    protected JCheckBoxMenuItem windowMenuItem;
    private final JRadioButtonMenuItem alwaysShown = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Always shown", new Object[0])){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToggleDialog.this.setIsButtonHiding(ButtonHidingType.ALWAYS_SHOWN);
        }
    });
    private final JRadioButtonMenuItem dynamic = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Dynamic", new Object[0])){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToggleDialog.this.setIsButtonHiding(ButtonHidingType.DYNAMIC);
        }
    });
    private final JRadioButtonMenuItem alwaysHidden = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Always hidden", new Object[0])){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToggleDialog.this.setIsButtonHiding(ButtonHidingType.ALWAYS_HIDDEN);
        }
    });
    protected Class<? extends PreferenceSetting> preferenceClass;

    public ToggleDialog(String string, String string2, String string3, Shortcut shortcut, int n) {
        this(string, string2, string3, shortcut, n, false);
    }

    public ToggleDialog(String string, String string2, String string3, Shortcut shortcut, int n, boolean bl) {
        this(string, string2, string3, shortcut, n, bl, null);
    }

    public ToggleDialog(String string, String string2, String string3, Shortcut shortcut, int n, boolean bl, Class<? extends PreferenceSetting> clazz) {
        super(new BorderLayout());
        this.preferencePrefix = string2;
        this.name = string;
        this.preferenceClass = clazz;
        this.setPreferredSize(new Dimension(0, n));
        this.setMinimumSize(new Dimension(0, 0));
        this.preferredHeight = n;
        this.toggleAction = new ToggleDialogAction(string, "dialogs/" + string2, string3, shortcut);
        String string4 = "Dialog/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        this.toggleAction.putValue("help", string4.substring(0, string4.length() - 6));
        this.isShowing = Main.pref.getBoolean(this.preferencePrefix + ".visible", bl);
        this.isDocked = Main.pref.getBoolean(this.preferencePrefix + ".docked", true);
        this.isCollapsed = Main.pref.getBoolean(this.preferencePrefix + ".minimized", false);
        this.buttonHiding = this.propButtonHiding.get(new String[0]);
        this.titleBar = new TitleBar(string, string2);
        this.add((Component)this.titleBar, "North");
        this.setBorder(BorderFactory.createEtchedBorder());
        Main.redirectToMainContentPane(this);
        Main.pref.addPreferenceChangeListener(this);
        this.registerInWindowMenu();
    }

    protected void registerInWindowMenu() {
        this.windowMenuItem = MainMenu.addWithCheckbox(Main.main.menu.windowMenu, (JosmAction)this.getToggleAction(), MainMenu.WINDOW_MENU_GROUP.TOGGLE_DIALOG);
    }

    public void showDialog() {
        this.setIsShowing(true);
        if (!this.isDocked) {
            this.detach();
        } else {
            this.dock();
            this.setVisible(true);
        }
        this.setIsShowing(true);
        this.windowMenuItem.setState(true);
        this.toggleAction.putValue("selected", Boolean.FALSE);
        this.toggleAction.putValue("selected", Boolean.TRUE);
    }

    public void unfurlDialog() {
        if (this.isDialogInDefaultView()) {
            return;
        }
        if (this.isDialogInCollapsedView()) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        } else if (!this.isDialogShowing()) {
            this.showDialog();
            if (this.isDocked && this.isCollapsed) {
                this.expand();
            }
            if (this.isDocked) {
                this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, this);
            }
            this.showNotify();
        }
    }

    @Override
    public void buttonHidden() {
        if (((Boolean)this.toggleAction.getValue("selected")).booleanValue()) {
            this.toggleAction.actionPerformed(null);
        }
    }

    @Override
    public void buttonShown() {
        this.unfurlDialog();
    }

    public void hideDialog() {
        this.closeDetachedDialog();
        this.setVisible(false);
        this.windowMenuItem.setState(false);
        this.setIsShowing(false);
        this.toggleAction.putValue("selected", Boolean.FALSE);
    }

    protected void dock() {
        this.detachedDialog = null;
        this.titleBar.setVisible(true);
        this.setIsDocked(true);
    }

    protected void detach() {
        this.setContentVisible(true);
        this.setVisible(true);
        this.titleBar.setVisible(false);
        if (!GraphicsEnvironment.isHeadless()) {
            this.detachedDialog = new DetachedDialog();
            this.detachedDialog.setVisible(true);
        }
        this.setIsShowing(true);
        this.setIsDocked(false);
    }

    public void collapse() {
        if (!this.isDialogInDefaultView()) {
            throw new IllegalStateException();
        }
        this.setContentVisible(false);
        this.setIsCollapsed(true);
        this.setPreferredSize(new Dimension(0, 20));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.setMinimumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.titleBar.lblMinimized.setIcon(ImageProvider.get("misc", "minimized"));
    }

    protected void expand() {
        if (!this.isDialogInCollapsedView()) {
            throw new IllegalStateException();
        }
        this.setContentVisible(true);
        this.setIsCollapsed(false);
        this.setPreferredSize(new Dimension(0, this.preferredHeight));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.titleBar.lblMinimized.setIcon(ImageProvider.get("misc", "normal"));
    }

    protected void setContentVisible(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            if (component == this.titleBar || bl && component == this.buttonsPanel && this.buttonHiding == ButtonHidingType.ALWAYS_HIDDEN) continue;
            component.setVisible(bl);
        }
    }

    @Override
    public void destroy() {
        this.closeDetachedDialog();
        if (this.isShowing) {
            this.hideNotify();
        }
        Main.main.menu.windowMenu.remove(this.windowMenuItem);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        Main.pref.removePreferenceChangeListener(this);
        ToggleDialog.destroyComponents(this, false);
    }

    private static void destroyComponents(Component component, boolean bl) {
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                ToggleDialog.destroyComponents(component2, true);
            }
        }
        if (bl && component instanceof Destroyable) {
            ((Destroyable)((Object)component)).destroy();
        }
    }

    public void closeDetachedDialog() {
        if (this.detachedDialog != null) {
            this.detachedDialog.setVisible(false);
            this.detachedDialog.getContentPane().removeAll();
            this.detachedDialog.dispose();
        }
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public AbstractAction getToggleAction() {
        return this.toggleAction;
    }

    public String getPreferencePrefix() {
        return this.preferencePrefix;
    }

    public void setDialogsPanel(DialogsPanel dialogsPanel) {
        this.dialogsPanel = dialogsPanel;
    }

    @Override
    public String getName() {
        return "toggleDialog." + this.preferencePrefix;
    }

    public void setTitle(String string) {
        this.titleBar.setTitle(string);
        if (this.detachedDialog != null) {
            this.detachedDialog.setTitle(string);
        }
    }

    protected void setIsShowing(boolean bl) {
        this.isShowing = bl;
        Main.pref.put(this.preferencePrefix + ".visible", bl);
        this.stateChanged();
    }

    protected void setIsDocked(boolean bl) {
        if (this.buttonsPanel != null) {
            this.buttonsPanel.setVisible(!bl || this.buttonHiding != ButtonHidingType.ALWAYS_HIDDEN);
        }
        this.isDocked = bl;
        Main.pref.put(this.preferencePrefix + ".docked", bl);
        this.stateChanged();
    }

    protected void setIsCollapsed(boolean bl) {
        this.isCollapsed = bl;
        Main.pref.put(this.preferencePrefix + ".minimized", bl);
        this.stateChanged();
    }

    protected void setIsButtonHiding(ButtonHidingType buttonHidingType) {
        this.buttonHiding = buttonHidingType;
        this.propButtonHiding.put(buttonHidingType, new String[0]);
        this.refreshHidingButtons();
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public String helpTopic() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length() - 6);
        return "Dialog/" + string;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean isDialogShowing() {
        return this.isShowing;
    }

    public boolean isDialogInDefaultView() {
        return this.isShowing && this.isDocked && !this.isCollapsed;
    }

    public boolean isDialogInCollapsedView() {
        return this.isShowing && this.isDocked && this.isCollapsed;
    }

    public void setButton(JToggleButton jToggleButton) {
        this.button = jToggleButton;
    }

    public JToggleButton getButton() {
        return this.button;
    }

    protected Dimension getDefaultDetachedSize() {
        return new Dimension(this.dialogsPanel.getWidth(), this.preferredHeight);
    }

    protected void toggleButtonHook() {
    }

    protected boolean dockWhenClosingDetachedDlg() {
        return true;
    }

    protected void stateChanged() {
    }

    protected Component createLayout(Component component, boolean bl, Collection<SideButton> collection) {
        return this.createLayout(component, bl, collection, null);
    }

    @SafeVarargs
    protected final Component createLayout(Component serializable, boolean bl, Collection<SideButton> collection, Collection<SideButton> ... collectionArray) {
        Serializable serializable2;
        if (bl) {
            serializable2 = new JScrollPane((Component)serializable);
            if (!(serializable instanceof Scrollable)) {
                GuiHelper.setDefaultIncrement((JScrollPane)serializable2);
            }
            serializable = serializable2;
        }
        serializable2 = new LinkedList();
        ((LinkedList)serializable2).addFirst(collection);
        if (collectionArray != null) {
            ((LinkedList)serializable2).addAll(Arrays.asList(collectionArray));
        }
        this.add((Component)serializable, "Center");
        if (!((AbstractCollection)((Object)serializable2)).isEmpty() && ((LinkedList)serializable2).get(0) != null && !((Collection)((LinkedList)serializable2).get(0)).isEmpty()) {
            this.buttonsPanel = new JPanel(new GridLayout(((LinkedList)serializable2).size(), 1));
            Iterator iterator = ((AbstractSequentialList)((Object)serializable2)).iterator();
            while (iterator.hasNext()) {
                Collection collection2 = (Collection)iterator.next();
                if (collection2 == null) continue;
                JPanel jPanel = new JPanel(Main.pref.getBoolean("dialog.align.left", false) ? new FlowLayout(0) : new GridLayout(1, collection2.size()));
                this.buttonsPanel.add(jPanel);
                for (SideButton sideButton : collection2) {
                    jPanel.add(sideButton);
                    Action action = sideButton.getAction();
                    if (action != null) {
                        this.buttonActions.add(action);
                        continue;
                    }
                    Main.warn("Button " + sideButton + " doesn't have action defined");
                    Main.error(new Exception());
                }
            }
            this.add((Component)this.buttonsPanel, "South");
            this.dynamicButtonsPropertyChanged();
        } else {
            this.titleBar.buttonsHide.setVisible(false);
        }
        this.titleBar.registerMouseListener();
        return serializable;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent && this.isShowing() && !this.isCollapsed && this.isDocked && this.buttonHiding == ButtonHidingType.DYNAMIC && this.buttonsPanel != null) {
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(this.getLocationOnScreen());
            if (rectangle.contains(((MouseEvent)aWTEvent).getLocationOnScreen())) {
                if (!this.buttonsPanel.isVisible()) {
                    this.buttonsPanel.setVisible(true);
                }
            } else if (this.buttonsPanel.isVisible()) {
                this.buttonsPanel.setVisible(false);
            }
        }
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(PROP_DYNAMIC_BUTTONS.getKey())) {
            this.dynamicButtonsPropertyChanged();
        }
    }

    private void dynamicButtonsPropertyChanged() {
        boolean bl = PROP_DYNAMIC_BUTTONS.get();
        if (bl) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        this.titleBar.buttonsHide.setVisible(bl);
        this.refreshHidingButtons();
    }

    private void refreshHidingButtons() {
        this.titleBar.buttonsHide.setIcon(ImageProvider.get("misc", this.buttonHiding != ButtonHidingType.ALWAYS_SHOWN ? "buttonhide" : "buttonshow"));
        this.titleBar.buttonsHide.setEnabled(this.buttonHiding != ButtonHidingType.ALWAYS_HIDDEN);
        if (this.buttonsPanel != null) {
            this.buttonsPanel.setVisible(this.buttonHiding != ButtonHidingType.ALWAYS_HIDDEN || !this.isDocked);
        }
        this.stateChanged();
    }

    private class DetachedDialog
    extends JDialog {
        DetachedDialog() {
            super(GuiHelper.getFrameForComponent(Main.parent));
            this.getContentPane().add(ToggleDialog.this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    DetachedDialog.this.rememberGeometry();
                    DetachedDialog.this.getContentPane().removeAll();
                    DetachedDialog.this.dispose();
                    if (ToggleDialog.this.dockWhenClosingDetachedDlg()) {
                        ToggleDialog.this.dock();
                        if (ToggleDialog.this.isDialogInCollapsedView()) {
                            ToggleDialog.this.expand();
                        }
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
                    } else {
                        ToggleDialog.this.hideDialog();
                        ToggleDialog.this.hideNotify();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    DetachedDialog.this.rememberGeometry();
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    DetachedDialog.this.rememberGeometry();
                }
            });
            try {
                new WindowGeometry(ToggleDialog.this.preferencePrefix + ".geometry").applySafe(this);
            }
            catch (WindowGeometry.WindowGeometryException windowGeometryException) {
                Main.debug(windowGeometryException);
                ToggleDialog.this.setPreferredSize(ToggleDialog.this.getDefaultDetachedSize());
                this.pack();
                this.setLocationRelativeTo(Main.parent);
            }
            super.setTitle(ToggleDialog.this.titleBar.getTitle());
            HelpUtil.setHelpContext(this.getRootPane(), ToggleDialog.this.helpTopic());
        }

        protected void rememberGeometry() {
            if (ToggleDialog.this.detachedDialog != null && ToggleDialog.this.detachedDialog.isShowing()) {
                new WindowGeometry(ToggleDialog.this.detachedDialog).remember(ToggleDialog.this.preferencePrefix + ".geometry");
            }
        }
    }

    protected class TitleBar
    extends JPanel {
        private final JLabel lblMinimized;
        private final JLabel lblTitle;
        private final JComponent lblTitleWeak;
        private final JButton buttonsHide;
        private DialogPopupMenu popupMenu;

        public TitleBar(String string, String string2) {
            JButton jButton;
            this.setLayout(new GridBagLayout());
            this.lblMinimized = new JLabel(ImageProvider.get("misc", "normal"));
            this.add(this.lblMinimized);
            ImageIcon imageIcon = ImageProvider.get("dialogs", string2, ImageProvider.ImageSizes.SMALLICON);
            this.lblTitle = new JLabel("", imageIcon, 11);
            this.lblTitle.setIconTextGap(8);
            JPanel jPanel = new JPanel();
            jPanel.add(this.lblTitle);
            jPanel.setVisible(false);
            this.add((Component)jPanel, GBC.std());
            this.lblTitleWeak = new JComponent(){

                @Override
                public void paintComponent(Graphics graphics) {
                    TitleBar.this.lblTitle.paint(graphics);
                }
            };
            this.lblTitleWeak.setPreferredSize(new Dimension(Integer.MAX_VALUE, 20));
            this.lblTitleWeak.setMinimumSize(new Dimension(0, 20));
            this.add((Component)this.lblTitleWeak, GBC.std().fill(2));
            this.buttonsHide = new JButton(ImageProvider.get("misc", ToggleDialog.this.buttonHiding != ButtonHidingType.ALWAYS_SHOWN ? "buttonhide" : "buttonshow"));
            this.buttonsHide.setToolTipText(I18n.tr("Toggle dynamic buttons", new Object[0]));
            this.buttonsHide.setBorder(BorderFactory.createEmptyBorder());
            this.buttonsHide.addActionListener(actionEvent -> {
                JRadioButtonMenuItem jRadioButtonMenuItem = ToggleDialog.this.buttonHiding == ButtonHidingType.DYNAMIC ? ToggleDialog.this.alwaysShown : ToggleDialog.this.dynamic;
                jRadioButtonMenuItem.setSelected(true);
                jRadioButtonMenuItem.getAction().actionPerformed(null);
            });
            this.add(this.buttonsHide);
            if (ToggleDialog.this.preferenceClass != null) {
                jButton = new JButton(ImageProvider.get("preference", ImageProvider.ImageSizes.SMALLICON));
                jButton.setToolTipText(I18n.tr("Open preferences for this panel", new Object[0]));
                jButton.setBorder(BorderFactory.createEmptyBorder());
                jButton.addActionListener(actionEvent -> {
                    PreferenceDialog preferenceDialog = new PreferenceDialog(Main.parent);
                    if (TabPreferenceSetting.class.isAssignableFrom(ToggleDialog.this.preferenceClass)) {
                        preferenceDialog.selectPreferencesTabByClass(ToggleDialog.this.preferenceClass);
                    } else if (SubPreferenceSetting.class.isAssignableFrom(ToggleDialog.this.preferenceClass)) {
                        preferenceDialog.selectSubPreferencesTabByClass(ToggleDialog.this.preferenceClass);
                    }
                    preferenceDialog.setVisible(true);
                });
                this.add(jButton);
            }
            jButton = new JButton(ImageProvider.get("misc", "sticky"));
            jButton.setToolTipText(I18n.tr("Undock the panel", new Object[0]));
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.addActionListener(actionEvent -> {
                ToggleDialog.this.detach();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
            });
            this.add(jButton);
            JButton jButton2 = new JButton(ImageProvider.get("misc", "close"));
            jButton2.setToolTipText(I18n.tr("Close this panel. You can reopen it with the buttons in the left toolbar.", new Object[0]));
            jButton2.setBorder(BorderFactory.createEmptyBorder());
            jButton2.addActionListener(actionEvent -> {
                ToggleDialog.this.hideDialog();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                ToggleDialog.this.hideNotify();
            });
            this.add(jButton2);
            this.setToolTipText(I18n.tr("Click to minimize/maximize the panel content", new Object[0]));
            this.setTitle(string);
        }

        public void setTitle(String string) {
            this.lblTitle.setText(string);
            this.lblTitleWeak.repaint();
        }

        public String getTitle() {
            return this.lblTitle.getText();
        }

        public final void registerMouseListener() {
            this.popupMenu = new DialogPopupMenu();
            this.addMouseListener(new MouseEventHandler());
        }

        class MouseEventHandler
        extends PopupMenuLauncher {
            MouseEventHandler() {
                super(TitleBar.this.popupMenu);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (ToggleDialog.this.isCollapsed) {
                        ToggleDialog.this.expand();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, ToggleDialog.this);
                    } else {
                        ToggleDialog.this.collapse();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                    }
                }
            }
        }

        public class DialogPopupMenu
        extends JPopupMenu {
            DialogPopupMenu() {
                ToggleDialog.this.alwaysShown.setSelected(ToggleDialog.this.buttonHiding == ButtonHidingType.ALWAYS_SHOWN);
                ToggleDialog.this.dynamic.setSelected(ToggleDialog.this.buttonHiding == ButtonHidingType.DYNAMIC);
                ToggleDialog.this.alwaysHidden.setSelected(ToggleDialog.this.buttonHiding == ButtonHidingType.ALWAYS_HIDDEN);
                ButtonGroup buttonGroup = new ButtonGroup();
                JMenu jMenu = new JMenu(I18n.tr("Side buttons", new Object[0]));
                for (JRadioButtonMenuItem jRadioButtonMenuItem : new JRadioButtonMenuItem[]{ToggleDialog.this.alwaysShown, ToggleDialog.this.dynamic, ToggleDialog.this.alwaysHidden}) {
                    buttonGroup.add(jRadioButtonMenuItem);
                    jMenu.add(jRadioButtonMenuItem);
                }
                this.add(jMenu);
                for (Action action : ToggleDialog.this.buttonActions) {
                    this.add(action);
                }
            }
        }
    }

    public final class ToggleDialogAction
    extends JosmAction {
        private ToggleDialogAction(String string, String string2, String string3, Shortcut shortcut) {
            super(string, string2, string3, shortcut, false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToggleDialog.this.toggleButtonHook();
            if (this.getValue("toolbarbutton") instanceof JButton) {
                ((JButton)this.getValue("toolbarbutton")).setSelected(!ToggleDialog.this.isShowing);
            }
            if (ToggleDialog.this.isShowing) {
                ToggleDialog.this.hideDialog();
                if (ToggleDialog.this.dialogsPanel != null) {
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                }
                ToggleDialog.this.hideNotify();
            } else {
                ToggleDialog.this.showDialog();
                if (ToggleDialog.this.isDocked && ToggleDialog.this.isCollapsed) {
                    ToggleDialog.this.expand();
                }
                if (ToggleDialog.this.isDocked && ToggleDialog.this.dialogsPanel != null) {
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
                }
                ToggleDialog.this.showNotify();
            }
        }

        public String toString() {
            return "ToggleDialogAction [" + ToggleDialog.this + ']';
        }
    }

    public static enum ButtonHidingType {
        ALWAYS_SHOWN,
        ALWAYS_HIDDEN,
        DYNAMIC;

    }
}

